/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl.tokens;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Objects;
import mb.p_raffrayi.actors.IActorRef;
import mb.p_raffrayi.impl.IUnit;
import mb.p_raffrayi.impl.tokens.ACloseLabel;
import mb.scopegraph.oopsla20.reference.EdgeOrData;

public final class CloseLabel<S, L, D>
extends ACloseLabel<S, L, D> {
    private final IActorRef<? extends IUnit<S, L, D, ?>> origin;
    private final S scope;
    private final EdgeOrData<L> label;
    private final transient int hashCode;

    private CloseLabel(IActorRef<? extends IUnit<S, L, D, ?>> origin, S scope, EdgeOrData<L> label) {
        this.origin = Objects.requireNonNull(origin, "origin");
        this.scope = Objects.requireNonNull(scope, "scope");
        this.label = Objects.requireNonNull(label, "label");
        this.hashCode = this.computeHashCode();
    }

    private CloseLabel(CloseLabel<S, L, D> original, IActorRef<? extends IUnit<S, L, D, ?>> origin, S scope, EdgeOrData<L> label) {
        this.origin = origin;
        this.scope = scope;
        this.label = label;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public IActorRef<? extends IUnit<S, L, D, ?>> origin() {
        return this.origin;
    }

    @Override
    public S scope() {
        return this.scope;
    }

    @Override
    public EdgeOrData<L> label() {
        return this.label;
    }

    public final CloseLabel<S, L, D> withOrigin(IActorRef<? extends IUnit<S, L, D, ?>> value) {
        if (this.origin == value) {
            return this;
        }
        IActorRef<? extends IUnit<S, L, D, ?>> newValue = Objects.requireNonNull(value, "origin");
        return new CloseLabel<S, L, D>(this, newValue, this.scope, this.label);
    }

    public final CloseLabel<S, L, D> withScope(S value) {
        if (this.scope == value) {
            return this;
        }
        S newValue = Objects.requireNonNull(value, "scope");
        return new CloseLabel<S, L, D>(this, this.origin, newValue, this.label);
    }

    public final CloseLabel<S, L, D> withLabel(EdgeOrData<L> value) {
        if (this.label == value) {
            return this;
        }
        EdgeOrData<L> newValue = Objects.requireNonNull(value, "label");
        return new CloseLabel<S, L, D>(this, this.origin, this.scope, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CloseLabel && this.equalTo((CloseLabel)another);
    }

    private boolean equalTo(CloseLabel<?, ?, ?> another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.origin.equals(another.origin) && this.scope.equals(another.scope) && this.label.equals(another.label);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.origin.hashCode();
        h += (h << 5) + this.scope.hashCode();
        h += (h << 5) + this.label.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CloseLabel").omitNullValues().add("origin", this.origin).add("scope", this.scope).add("label", this.label).toString();
    }

    public static <S, L, D> CloseLabel<S, L, D> of(IActorRef<? extends IUnit<S, L, D, ?>> origin, S scope, EdgeOrData<L> label) {
        return new CloseLabel<S, L, D>(origin, scope, label);
    }

    public static <S, L, D> CloseLabel<S, L, D> copyOf(ACloseLabel<S, L, D> instance) {
        if (instance instanceof CloseLabel) {
            return (CloseLabel)instance;
        }
        return CloseLabel.builder().from(instance).build();
    }

    public static <S, L, D> Builder<S, L, D> builder() {
        return new Builder();
    }

    /* synthetic */ CloseLabel(CloseLabel closeLabel, IActorRef iActorRef, Object object, EdgeOrData edgeOrData, CloseLabel closeLabel2) {
        this(closeLabel, iActorRef, object, edgeOrData);
    }

    public static final class Builder<S, L, D> {
        private static final long INIT_BIT_ORIGIN = 1L;
        private static final long INIT_BIT_SCOPE = 2L;
        private static final long INIT_BIT_LABEL = 4L;
        private long initBits = 7L;
        private IActorRef<? extends IUnit<S, L, D, ?>> origin;
        private S scope;
        private EdgeOrData<L> label;

        private Builder() {
        }

        public final Builder<S, L, D> from(ACloseLabel<S, L, D> instance) {
            Objects.requireNonNull(instance, "instance");
            this.origin(instance.origin());
            this.scope(instance.scope());
            this.label(instance.label());
            return this;
        }

        public final Builder<S, L, D> origin(IActorRef<? extends IUnit<S, L, D, ?>> origin) {
            this.origin = Objects.requireNonNull(origin, "origin");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<S, L, D> scope(S scope) {
            this.scope = Objects.requireNonNull(scope, "scope");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder<S, L, D> label(EdgeOrData<L> label) {
            this.label = Objects.requireNonNull(label, "label");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public CloseLabel<S, L, D> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CloseLabel(null, this.origin, this.scope, this.label, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("origin");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("scope");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("label");
            }
            return "Cannot build CloseLabel, some of required attributes are not set " + attributes;
        }
    }
}

