/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.nameresolution.tracing;

import java.util.Collection;
import java.util.Set;
import mb.p_raffrayi.IRecordedQuery;
import mb.p_raffrayi.nameresolution.tracing.ExtQuerySet;
import org.immutables.serial.Serial;
import org.immutables.value.Value;

@Value.Immutable
@Serial.Version(value=42L)
public abstract class AExtQuerySet<S, L, D> {
    @Value.Parameter
    public abstract Set<IRecordedQuery<S, L, D>> transitiveQueries();

    @Value.Parameter
    public abstract Set<IRecordedQuery<S, L, D>> predicateQueries();

    public ExtQuerySet<S, L, D> addTransitiveQueries(Collection<IRecordedQuery<S, L, D>> transitiveQueries) {
        ExtQuerySet self = (ExtQuerySet)this;
        if (transitiveQueries.isEmpty()) {
            return self;
        }
        ExtQuerySet.Builder<S, L, D> builder = ExtQuerySet.builder().from(self);
        builder.addAllTransitiveQueries(transitiveQueries);
        return builder.build();
    }

    public ExtQuerySet<S, L, D> addPredicateQueries(Collection<IRecordedQuery<S, L, D>> predicateQueries) {
        ExtQuerySet self = (ExtQuerySet)this;
        if (predicateQueries.isEmpty()) {
            return self;
        }
        ExtQuerySet.Builder<S, L, D> builder = ExtQuerySet.builder().from(self);
        builder.addAllPredicateQueries(predicateQueries);
        return builder.build();
    }

    public ExtQuerySet<S, L, D> addQueries(Collection<IRecordedQuery<S, L, D>> transitiveQueries, Collection<IRecordedQuery<S, L, D>> predicateQueries) {
        ExtQuerySet self = (ExtQuerySet)this;
        if (transitiveQueries.isEmpty() && predicateQueries.isEmpty()) {
            return self;
        }
        ExtQuerySet.Builder<S, L, D> builder = ExtQuerySet.builder().from(self);
        builder.addAllTransitiveQueries(transitiveQueries);
        builder.addAllPredicateQueries(predicateQueries);
        return builder.build();
    }

    public ExtQuerySet<S, L, D> addQueries(ExtQuerySet<S, L, D> queries) {
        return this.addQueries((Collection<IRecordedQuery<S, L, D>>)queries.transitiveQueries(), (Collection<IRecordedQuery<S, L, D>>)queries.predicateQueries());
    }
}

