/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api;

import java.io.Serializable;
import mb.pie.api.ExecContext;
import mb.pie.api.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MappedFunctionInput<B extends Serializable, T extends Serializable, R extends @Nullable Serializable>
implements Function<B, R> {
    private final Function<T, R> function;
    private final Function<? super B, ? extends T> before;

    public MappedFunctionInput(Function<T, R> function, Function<? super B, ? extends T> before) {
        this.function = function;
        this.before = before;
    }

    @Override
    public R apply(ExecContext context, B input) {
        T newInput = this.before.apply(context, input);
        return this.function.apply(context, newInput);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappedFunctionInput mappedFunctionInput = (MappedFunctionInput)o;
        if (!this.function.equals(mappedFunctionInput.function)) {
            return false;
        }
        return this.before.equals(mappedFunctionInput.before);
    }

    public int hashCode() {
        int result = this.function.hashCode();
        result = 31 * result + this.before.hashCode();
        return result;
    }

    public String toString() {
        return "MappedFunctionInput(" + this.function + ", " + this.before + ")";
    }
}

