/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.hierarchical;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import mb.resource.ResourceRuntimeException;
import mb.resource.hierarchical.PathNormalizerUtil;
import mb.resource.util.SeparatorUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SegmentsIdentifier
implements Serializable {
    private final @Nullable String root;
    private final List<String> segments;

    public SegmentsIdentifier(@Nullable String root, List<String> segments) {
        this.root = root;
        this.segments = segments;
    }

    public SegmentsIdentifier(List<String> segments) {
        this(null, segments);
    }

    public SegmentsIdentifier(String root) {
        this(root, new ArrayList<String>());
    }

    public static SegmentsIdentifier fromString(String str) {
        String[] segments = SeparatorUtil.splitWithUnixSeparator(str);
        String root = SeparatorUtil.startsWithUnixSeparator(str) ? "/" : null;
        return new SegmentsIdentifier(root, Arrays.asList(segments));
    }

    public boolean isAbsolute() {
        return this.root != null;
    }

    public int getSegmentCount() {
        return this.segments.size();
    }

    public Iterable<String> getSegments() {
        return this.segments;
    }

    public boolean startsWith(SegmentsIdentifier prefix) {
        if (this.segments.size() < prefix.segments.size()) {
            return false;
        }
        for (int i = 0; i < prefix.segments.size(); ++i) {
            if (prefix.segments.get(i).equals(this.segments.get(i))) continue;
            return false;
        }
        return true;
    }

    public @Nullable SegmentsIdentifier getParent() {
        int size = this.segments.size();
        if (size > 1) {
            return new SegmentsIdentifier(this.root, new ArrayList<String>(this.segments.subList(0, size - 1)));
        }
        if (size > 0 && this.root != null) {
            return new SegmentsIdentifier(this.root);
        }
        return null;
    }

    public @Nullable SegmentsIdentifier getRoot() {
        if (this.root != null) {
            return new SegmentsIdentifier(this.root);
        }
        return null;
    }

    public @Nullable String getLeaf() {
        int size = this.segments.size();
        if (size > 0) {
            return this.segments.get(size - 1);
        }
        return this.root;
    }

    public SegmentsIdentifier getNormalized() {
        ArrayList<String> newSegments = PathNormalizerUtil.normalize(this.segments, this.segments.size());
        return new SegmentsIdentifier(this.root, newSegments);
    }

    public SegmentsIdentifier relativize(SegmentsIdentifier other) {
        int segmentsSize = this.segments.size();
        if (segmentsSize > other.segments.size()) {
            throw new ResourceRuntimeException("Cannot relativize path '" + other + "' to this path '" + this + "', this path has more segments");
        }
        for (int i = 0; i < segmentsSize; ++i) {
            if (this.segments.get(i).equals(other.segments.get(i))) continue;
            throw new ResourceRuntimeException("Cannot relativize path '" + other + "' to this path '" + this + "', there is no common root");
        }
        return new SegmentsIdentifier(this.root, new ArrayList<String>(other.segments.subList(segmentsSize, other.segments.size())));
    }

    public SegmentsIdentifier appendSegment(String segment) {
        ArrayList<String> newSegments = new ArrayList<String>(this.segments.size() + 1);
        newSegments.addAll(this.segments);
        newSegments.add(segment);
        return new SegmentsIdentifier(this.root, newSegments);
    }

    public SegmentsIdentifier appendSegments(Iterable<String> segments) {
        ArrayList<String> newSegments = new ArrayList<String>(this.segments);
        segments.forEach(newSegments::add);
        return new SegmentsIdentifier(this.root, newSegments);
    }

    public SegmentsIdentifier appendSegments(Collection<String> segments) {
        ArrayList<String> newSegments = new ArrayList<String>(this.segments.size() + segments.size());
        newSegments.addAll(this.segments);
        newSegments.addAll(segments);
        return new SegmentsIdentifier(this.root, newSegments);
    }

    public SegmentsIdentifier appendSegments(String ... segments) {
        return this.appendSegments((Collection<String>)Arrays.asList(segments));
    }

    public SegmentsIdentifier appendAsRelativePath(String path) {
        String[] relativePathSegments = SeparatorUtil.splitWithUnixSeparator(path);
        return this.appendSegments(relativePathSegments);
    }

    public SegmentsIdentifier appendRelativePath(String relativePath) {
        if (SeparatorUtil.startsWithUnixSeparator(relativePath)) {
            throw new ResourceRuntimeException("Cannot append '" + relativePath + "', it is an absolute path");
        }
        String[] relativePathSegments = SeparatorUtil.splitWithUnixSeparator(relativePath);
        return this.appendSegments(relativePathSegments);
    }

    public SegmentsIdentifier appendOrReplaceWithPath(String other) {
        String[] relativePathSegments = SeparatorUtil.splitWithUnixSeparator(other);
        if (SeparatorUtil.startsWithUnixSeparator(other)) {
            return new SegmentsIdentifier("/", Arrays.asList(relativePathSegments));
        }
        return this.appendSegments(relativePathSegments);
    }

    public SegmentsIdentifier appendString(String other) {
        String[] pathSegments = SeparatorUtil.splitWithUnixSeparator(other);
        return this.appendSegments(pathSegments);
    }

    public SegmentsIdentifier appendRelativePath(SegmentsIdentifier relativePath) {
        if (relativePath.isAbsolute()) {
            throw new ResourceRuntimeException("Cannot append '" + relativePath + "', it is an absolute path");
        }
        return this.appendSegments((Collection<String>)relativePath.segments);
    }

    public SegmentsIdentifier appendOrReplaceWithPath(SegmentsIdentifier other) {
        if (other.isAbsolute()) {
            return other;
        }
        return this.appendSegments((Collection<String>)other.segments);
    }

    public SegmentsIdentifier replaceLeaf(String segment) {
        int size = this.segments.size();
        if (size > 0) {
            ArrayList<String> newSegments = new ArrayList<String>(this.segments);
            newSegments.set(size - 1, segment);
            return new SegmentsIdentifier(this.root, newSegments);
        }
        if (this.root != null) {
            return new SegmentsIdentifier(segment);
        }
        return this;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentsIdentifier that = (SegmentsIdentifier)o;
        return Objects.equals(this.root, that.root) && this.segments.equals(that.segments);
    }

    public int hashCode() {
        return Objects.hash(this.root, this.segments);
    }

    public String toString() {
        return (this.root != null ? this.root : "") + SeparatorUtil.joinWithUnixSeparator(this.segments);
    }
}

