/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.util;

import java.io.Serializable;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class AntPattern
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String SEPARATOR = "/";
    private static final char SEPARATOR_CHAR = '/';
    private final String[] tokenizedPattern;
    private final boolean isCaseSensitive;
    private static final String DEEP_TREE_MATCH = "**";

    public AntPattern(String pattern) {
        this(pattern, true);
    }

    public AntPattern(String pattern, boolean isCaseSensitive) {
        if (pattern.endsWith(SEPARATOR)) {
            pattern = pattern + DEEP_TREE_MATCH;
        }
        this.tokenizedPattern = AntPattern.tokenizePathAsArray(pattern);
        this.isCaseSensitive = isCaseSensitive;
    }

    public boolean match(String path) {
        return AntPattern.matchPath(this.tokenizedPattern, AntPattern.tokenizePathAsArray(path), this.isCaseSensitive);
    }

    private static boolean matchPath(String[] tokenizedPattern, String[] strDirs, boolean isCaseSensitive) {
        String patDir;
        int strIdxStart;
        int patIdxStart = 0;
        int patIdxEnd = tokenizedPattern.length - 1;
        int strIdxEnd = strDirs.length - 1;
        for (strIdxStart = 0; patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = tokenizedPattern[patIdxStart]).equals(DEEP_TREE_MATCH); ++patIdxStart, ++strIdxStart) {
            if (AntPattern.match(patDir, strDirs[strIdxStart], isCaseSensitive)) continue;
            return false;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i = patIdxStart; i <= patIdxEnd; ++i) {
                if (tokenizedPattern[i].equals(DEEP_TREE_MATCH)) continue;
                return false;
            }
            return true;
        }
        if (patIdxStart > patIdxEnd) {
            return false;
        }
        while (patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = tokenizedPattern[patIdxEnd]).equals(DEEP_TREE_MATCH)) {
            if (!AntPattern.match(patDir, strDirs[strIdxEnd], isCaseSensitive)) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i = patIdxStart; i <= patIdxEnd; ++i) {
                if (tokenizedPattern[i].equals(DEEP_TREE_MATCH)) continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i = patIdxStart + 1; i <= patIdxEnd; ++i) {
                if (!tokenizedPattern[i].equals(DEEP_TREE_MATCH)) continue;
                patIdxTmp = i;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i = 0; i <= strLength - patLength; ++i) {
                for (int j = 0; j < patLength; ++j) {
                    String subPat = tokenizedPattern[patIdxStart + j + 1];
                    String subStr = strDirs[strIdxStart + i + j];
                    if (!AntPattern.match(subPat, subStr, isCaseSensitive)) continue block6;
                }
                foundIdx = strIdxStart + i;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (int i = patIdxStart; i <= patIdxEnd; ++i) {
            if (tokenizedPattern[i].equals(DEEP_TREE_MATCH)) continue;
            return false;
        }
        return true;
    }

    private static boolean match(String pattern, String str, boolean caseSensitive) {
        char ch;
        int i;
        char[] patArr = pattern.toCharArray();
        char[] strArr = str.toCharArray();
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        boolean containsStar = false;
        for (i = 0; i < patArr.length; ++i) {
            if (patArr[i] != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (i = 0; i <= patIdxEnd; ++i) {
                char ch2 = patArr[i];
                if (ch2 == '?' || !AntPattern.different(caseSensitive, ch2, strArr[i])) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && AntPattern.different(caseSensitive, ch, strArr[strIdxStart])) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            return AntPattern.allStars(patArr, patIdxStart, patIdxEnd);
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && AntPattern.different(caseSensitive, ch, strArr[strIdxEnd])) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            return AntPattern.allStars(patArr, patIdxStart, patIdxEnd);
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i2 = patIdxStart + 1; i2 <= patIdxEnd; ++i2) {
                if (patArr[i2] != '*') continue;
                patIdxTmp = i2;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i3 = 0; i3 <= strLength - patLength; ++i3) {
                for (int j = 0; j < patLength; ++j) {
                    ch = patArr[patIdxStart + j + 1];
                    if (ch != '?' && AntPattern.different(caseSensitive, ch, strArr[strIdxStart + i3 + j])) continue block6;
                }
                foundIdx = strIdxStart + i3;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        return AntPattern.allStars(patArr, patIdxStart, patIdxEnd);
    }

    private static boolean allStars(char[] chars, int start, int end) {
        for (int i = start; i <= end; ++i) {
            if (chars[i] == '*') continue;
            return false;
        }
        return true;
    }

    private static boolean different(boolean caseSensitive, char ch, char other) {
        return caseSensitive ? ch != other : Character.toUpperCase(ch) != Character.toUpperCase(other);
    }

    private static String[] tokenizePathAsArray(String path) {
        @Nullable String root = null;
        if (AntPattern.isAbsolutePath(path)) {
            String[] s = AntPattern.dissect(path);
            root = s[0];
            path = s[1];
        }
        char sep = '/';
        int start = 0;
        int len = path.length();
        int count = 0;
        for (int pos = 0; pos < len; ++pos) {
            if (path.charAt(pos) != sep) continue;
            if (pos != start) {
                ++count;
            }
            start = pos + 1;
        }
        if (len != start) {
            ++count;
        }
        String[] l = new String[count + (root == null ? 0 : 1)];
        if (root != null) {
            l[0] = root;
            count = 1;
        } else {
            count = 0;
        }
        start = 0;
        for (int pos = 0; pos < len; ++pos) {
            if (path.charAt(pos) != sep) continue;
            if (pos != start) {
                String tok = path.substring(start, pos);
                l[count++] = tok;
            }
            start = pos + 1;
        }
        if (len != start) {
            String tok;
            l[count] = tok = path.substring(start);
        }
        return l;
    }

    private static boolean isAbsolutePath(String filename) {
        int len = filename.length();
        if (len == 0) {
            return false;
        }
        char c = filename.charAt(0);
        return c == '/';
    }

    private static String[] dissect(String path) {
        if (!AntPattern.isAbsolutePath(path)) {
            throw new RuntimeException(path + " is not an absolute path");
        }
        @Nullable String root = null;
        root = SEPARATOR;
        path = path.substring(1);
        return new String[]{root, path};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AntPattern that = (AntPattern)o;
        if (this.isCaseSensitive != that.isCaseSensitive) {
            return false;
        }
        return Arrays.equals(this.tokenizedPattern, that.tokenizedPattern);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.tokenizedPattern);
        result = 31 * result + (this.isCaseSensitive ? 1 : 0);
        return result;
    }

    public String toString() {
        return String.join((CharSequence)SEPARATOR, this.tokenizedPattern);
    }
}

