/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.oopsla20.diff;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import java.io.Serializable;
import java.util.Map;
import mb.scopegraph.oopsla20.diff.BiMap;
import mb.scopegraph.oopsla20.diff.Edge;
import org.metaborg.util.collection.CapsuleUtil;

public class ScopeGraphDiff<S, L, D>
implements Serializable {
    private static final long serialVersionUID = 3418653361380828262L;
    private final BiMap.Immutable<S> matchedScopes;
    private final BiMap.Immutable<Edge<S, L>> matchedEdges;
    private final Changes<S, L, D> added;
    private final Changes<S, L, D> removed;

    public ScopeGraphDiff(BiMap.Immutable<S> matchedScopes, BiMap.Immutable<Edge<S, L>> matchedEdges, Map.Immutable<S, D> addedScopes, Set.Immutable<Edge<S, L>> addedEdges, Map.Immutable<S, D> removedScopes, Set.Immutable<Edge<S, L>> removedEdges) {
        this.matchedScopes = matchedScopes;
        this.matchedEdges = matchedEdges;
        this.added = new Changes<S, L, D>(addedScopes, addedEdges);
        this.removed = new Changes<S, L, D>(removedScopes, removedEdges);
    }

    public BiMap.Immutable<S> matchedScopes() {
        return this.matchedScopes;
    }

    public BiMap.Immutable<Edge<S, L>> matchedEdges() {
        return this.matchedEdges;
    }

    public Changes<S, L, D> added() {
        return this.added;
    }

    public Changes<S, L, D> removed() {
        return this.removed;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ScopeGraphDiff:\n");
        sb.append("  matched scopes:\n");
        for (Map.Entry<S, S> entry : this.matchedScopes.entrySet()) {
            sb.append("    ").append(entry.getKey()).append(" ~ ").append(entry.getValue()).append("\n");
        }
        sb.append("  added:\n");
        sb.append(this.added);
        sb.append("  removed:\n");
        sb.append(this.removed);
        return sb.toString();
    }

    public static <S, L, D> ScopeGraphDiff<S, L, D> empty() {
        return new ScopeGraphDiff(BiMap.Immutable.of(), BiMap.Immutable.of(), CapsuleUtil.immutableMap(), CapsuleUtil.immutableSet(), CapsuleUtil.immutableMap(), CapsuleUtil.immutableSet());
    }

    public static class Changes<S, L, D>
    implements Serializable {
        private static final long serialVersionUID = 2717749458901328532L;
        private final Map.Immutable<S, D> scopes;
        private final Set.Immutable<Edge<S, L>> edges;

        public Changes(Map.Immutable<S, D> scopes, Set.Immutable<Edge<S, L>> edges) {
            this.scopes = scopes;
            this.edges = edges;
        }

        public Map.Immutable<S, D> scopes() {
            return this.scopes;
        }

        public Set.Immutable<Edge<S, L>> edges() {
            return this.edges;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("    scopes:\n");
            for (Map.Entry entry : this.scopes.entrySet()) {
                sb.append("    + ").append(entry.getKey());
                if (entry.getValue() != null) {
                    sb.append(" : ").append(entry.getValue());
                }
                sb.append("\n");
            }
            sb.append("    edges:\n");
            for (Edge edge : this.edges) {
                sb.append("    + ").append(edge).append("\n");
            }
            return sb.toString();
        }
    }
}

