/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.oopsla20.terms.path;

import io.usethesource.capsule.Set;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import mb.scopegraph.oopsla20.path.IScopePath;
import mb.scopegraph.oopsla20.terms.path.AComposedScopePath;
import org.metaborg.util.collection.ConsList;

final class ComposedScopePath<S, L>
extends AComposedScopePath<S, L>
implements Serializable {
    private final IScopePath<S, L> left;
    private final IScopePath<S, L> right;
    private int hashCode;
    private volatile transient long lazyInitBitmap;
    private static final long SOURCE_LAZY_INIT_BIT = 1L;
    private transient S source;
    private static final long TARGET_LAZY_INIT_BIT = 2L;
    private transient S target;
    private static final long SIZE_LAZY_INIT_BIT = 4L;
    private transient int size;
    private static final long SCOPES_LAZY_INIT_BIT = 8L;
    private transient ConsList<S> scopes;
    private static final long SCOPE_SET_LAZY_INIT_BIT = 16L;
    private transient Set.Immutable<S> scopeSet;
    private static final long LABELS_LAZY_INIT_BIT = 32L;
    private transient ConsList<L> labels;
    private static final long serialVersionUID = 42L;

    private ComposedScopePath(IScopePath<S, L> left, IScopePath<S, L> right) {
        this.left = Objects.requireNonNull(left, "left");
        this.right = Objects.requireNonNull(right, "right");
    }

    private ComposedScopePath(ComposedScopePath<S, L> original, IScopePath<S, L> left, IScopePath<S, L> right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public IScopePath<S, L> getLeft() {
        return this.left;
    }

    @Override
    public IScopePath<S, L> getRight() {
        return this.right;
    }

    public final ComposedScopePath<S, L> withLeft(IScopePath<S, L> value) {
        if (this.left == value) {
            return this;
        }
        IScopePath<S, L> newValue = Objects.requireNonNull(value, "left");
        return ComposedScopePath.validate(new ComposedScopePath<S, L>(this, newValue, this.right));
    }

    public final ComposedScopePath<S, L> withRight(IScopePath<S, L> value) {
        if (this.right == value) {
            return this;
        }
        IScopePath<S, L> newValue = Objects.requireNonNull(value, "right");
        return ComposedScopePath.validate(new ComposedScopePath<S, L>(this, this.left, newValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public S getSource() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ComposedScopePath composedScopePath = this;
            synchronized (composedScopePath) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.source = Objects.requireNonNull(super.getSource(), "source");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public S getTarget() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ComposedScopePath composedScopePath = this;
            synchronized (composedScopePath) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.target = Objects.requireNonNull(super.getTarget(), "target");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        if ((this.lazyInitBitmap & 4L) == 0L) {
            ComposedScopePath composedScopePath = this;
            synchronized (composedScopePath) {
                if ((this.lazyInitBitmap & 4L) == 0L) {
                    this.size = super.size();
                    this.lazyInitBitmap |= 4L;
                }
            }
        }
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsList<S> scopes() {
        if ((this.lazyInitBitmap & 8L) == 0L) {
            ComposedScopePath composedScopePath = this;
            synchronized (composedScopePath) {
                if ((this.lazyInitBitmap & 8L) == 0L) {
                    this.scopes = Objects.requireNonNull(super.scopes(), "scopes");
                    this.lazyInitBitmap |= 8L;
                }
            }
        }
        return this.scopes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set.Immutable<S> scopeSet() {
        if ((this.lazyInitBitmap & 0x10L) == 0L) {
            ComposedScopePath composedScopePath = this;
            synchronized (composedScopePath) {
                if ((this.lazyInitBitmap & 0x10L) == 0L) {
                    this.scopeSet = Objects.requireNonNull(super.scopeSet(), "scopeSet");
                    this.lazyInitBitmap |= 0x10L;
                }
            }
        }
        return this.scopeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsList<L> labels() {
        if ((this.lazyInitBitmap & 0x20L) == 0L) {
            ComposedScopePath composedScopePath = this;
            synchronized (composedScopePath) {
                if ((this.lazyInitBitmap & 0x20L) == 0L) {
                    this.labels = Objects.requireNonNull(super.labels(), "labels");
                    this.lazyInitBitmap |= 0x20L;
                }
            }
        }
        return this.labels;
    }

    public static <S, L> ComposedScopePath<S, L> of(IScopePath<S, L> left, IScopePath<S, L> right) {
        return ComposedScopePath.validate(new ComposedScopePath<S, L>(left, right));
    }

    private static <S, L> ComposedScopePath<S, L> validate(ComposedScopePath<S, L> instance) {
        instance = (ComposedScopePath)instance.check();
        return instance;
    }

    public static <S, L> ComposedScopePath<S, L> copyOf(AComposedScopePath<S, L> instance) {
        if (instance instanceof ComposedScopePath) {
            return (ComposedScopePath)instance;
        }
        return ComposedScopePath.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return ComposedScopePath.validate(this);
    }

    public static <S, L> Builder<S, L> builder() {
        return new Builder();
    }

    /* synthetic */ ComposedScopePath(ComposedScopePath composedScopePath, IScopePath iScopePath, IScopePath iScopePath2, ComposedScopePath composedScopePath2) {
        this(composedScopePath, iScopePath, iScopePath2);
    }

    public static final class Builder<S, L> {
        private static final long INIT_BIT_LEFT = 1L;
        private static final long INIT_BIT_RIGHT = 2L;
        private long initBits = 3L;
        private IScopePath<S, L> left;
        private IScopePath<S, L> right;

        private Builder() {
        }

        public final Builder<S, L> from(AComposedScopePath<S, L> instance) {
            Objects.requireNonNull(instance, "instance");
            this.left(instance.getLeft());
            this.right(instance.getRight());
            return this;
        }

        public final Builder<S, L> left(IScopePath<S, L> left) {
            this.left = Objects.requireNonNull(left, "left");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<S, L> right(IScopePath<S, L> right) {
            this.right = Objects.requireNonNull(right, "right");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ComposedScopePath<S, L> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ComposedScopePath.validate(new ComposedScopePath(null, this.left, this.right, null));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("left");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("right");
            }
            return "Cannot build ComposedScopePath, some of required attributes are not set " + attributes;
        }
    }
}

