/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.pepm16.terms;

import com.google.common.base.Preconditions;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.matching.TermMatch;
import mb.scopegraph.pepm16.IResolutionParameters;
import mb.scopegraph.pepm16.terms.Label;
import mb.scopegraph.pepm16.terms.ResolutionParameters;
import mb.scopegraph.regexp.IAlphabet;
import mb.scopegraph.regexp.IRegExp;
import mb.scopegraph.regexp.IRegExpBuilder;
import mb.scopegraph.regexp.impl.FiniteAlphabet;
import mb.scopegraph.regexp.impl.RegExpBuilder;
import mb.scopegraph.relations.IRelation;
import mb.scopegraph.relations.RelationDescription;
import mb.scopegraph.relations.RelationException;
import mb.scopegraph.relations.impl.Relation;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.tuple.Tuple2;

@Value.Immutable
@Serial.Version(value=42L)
public abstract class AResolutionParameters
implements IResolutionParameters<Label> {
    @Override
    @Value.Parameter
    public abstract IAlphabet<Label> getLabels();

    @Override
    @Value.Parameter
    public abstract Label getLabelD();

    @Override
    @Value.Parameter
    public abstract Label getLabelR();

    @Override
    @Value.Parameter
    public abstract IRegExp<Label> getPathWf();

    @Override
    @Value.Parameter
    public abstract IRelation.Immutable<Label> getSpecificityOrder();

    @Override
    @Value.Parameter
    public abstract IResolutionParameters.Strategy getStrategy();

    @Override
    @Value.Parameter
    public abstract boolean getPathRelevance();

    @Value.Check
    protected void check() {
        Preconditions.checkArgument((boolean)this.getLabels().contains(this.getLabelD()));
    }

    public static TermMatch.IMatcher<ResolutionParameters> matcher() {
        return (term, unifier) -> TermMatch.IMatcher.flatten(TermMatch.M.tuple5(AResolutionParameters.matchLabels(), TermMatch.M.term(), AResolutionParameters.matchOrder(), AResolutionParameters.matchStrategy(), AResolutionParameters.matchRelevance(), (t, labels, wfTerm, order, strategy, relevance) -> {
            RegExpBuilder<Label> builder = new RegExpBuilder<Label>();
            return AResolutionParameters.matchWf(builder).match((ITerm)wfTerm, unifier).map(wf -> ResolutionParameters.of(labels, Label.D, Label.R, wf, order, strategy, relevance));
        })).match(term, unifier);
    }

    private static TermMatch.IMatcher<IAlphabet<Label>> matchLabels() {
        return TermMatch.M.listElems(Label.matcher(), (l, ls) -> new FiniteAlphabet(ls));
    }

    private static TermMatch.IMatcher<IRelation.Immutable<Label>> matchOrder() {
        TermMatch.IMatcher<Label> m_label = Label.matcher();
        return TermMatch.M.listElems(TermMatch.M.appl2("", m_label, m_label, (t, l1, l2) -> Tuple2.of(l1, l2)), (t, ps) -> {
            IRelation.Transient<Label> order = Relation.Transient.of(RelationDescription.STRICT_PARTIAL_ORDER);
            for (Tuple2 p : ps) {
                try {
                    order.add((Label)p._1(), (Label)p._2());
                }
                catch (RelationException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            return order.freeze();
        });
    }

    private static TermMatch.IMatcher<IRegExp<Label>> matchWf(IRegExpBuilder<Label> builder) {
        return TermMatch.M.casesFix(m -> Iterables2.from(TermMatch.M.appl0("Empty", t -> (IRegExp)builder.emptySet()), TermMatch.M.appl0("Epsilon", t -> (IRegExp)builder.emptyString()), TermMatch.M.appl1("Closure", m, (t, re) -> (IRegExp)builder.closure((IRegExp<Label>)re)), TermMatch.M.appl2("Concat", m, m, (t, re1, re2) -> (IRegExp)builder.concat((IRegExp<Label>)re1, (IRegExp<Label>)re2)), TermMatch.M.appl2("And", m, m, (t, re1, re2) -> (IRegExp)builder.and((IRegExp<Label>)re1, (IRegExp<Label>)re2)), TermMatch.M.appl2("Or", m, m, (t, re1, re2) -> (IRegExp)builder.or((IRegExp<Label>)re1, (IRegExp<Label>)re2)), Label.matcher(l -> (IRegExp)builder.symbol((Label)l))));
    }

    private static TermMatch.IMatcher<IResolutionParameters.Strategy> matchStrategy() {
        return TermMatch.M.cases(TermMatch.M.appl0("Search", t -> IResolutionParameters.Strategy.SEARCH), TermMatch.M.appl0("Environments", t -> IResolutionParameters.Strategy.ENVIRONMENTS));
    }

    private static TermMatch.IMatcher<Boolean> matchRelevance() {
        return TermMatch.M.casesFix(m -> Iterables2.from(TermMatch.M.appl0("Relevant", t -> true), TermMatch.M.appl0("Irrelevant", t -> false)));
    }

    public static ResolutionParameters getDefault() {
        IRelation.Transient<Label> order;
        FiniteAlphabet<Label> labels = new FiniteAlphabet<Label>(Label.D, Label.P, Label.I);
        RegExpBuilder R2 = new RegExpBuilder();
        Object wf = R2.concat((IRegExp)R2.closure((IRegExp)R2.symbol(Label.P)), (IRegExp)R2.closure((IRegExp)R2.symbol(Label.I)));
        try {
            order = Relation.Transient.of(RelationDescription.STRICT_PARTIAL_ORDER);
            order.add(Label.D, Label.I);
            order.add(Label.I, Label.P);
        }
        catch (RelationException e) {
            throw new IllegalStateException(e);
        }
        return ResolutionParameters.of(labels, Label.D, Label.R, (IRegExp<Label>)wf, order.freeze(), IResolutionParameters.Strategy.SEARCH, true);
    }
}

