/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints.messages;

import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.statix.constraints.messages.IMessagePart;
import org.metaborg.util.functions.Action1;

public class TermPart
implements IMessagePart,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ITerm term;

    public TermPart(ITerm term) {
        this.term = term;
    }

    @Override
    public String toString(TermFormatter formatter) {
        return formatter.format(this.term);
    }

    @Override
    public void visitVars(Action1<ITermVar> onVar) {
        this.term.getVars().forEach(onVar::apply);
    }

    @Override
    public IMessagePart apply(ISubstitution.Immutable subst) {
        return new TermPart(subst.apply(this.term));
    }

    @Override
    public IMessagePart apply(IRenaming subst) {
        return new TermPart(subst.apply(this.term));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(this.term);
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TermPart termPart = (TermPart)o;
        return Objects.equals(this.term, termPart.term);
    }

    public int hashCode() {
        return Objects.hash(this.term);
    }
}

