/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import io.usethesource.capsule.util.stream.CapsuleCollectors;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.stratego.TermIndex;
import mb.nabl2.terms.stratego.TermOrigin;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.substitution.Renaming;
import mb.nabl2.terms.unification.OccursException;
import mb.nabl2.terms.unification.RigidException;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.terms.unification.ud.Diseq;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import mb.scopegraph.oopsla20.INameResolution;
import mb.scopegraph.oopsla20.IScopeGraph;
import mb.scopegraph.oopsla20.reference.EdgeOrData;
import mb.scopegraph.oopsla20.reference.Env;
import mb.scopegraph.oopsla20.reference.IncompleteException;
import mb.scopegraph.oopsla20.reference.ResolutionException;
import mb.scopegraph.oopsla20.reference.ResolutionInterpreter;
import mb.statix.constraints.CArith;
import mb.statix.constraints.CAstId;
import mb.statix.constraints.CAstProperty;
import mb.statix.constraints.CConj;
import mb.statix.constraints.CEqual;
import mb.statix.constraints.CExists;
import mb.statix.constraints.CFalse;
import mb.statix.constraints.CInequal;
import mb.statix.constraints.CNew;
import mb.statix.constraints.CTellEdge;
import mb.statix.constraints.CTrue;
import mb.statix.constraints.CTry;
import mb.statix.constraints.CUser;
import mb.statix.constraints.Constraints;
import mb.statix.constraints.IResolveQuery;
import mb.statix.constraints.messages.IMessage;
import mb.statix.constraints.messages.MessageKind;
import mb.statix.constraints.messages.MessageUtil;
import mb.statix.scopegraph.AScope;
import mb.statix.scopegraph.Scope;
import mb.statix.solver.ConstraintContext;
import mb.statix.solver.CriticalEdge;
import mb.statix.solver.Delay;
import mb.statix.solver.IConstraint;
import mb.statix.solver.IConstraintStore;
import mb.statix.solver.IState;
import mb.statix.solver.ITermProperty;
import mb.statix.solver.completeness.Completeness;
import mb.statix.solver.completeness.CompletenessUtil;
import mb.statix.solver.completeness.ICompleteness;
import mb.statix.solver.completeness.IsComplete;
import mb.statix.solver.log.IDebugContext;
import mb.statix.solver.log.LazyDebugContext;
import mb.statix.solver.log.NullDebugContext;
import mb.statix.solver.persistent.BagTermProperty;
import mb.statix.solver.persistent.SingletonTermProperty;
import mb.statix.solver.persistent.Solver;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.solver.persistent.query.ConstraintQueries;
import mb.statix.solver.query.QueryFilter;
import mb.statix.solver.query.QueryMin;
import mb.statix.solver.query.ResolutionDelayException;
import mb.statix.solver.store.BaseConstraintStore;
import mb.statix.spec.ApplyMode;
import mb.statix.spec.ApplyResult;
import mb.statix.spec.Rule;
import mb.statix.spec.RuleUtil;
import mb.statix.spec.Spec;
import mb.statix.spoofax.StatixTerms;
import org.metaborg.util.collection.MultiSet;
import org.metaborg.util.functions.Predicate2;
import org.metaborg.util.log.Level;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;
import org.metaborg.util.task.RateLimitedCancel;
import org.metaborg.util.tuple.Tuple2;
import org.metaborg.util.tuple.Tuple3;

class GreedySolver {
    private static final ImmutableSet<ITermVar> NO_UPDATED_VARS = ImmutableSet.of();
    private static final ImmutableList<IConstraint> NO_NEW_CONSTRAINTS = ImmutableList.of();
    private static final Completeness.Immutable NO_NEW_CRITICAL_EDGES = Completeness.Immutable.of();
    private static final ImmutableMap<ITermVar, ITermVar> NO_EXISTENTIALS = ImmutableMap.of();
    private static final int CANCEL_RATE = 42;
    private static final int MAX_DEPTH = 32;
    private final Spec spec;
    private final IDebugContext debug;
    private final IConstraintStore constraints;
    private final ConstraintContext params;
    private final IProgress progress;
    private final ICancel cancel;
    private final int flags;
    private IState.Immutable state;
    private ICompleteness.Immutable completeness;
    private Map<ITermVar, ITermVar> existentials = null;
    private final List<ITermVar> updatedVars = Lists.newArrayList();
    private final List<CriticalEdge> removedEdges = Lists.newArrayList();
    private final Map<IConstraint, IMessage> failed = Maps.newHashMap();
    private int solved = 0;
    private int criticalEdges = 0;

    public GreedySolver(Spec spec, IState.Immutable state, IConstraint initialConstraint, IsComplete _isComplete, IDebugContext debug, IProgress progress, ICancel cancel, int flags) {
        if (!spec.hasPrecomputedCriticalEdges()) {
            debug.warn("Leaving precomputing critical edges to solver may result in duplicate work.", new Object[0]);
            this.spec = spec.precomputeCriticalEdges();
        } else {
            this.spec = spec;
        }
        this.state = state;
        this.debug = debug;
        this.constraints = new BaseConstraintStore(debug);
        Completeness.Transient _completeness = Completeness.Transient.of();
        Tuple2<IConstraint, ICompleteness.Immutable> initialConstraintAndCriticalEdges = CompletenessUtil.precomputeCriticalEdges(initialConstraint, spec.scopeExtensions());
        this.constraints.add(initialConstraintAndCriticalEdges._1());
        _completeness.addAll(initialConstraintAndCriticalEdges._2(), state.unifier());
        this.completeness = _completeness.freeze();
        IsComplete isComplete = (s, l, st) -> this.completeness.isComplete((Scope)s, (EdgeOrData<ITerm>)l, st.unifier()) && _isComplete.test(s, l, st);
        this.params = new ConstraintContext(isComplete, debug);
        this.progress = progress;
        this.cancel = new RateLimitedCancel(cancel, 42);
        this.flags = flags;
    }

    public GreedySolver(Spec spec, IState.Immutable state, Iterable<IConstraint> constraints, Map<IConstraint, Delay> delays, ICompleteness.Immutable completeness, IsComplete _isComplete, IDebugContext debug, IProgress progress, ICancel cancel, int flags) {
        this.spec = spec;
        this.state = state;
        this.debug = debug;
        this.constraints = new BaseConstraintStore(debug);
        this.constraints.addAll(constraints);
        this.constraints.delayAll(delays.entrySet());
        this.completeness = completeness;
        IsComplete isComplete = (s, l, st) -> this.completeness.isComplete((Scope)s, (EdgeOrData<ITerm>)l, st.unifier()) && _isComplete.test(s, l, st);
        this.params = new ConstraintContext(isComplete, debug);
        this.progress = progress;
        this.cancel = new RateLimitedCancel(cancel, 42);
        this.flags = flags;
    }

    public SolverResult solve() throws InterruptedException {
        IConstraint constraint;
        this.debug.debug("Solving constraints", new Object[0]);
        while ((constraint = this.constraints.remove()) != null) {
            if (this.k(constraint, 32)) continue;
            this.debug.debug("Finished fast.", new Object[0]);
            return this.finishSolve();
        }
        if (this.constraints.activeSize() > 0) {
            this.debug.warn("Expected no remaining active constraints, but got ", this.constraints.activeSize());
        }
        return this.finishSolve();
    }

    protected SolverResult finishSolve() {
        Map<IConstraint, Delay> delayed = this.constraints.delayed();
        this.debug.debug("Solved constraints with {} failed and {} remaining constraint(s).", this.failed.size(), this.constraints.delayedSize());
        if (this.debug.isEnabled(Level.Debug)) {
            for (Map.Entry<IConstraint, Delay> entry : delayed.entrySet()) {
                Object[] objectArray = new Object[2];
                objectArray[0] = entry.getKey().toString(this.state.unifier()::toString);
                objectArray[1] = entry.getValue();
                this.debug.debug(" * {} on {}", objectArray);
            }
        }
        Map existentials = (Map)Optional.ofNullable(this.existentials).orElse((Map<ITermVar, ITermVar>)NO_EXISTENTIALS);
        return SolverResult.of(this.spec, this.state, this.failed, delayed, existentials, this.updatedVars, this.removedEdges, this.completeness).withTotalSolved(this.solved).withTotalCriticalEdges(this.criticalEdges);
    }

    private boolean success(IConstraint constraint, IState.Immutable newState, Collection<ITermVar> updatedVars, Collection<IConstraint> newConstraints, ICompleteness.Immutable newCriticalEdges, Map<ITermVar, ITermVar> existentials, int fuel) throws InterruptedException {
        ICompleteness.Transient _completeness;
        ++this.solved;
        this.state = newState;
        IDebugContext subDebug = this.debug.subContext();
        if (this.existentials == null) {
            this.existentials = existentials;
        }
        IUniDisunifier.Immutable unifier = this.state.unifier();
        if (!updatedVars.isEmpty()) {
            _completeness = this.completeness.melt();
            _completeness.updateAll(updatedVars, unifier);
            this.completeness = _completeness.freeze();
            this.constraints.activateFromVars(updatedVars, this.debug);
            this.updatedVars.addAll(updatedVars);
        }
        if (!newConstraints.isEmpty()) {
            _completeness = this.completeness.melt();
            _completeness.addAll(newCriticalEdges, unifier);
            this.completeness = _completeness.freeze();
            if (subDebug.isEnabled(Level.Debug) && !newConstraints.isEmpty()) {
                subDebug.debug("Simplified to:", new Object[0]);
                for (IConstraint newConstraint : newConstraints) {
                    subDebug.debug(" * {}", Solver.toString(newConstraint, unifier));
                }
            }
        }
        this.removeCompleteness(constraint);
        for (IConstraint newConstraint : newConstraints) {
            if (this.k(newConstraint, fuel - 1)) continue;
            return false;
        }
        return true;
    }

    private boolean delay(IConstraint constraint, Delay delay) {
        IDebugContext subDebug = this.debug.subContext();
        this.constraints.delay(constraint, delay);
        if (subDebug.isEnabled(Level.Debug)) {
            subDebug.debug("Delayed: {}", Solver.toString(constraint, this.state.unifier()));
        }
        return true;
    }

    private boolean fail(IConstraint constraint) {
        IMessage message = MessageUtil.findClosestMessage(constraint);
        this.failed.put(constraint, message);
        this.removeCompleteness(constraint);
        return message.kind() != MessageKind.ERROR || (this.flags & 1) == 0;
    }

    private void removeCompleteness(IConstraint constraint) {
        ICompleteness.Transient _completeness = this.completeness.melt();
        if (!constraint.ownCriticalEdges().isPresent()) {
            throw new IllegalArgumentException("Solver only accepts constraints with pre-computed critical edges.");
        }
        this.criticalEdges += constraint.ownCriticalEdges().get().entrySet().stream().mapToInt(e -> ((MultiSet.Immutable)e.getValue()).size()).sum();
        Set.Immutable<CriticalEdge> removedEdges = _completeness.removeAll(constraint.ownCriticalEdges().get(), this.state.unifier());
        this.completeness = _completeness.freeze();
        this.constraints.activateFromEdges((Iterable<? extends CriticalEdge>)removedEdges, this.debug);
        this.removedEdges.addAll((Collection<CriticalEdge>)removedEdges);
    }

    private boolean queue(IConstraint constraint) {
        this.constraints.add(constraint);
        return true;
    }

    private boolean k(final IConstraint constraint, final int fuel) throws InterruptedException {
        this.cancel.throwIfCancelled();
        if (fuel <= 0) {
            return this.queue(constraint);
        }
        if (this.debug.isEnabled(Level.Debug)) {
            this.debug.debug("Solving {}", constraint.toString(Solver.shallowTermFormatter(this.state.unifier(), 4)));
        }
        return constraint.matchOrThrow(new IConstraint.CheckedCases<Boolean, InterruptedException>(){

            @Override
            public Boolean caseArith(CArith c) throws InterruptedException {
                IUniDisunifier.Immutable unifier = GreedySolver.this.state.unifier();
                Optional<ITerm> term1 = c.expr1().isTerm();
                Optional<ITerm> term2 = c.expr2().isTerm();
                try {
                    if (c.op().isEquals() && term1.isPresent()) {
                        int i2 = c.expr2().eval(unifier);
                        CEqual eq = new CEqual(term1.get(), (ITerm)TermBuild.B.newInt(i2), c);
                        return GreedySolver.this.success(c, GreedySolver.this.state, (Collection)NO_UPDATED_VARS, (Collection)ImmutableList.of((Object)eq), NO_NEW_CRITICAL_EDGES, (Map)NO_EXISTENTIALS, fuel);
                    }
                    if (c.op().isEquals() && term2.isPresent()) {
                        int i1 = c.expr1().eval(unifier);
                        CEqual eq = new CEqual((ITerm)TermBuild.B.newInt(i1), term2.get(), c);
                        return GreedySolver.this.success(c, GreedySolver.this.state, (Collection)NO_UPDATED_VARS, (Collection)ImmutableList.of((Object)eq), NO_NEW_CRITICAL_EDGES, (Map)NO_EXISTENTIALS, fuel);
                    }
                    int i1 = c.expr1().eval(unifier);
                    int i2 = c.expr2().eval(unifier);
                    if (c.op().test(i1, i2)) {
                        return GreedySolver.this.success(c, GreedySolver.this.state, (Collection)NO_UPDATED_VARS, (Collection)NO_NEW_CONSTRAINTS, NO_NEW_CRITICAL_EDGES, (Map)NO_EXISTENTIALS, fuel);
                    }
                    return GreedySolver.this.fail(c);
                }
                catch (Delay d) {
                    return GreedySolver.this.delay(c, d);
                }
            }

            @Override
            public Boolean caseConj(CConj c) throws InterruptedException {
                return GreedySolver.this.success(c, GreedySolver.this.state, (Collection)NO_UPDATED_VARS, Constraints.disjoin(c), NO_NEW_CRITICAL_EDGES, (Map)NO_EXISTENTIALS, fuel);
            }

            @Override
            public Boolean caseEqual(CEqual c) throws InterruptedException {
                ITerm term1 = c.term1();
                ITerm term2 = c.term2();
                IDebugContext debug = GreedySolver.this.params.debug();
                IUniDisunifier.Immutable unifier = GreedySolver.this.state.unifier();
                try {
                    IUniDisunifier.Result result = unifier.unify(term1, term2, v -> GreedySolver.this.params.isRigid((ITermVar)v, GreedySolver.this.state)).orElse(null);
                    if (result != null) {
                        if (debug.isEnabled(Level.Debug)) {
                            debug.debug("Unification succeeded: {}", result.result());
                        }
                        IState.Immutable newState = GreedySolver.this.state.withUnifier(result.unifier());
                        Set.Immutable<ITermVar> updatedVars = ((IUnifier.Immutable)result.result()).domainSet();
                        return GreedySolver.this.success(c, newState, updatedVars, (Collection)NO_NEW_CONSTRAINTS, NO_NEW_CRITICAL_EDGES, (Map)NO_EXISTENTIALS, fuel);
                    }
                    if (debug.isEnabled(Level.Debug)) {
                        debug.debug("Unification failed: {} != {}", unifier.toString(term1), unifier.toString(term2));
                    }
                    return GreedySolver.this.fail(c);
                }
                catch (OccursException e) {
                    if (debug.isEnabled(Level.Debug)) {
                        debug.debug("Unification failed: {} != {}", unifier.toString(term1), unifier.toString(term2));
                    }
                    return GreedySolver.this.fail(c);
                }
                catch (RigidException e) {
                    return GreedySolver.this.delay(c, Delay.ofVars(e.vars()));
                }
            }

            @Override
            public Boolean caseExists(CExists c) throws InterruptedException {
                Renaming.Builder _existentials = Renaming.builder();
                IState.Immutable newState = GreedySolver.this.state;
                for (ITermVar var : c.vars()) {
                    Tuple2<ITermVar, IState.Immutable> varAndState = newState.freshVar(var);
                    ITermVar freshVar = varAndState._1();
                    newState = varAndState._2();
                    _existentials.put(var, freshVar);
                }
                Renaming existentials = _existentials.build();
                ISubstitution.Immutable subst = existentials.asSubstitution();
                IConstraint newConstraint = c.constraint().apply(subst).withCause(c.cause().orElse(null));
                if (!c.bodyCriticalEdges().isPresent()) {
                    throw new IllegalArgumentException("Solver only accepts constraints with pre-computed critical edges.");
                }
                ICompleteness.Immutable newCriticalEdges = c.bodyCriticalEdges().orElse(NO_NEW_CRITICAL_EDGES).apply(subst);
                return GreedySolver.this.success(c, newState, (Collection)NO_UPDATED_VARS, Constraints.disjoin(newConstraint), newCriticalEdges, existentials.asMap(), fuel);
            }

            @Override
            public Boolean caseFalse(CFalse c) {
                return GreedySolver.this.fail(c);
            }

            @Override
            public Boolean caseInequal(CInequal c) throws InterruptedException {
                ITerm term1 = c.term1();
                ITerm term2 = c.term2();
                IDebugContext debug = GreedySolver.this.params.debug();
                IUniDisunifier.Immutable unifier = GreedySolver.this.state.unifier();
                try {
                    IUniDisunifier.Result result = unifier.disunify((Iterable<ITermVar>)c.universals(), term1, term2, v -> GreedySolver.this.params.isRigid((ITermVar)v, GreedySolver.this.state)).orElse(null);
                    if (result != null) {
                        if (debug.isEnabled(Level.Debug)) {
                            debug.debug("Disunification succeeded: {}", result);
                        }
                        IState.Immutable newState = GreedySolver.this.state.withUnifier(result.unifier());
                        Set updatedVars = ((Optional)result.result()).map(Diseq::domainSet).orElse((Set)NO_UPDATED_VARS);
                        return GreedySolver.this.success(c, newState, updatedVars, (Collection)NO_NEW_CONSTRAINTS, NO_NEW_CRITICAL_EDGES, (Map)NO_EXISTENTIALS, fuel);
                    }
                    debug.debug("Disunification failed", new Object[0]);
                    return GreedySolver.this.fail(c);
                }
                catch (RigidException e) {
                    return GreedySolver.this.delay(c, Delay.ofVars(e.vars()));
                }
            }

            @Override
            public Boolean caseNew(CNew c) throws InterruptedException {
                IState.Immutable newState = GreedySolver.this.state;
                ITerm scopeTerm = c.scopeTerm();
                String base = TermMatch.M.var(ITermVar::getName).match(scopeTerm).orElse("s");
                Tuple2<Scope, IState.Immutable> ss = newState.freshScope(base);
                Scope scope = ss._1();
                newState = ss._2();
                ITerm datumTerm = c.datumTerm();
                IScopeGraph.Immutable<Scope, ITerm, ITerm> newScopeGraph = GreedySolver.this.state.scopeGraph().setDatum(scope, datumTerm);
                newState = newState.withScopeGraph(newScopeGraph);
                CEqual eq = new CEqual(scopeTerm, (ITerm)scope, c);
                return GreedySolver.this.success(c, newState, (Collection)NO_UPDATED_VARS, (Collection)ImmutableList.of((Object)eq), NO_NEW_CRITICAL_EDGES, (Map)NO_EXISTENTIALS, fuel);
            }

            @Override
            public Boolean caseResolveQuery(IResolveQuery c) throws InterruptedException {
                QueryFilter filter = c.filter();
                QueryMin min2 = c.min();
                ITerm scopeTerm = c.scopeTerm();
                ITerm resultTerm = c.resultTerm();
                IUniDisunifier.Immutable unifier = GreedySolver.this.state.unifier();
                if (!unifier.isGround(scopeTerm)) {
                    return GreedySolver.this.delay(c, Delay.ofVars(unifier.getVars(scopeTerm)));
                }
                Set freeVars = (Set)Streams.concat((Stream[])new Stream[]{unifier.getVars(scopeTerm).stream(), filter.getDataWF().freeVars().stream().flatMap(v -> unifier.getVars((ITerm)v).stream()), min2.getDataEquiv().freeVars().stream().flatMap(v -> unifier.getVars((ITerm)v).stream())}).collect(CapsuleCollectors.toSet());
                if (!freeVars.isEmpty()) {
                    return GreedySolver.this.delay(c, Delay.ofVars(freeVars));
                }
                Rule dataWfRule = RuleUtil.instantiateHeadPatterns(RuleUtil.closeInUnifier(filter.getDataWF(), GreedySolver.this.state.unifier(), ApplyMode.Safety.UNSAFE));
                Rule dataLeqRule = RuleUtil.instantiateHeadPatterns(RuleUtil.closeInUnifier(min2.getDataEquiv(), GreedySolver.this.state.unifier(), ApplyMode.Safety.UNSAFE));
                Scope scope = AScope.matcher().match(scopeTerm, unifier).orElse(null);
                if (scope == null) {
                    GreedySolver.this.debug.error("Expected scope, got {}", unifier.toString(scopeTerm));
                    GreedySolver.this.fail(constraint);
                }
                try {
                    ConstraintQueries cq = new ConstraintQueries(GreedySolver.this.spec, GreedySolver.this.state, GreedySolver.this.params::isComplete);
                    Env paths = c.matchInResolution(resolveQuery -> {
                        INameResolution<Scope, ITerm, ITerm> nameResolution = Solver.nameResolutionBuilder().withLabelWF(cq.getLabelWF(filter.getLabelWF())).withDataWF(cq.getDataWF(dataWfRule)).withLabelOrder(cq.getLabelOrder(min2.getLabelOrder())).withDataEquiv(cq.getDataEquiv(dataLeqRule)).withIsComplete((s, l) -> GreedySolver.this.params.isComplete((Scope)s, (EdgeOrData<ITerm>)l, GreedySolver.this.state)).build(GreedySolver.this.state.scopeGraph(), GreedySolver.this.spec.allLabels());
                        return nameResolution.resolve(scope, GreedySolver.this.cancel);
                    }, compiledQuery -> {
                        ResolutionInterpreter<Scope, ITerm, ITerm> interpreter = new ResolutionInterpreter<Scope, ITerm, ITerm>((IScopeGraph.Immutable<Scope, ITerm, ITerm>)GreedySolver.this.state.scopeGraph(), cq.getDataWF(dataWfRule), cq.getDataEquiv(dataLeqRule), compiledQuery.stateMachine(), (Predicate2<Scope, EdgeOrData<ITerm>>)((Predicate2<Scope, EdgeOrData>)(s, l) -> GreedySolver.this.params.isComplete((Scope)s, (EdgeOrData<ITerm>)l, GreedySolver.this.state)));
                        return interpreter.resolve(scope, GreedySolver.this.cancel);
                    });
                    List pathTerms = (List)Streams.stream((Iterable)paths).map(p -> StatixTerms.pathToTerm(p, GreedySolver.this.spec.dataLabels())).collect(ImmutableList.toImmutableList());
                    CEqual C2 = new CEqual(resultTerm, (ITerm)TermBuild.B.newList(pathTerms), c);
                    return GreedySolver.this.success(c, GreedySolver.this.state, (Collection)NO_UPDATED_VARS, (Collection)ImmutableList.of((Object)C2), NO_NEW_CRITICAL_EDGES, (Map)NO_EXISTENTIALS, fuel);
                }
                catch (IncompleteException e) {
                    GreedySolver.this.params.debug().debug("Query resolution delayed: {}", e.getMessage());
                    return GreedySolver.this.delay(c, Delay.ofCriticalEdge(CriticalEdge.of((ITerm)e.scope(), e.label())));
                }
                catch (ResolutionDelayException e) {
                    GreedySolver.this.params.debug().debug("Query resolution delayed: {}", e.getMessage());
                    return GreedySolver.this.delay(c, e.getCause());
                }
                catch (ResolutionException e) {
                    GreedySolver.this.params.debug().debug("Query resolution failed: {}", e.getMessage());
                    return GreedySolver.this.fail(c);
                }
            }

            @Override
            public Boolean caseTellEdge(CTellEdge c) throws InterruptedException {
                ITerm sourceTerm = c.sourceTerm();
                ITerm label = c.label();
                ITerm targetTerm = c.targetTerm();
                IUniDisunifier.Immutable unifier = GreedySolver.this.state.unifier();
                if (!unifier.isGround(sourceTerm)) {
                    return GreedySolver.this.delay(c, Delay.ofVars(unifier.getVars(sourceTerm)));
                }
                if (!unifier.isGround(targetTerm)) {
                    return GreedySolver.this.delay(c, Delay.ofVars(unifier.getVars(targetTerm)));
                }
                Scope source = AScope.matcher().match(sourceTerm, unifier).orElse(null);
                if (source == null) {
                    GreedySolver.this.debug.error("Expected source scope, got {}", unifier.toString(sourceTerm));
                    return GreedySolver.this.fail(c);
                }
                if (GreedySolver.this.params.isClosed(source, GreedySolver.this.state)) {
                    return GreedySolver.this.fail(c);
                }
                Scope target = AScope.matcher().match(targetTerm, unifier).orElse(null);
                if (target == null) {
                    GreedySolver.this.debug.error("Expected target scope, got {}", unifier.toString(targetTerm));
                    return GreedySolver.this.fail(c);
                }
                IScopeGraph.Immutable<Scope, ITerm, ITerm> scopeGraph = GreedySolver.this.state.scopeGraph().addEdge(source, label, target);
                return GreedySolver.this.success(c, GreedySolver.this.state.withScopeGraph(scopeGraph), (Collection)NO_UPDATED_VARS, (Collection)NO_NEW_CONSTRAINTS, NO_NEW_CRITICAL_EDGES, (Map)NO_EXISTENTIALS, fuel);
            }

            @Override
            public Boolean caseTermId(CAstId c) throws InterruptedException {
                ITerm term = c.astTerm();
                ITerm idTerm = c.idTerm();
                IUniDisunifier.Immutable unifier = GreedySolver.this.state.unifier();
                if (!unifier.isGround(term)) {
                    return GreedySolver.this.delay(c, Delay.ofVars(unifier.getVars(term)));
                }
                Optional<Scope> maybeScope = AScope.matcher().match(term, unifier);
                if (maybeScope.isPresent()) {
                    AScope scope = maybeScope.get();
                    CEqual eq = new CEqual(idTerm, scope);
                    return GreedySolver.this.success(c, GreedySolver.this.state, (Collection)NO_UPDATED_VARS, (Collection)ImmutableList.of((Object)eq), NO_NEW_CRITICAL_EDGES, (Map)NO_EXISTENTIALS, fuel);
                }
                Optional<TermIndex> maybeIndex = TermIndex.find(unifier.findTerm(term));
                if (maybeIndex.isPresent()) {
                    TermIndex indexTerm = TermOrigin.copy(term, maybeIndex.get());
                    CEqual eq = new CEqual(idTerm, indexTerm);
                    return GreedySolver.this.success(c, GreedySolver.this.state, (Collection)NO_UPDATED_VARS, (Collection)ImmutableList.of((Object)eq), NO_NEW_CRITICAL_EDGES, (Map)NO_EXISTENTIALS, fuel);
                }
                return GreedySolver.this.fail(c);
            }

            @Override
            public Boolean caseTermProperty(CAstProperty c) throws InterruptedException {
                ITerm idTerm = c.idTerm();
                ITerm prop = c.property();
                ITerm value = c.value();
                IUniDisunifier.Immutable unifier = GreedySolver.this.state.unifier();
                if (!unifier.isGround(idTerm)) {
                    return GreedySolver.this.delay(c, Delay.ofVars(unifier.getVars(idTerm)));
                }
                Optional<TermIndex> maybeIndex = TermIndex.matcher().match(idTerm, unifier);
                if (maybeIndex.isPresent()) {
                    ITermProperty property;
                    TermIndex index = maybeIndex.get();
                    Tuple2<TermIndex, ITerm> key = Tuple2.of(index, prop);
                    switch (c.op()) {
                        case ADD: {
                            property = (ITermProperty)GreedySolver.this.state.termProperties().getOrDefault(key, (Object)BagTermProperty.of());
                            if (!property.multiplicity().equals((Object)ITermProperty.Multiplicity.BAG)) {
                                return GreedySolver.this.fail(c);
                            }
                            property = property.addValue(value);
                            break;
                        }
                        case SET: {
                            if (GreedySolver.this.state.termProperties().containsKey(key)) {
                                ITermProperty property2 = (ITermProperty)GreedySolver.this.state.termProperties().get(key);
                                if (property2.multiplicity().equals((Object)ITermProperty.Multiplicity.SINGLETON) && property2.value().equals(value) && property2.value().getAttachments().equals(value.getAttachments())) {
                                    return GreedySolver.this.success(c, GreedySolver.this.state, (Collection)NO_UPDATED_VARS, (Collection)NO_NEW_CONSTRAINTS, NO_NEW_CRITICAL_EDGES, (Map)NO_EXISTENTIALS, fuel);
                                }
                                return GreedySolver.this.fail(c);
                            }
                            property = SingletonTermProperty.of(value);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown op " + (Object)((Object)c.op()));
                        }
                    }
                    IState.Immutable newState = GreedySolver.this.state.withTermProperties((Map.Immutable<Tuple2<TermIndex, ITerm>, ITermProperty>)GreedySolver.this.state.termProperties().__put(key, (Object)property));
                    return GreedySolver.this.success(c, newState, (Collection)NO_UPDATED_VARS, (Collection)NO_NEW_CONSTRAINTS, NO_NEW_CRITICAL_EDGES, (Map)NO_EXISTENTIALS, fuel);
                }
                return GreedySolver.this.fail(c);
            }

            @Override
            public Boolean caseTrue(CTrue c) throws InterruptedException {
                return GreedySolver.this.success(c, GreedySolver.this.state, (Collection)NO_UPDATED_VARS, (Collection)NO_NEW_CONSTRAINTS, NO_NEW_CRITICAL_EDGES, (Map)NO_EXISTENTIALS, fuel);
            }

            @Override
            public Boolean caseTry(CTry c) throws InterruptedException {
                IDebugContext debug = GreedySolver.this.params.debug();
                try {
                    if (Solver.entails(GreedySolver.this.spec, GreedySolver.this.state, c.constraint(), GreedySolver.this.params::isComplete, new NullDebugContext(), GreedySolver.this.progress.subProgress(1), GreedySolver.this.cancel)) {
                        return GreedySolver.this.success(c, GreedySolver.this.state, (Collection)NO_UPDATED_VARS, (Collection)NO_NEW_CONSTRAINTS, NO_NEW_CRITICAL_EDGES, (Map)NO_EXISTENTIALS, fuel);
                    }
                    return GreedySolver.this.fail(c);
                }
                catch (Delay delay) {
                    debug.debug("Try delayed: {}", delay.getMessage());
                    return GreedySolver.this.delay(c, delay);
                }
            }

            @Override
            public Boolean caseUser(CUser c) throws InterruptedException {
                String name = c.name();
                List<ITerm> args = c.args();
                LazyDebugContext proxyDebug = new LazyDebugContext(GreedySolver.this.debug);
                IDebugContext debug = GreedySolver.this.params.debug();
                ImmutableList<Rule> rules = GreedySolver.this.spec.rules().getRules(name);
                Tuple3 result = RuleUtil.applyOrderedOne(GreedySolver.this.state.unifier(), rules, args, c, ApplyMode.RELAXED, ApplyMode.Safety.UNSAFE).orElse(null);
                if (result == null) {
                    debug.debug("No rule applies", new Object[0]);
                    return GreedySolver.this.fail(c);
                }
                ApplyResult applyResult = (ApplyResult)result._2();
                if (!((Boolean)result._3()).booleanValue()) {
                    Set stuckVars = (Set)Streams.stream(applyResult.guard()).flatMap(g -> g.domainSet().stream()).collect(CapsuleCollectors.toSet());
                    proxyDebug.debug("Rule delayed (multiple conditional matches)", new Object[0]);
                    return GreedySolver.this.delay(c, Delay.ofVars(stuckVars));
                }
                proxyDebug.debug("Rule accepted", new Object[0]);
                proxyDebug.commit();
                if (applyResult.criticalEdges() == null) {
                    throw new IllegalArgumentException("Solver only accepts specs with pre-computed critical edges.");
                }
                return GreedySolver.this.success(c, GreedySolver.this.state, (Collection)NO_UPDATED_VARS, Collections.singletonList(applyResult.body()), applyResult.criticalEdges(), (Map)NO_EXISTENTIALS, fuel);
            }
        });
    }
}

