/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spec;

import com.google.common.collect.ImmutableList;
import io.usethesource.capsule.Set;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.matching.Pattern;
import mb.statix.solver.IConstraint;
import mb.statix.solver.completeness.ICompleteness;
import mb.statix.spec.ARule;

public final class Rule
extends ARule
implements Serializable {
    private final String label;
    private final String name;
    private final ImmutableList<Pattern> params;
    private final IConstraint body;
    @Nullable
    private final ICompleteness.Immutable bodyCriticalEdges;
    private int hashCode;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long PARAM_VARS_LAZY_INIT_BIT = 1L;
    private transient Set.Immutable<ITermVar> paramVars;
    private static final long ALWAYS_LAZY_INIT_BIT = 2L;
    private transient Optional<Boolean> always;
    private static final long serialVersionUID = 42L;

    private Rule(String name, Iterable<? extends Pattern> params, IConstraint body) {
        this.name = Objects.requireNonNull(name, "name");
        this.params = ImmutableList.copyOf(params);
        this.body = Objects.requireNonNull(body, "body");
        this.label = this.initShim.label();
        this.bodyCriticalEdges = this.initShim.bodyCriticalEdges();
        this.initShim = null;
    }

    private Rule(Builder builder) {
        this.name = builder.name;
        this.params = builder.params.build();
        this.body = builder.body;
        if (builder.label != null) {
            this.initShim.label(builder.label);
        }
        if (builder.bodyCriticalEdgesIsSet()) {
            this.initShim.bodyCriticalEdges(builder.bodyCriticalEdges);
        }
        this.label = this.initShim.label();
        this.bodyCriticalEdges = this.initShim.bodyCriticalEdges();
        this.initShim = null;
    }

    private Rule(String label, String name, ImmutableList<Pattern> params, IConstraint body, @Nullable ICompleteness.Immutable bodyCriticalEdges) {
        this.label = label;
        this.name = name;
        this.params = params;
        this.body = body;
        this.bodyCriticalEdges = bodyCriticalEdges;
        this.initShim = null;
    }

    @Override
    public String label() {
        InitShim shim = this.initShim;
        return shim != null ? shim.label() : this.label;
    }

    @Override
    public String name() {
        return this.name;
    }

    public ImmutableList<Pattern> params() {
        return this.params;
    }

    @Override
    public IConstraint body() {
        return this.body;
    }

    @Override
    @Nullable
    public ICompleteness.Immutable bodyCriticalEdges() {
        InitShim shim = this.initShim;
        return shim != null ? shim.bodyCriticalEdges() : this.bodyCriticalEdges;
    }

    public final Rule withLabel(String value) {
        String newValue = Objects.requireNonNull(value, "label");
        if (this.label.equals(newValue)) {
            return this;
        }
        return new Rule(newValue, this.name, this.params, this.body, this.bodyCriticalEdges);
    }

    public final Rule withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new Rule(this.label, newValue, this.params, this.body, this.bodyCriticalEdges);
    }

    public final Rule withParams(Pattern ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new Rule(this.label, this.name, (ImmutableList<Pattern>)newValue, this.body, this.bodyCriticalEdges);
    }

    public final Rule withParams(Iterable<? extends Pattern> elements) {
        if (this.params == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new Rule(this.label, this.name, (ImmutableList<Pattern>)newValue, this.body, this.bodyCriticalEdges);
    }

    public final Rule withBody(IConstraint value) {
        if (this.body == value) {
            return this;
        }
        IConstraint newValue = Objects.requireNonNull(value, "body");
        return new Rule(this.label, this.name, this.params, newValue, this.bodyCriticalEdges);
    }

    public final Rule withBodyCriticalEdges(@Nullable ICompleteness.Immutable value) {
        if (this.bodyCriticalEdges == value) {
            return this;
        }
        return new Rule(this.label, this.name, this.params, this.body, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Rule && this.equalTo((Rule)another);
    }

    private boolean equalTo(Rule another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.label.equals(another.label) && this.name.equals(another.name) && this.params.equals(another.params) && this.body.equals(another.body) && Objects.equals(this.bodyCriticalEdges, another.bodyCriticalEdges);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.label.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.params.hashCode();
        h += (h << 5) + this.body.hashCode();
        h += (h << 5) + Objects.hashCode(this.bodyCriticalEdges);
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set.Immutable<ITermVar> paramVars() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            Rule rule = this;
            synchronized (rule) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.paramVars = Objects.requireNonNull(super.paramVars(), "paramVars");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.paramVars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Boolean> isAlways() throws InterruptedException {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            Rule rule = this;
            synchronized (rule) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.always = Objects.requireNonNull(super.isAlways(), "always");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.always;
    }

    public static Rule of(String name, List<Pattern> params, IConstraint body) {
        return Rule.of(name, params, body);
    }

    public static Rule of(String name, Iterable<? extends Pattern> params, IConstraint body) {
        return new Rule(name, params, body);
    }

    public static Rule copyOf(ARule instance) {
        if (instance instanceof Rule) {
            return (Rule)instance;
        }
        return Rule.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ Rule(Builder builder, Rule rule) {
        this(builder);
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_BODY = 2L;
        private static final long OPT_BIT_BODY_CRITICAL_EDGES = 1L;
        private long initBits = 3L;
        private long optBits;
        private String label;
        private String name;
        private ImmutableList.Builder<Pattern> params = ImmutableList.builder();
        private IConstraint body;
        private ICompleteness.Immutable bodyCriticalEdges;

        private Builder() {
        }

        public final Builder from(ARule instance) {
            Objects.requireNonNull(instance, "instance");
            this.label(instance.label());
            this.name(instance.name());
            this.addAllParams(instance.params());
            this.body(instance.body());
            ICompleteness.Immutable bodyCriticalEdgesValue = instance.bodyCriticalEdges();
            if (bodyCriticalEdgesValue != null) {
                this.bodyCriticalEdges(bodyCriticalEdgesValue);
            }
            return this;
        }

        public final Builder label(String label) {
            this.label = Objects.requireNonNull(label, "label");
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addParams(Pattern element) {
            this.params.add((Object)element);
            return this;
        }

        public final Builder addParams(Pattern ... elements) {
            this.params.add((Object[])elements);
            return this;
        }

        public final Builder params(Iterable<? extends Pattern> elements) {
            this.params = ImmutableList.builder();
            return this.addAllParams(elements);
        }

        public final Builder addAllParams(Iterable<? extends Pattern> elements) {
            this.params.addAll(elements);
            return this;
        }

        public final Builder body(IConstraint body) {
            this.body = Objects.requireNonNull(body, "body");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder bodyCriticalEdges(@Nullable ICompleteness.Immutable bodyCriticalEdges) {
            this.bodyCriticalEdges = bodyCriticalEdges;
            this.optBits |= 1L;
            return this;
        }

        public Rule build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Rule(this, null);
        }

        private boolean bodyCriticalEdgesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("body");
            }
            return "Cannot build Rule, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte labelBuildStage = 0;
        private String label;
        private byte bodyCriticalEdgesBuildStage = 0;
        private ICompleteness.Immutable bodyCriticalEdges;

        private InitShim() {
        }

        String label() {
            if (this.labelBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.labelBuildStage == 0) {
                this.labelBuildStage = (byte)-1;
                this.label = Objects.requireNonNull(Rule.super.label(), "label");
                this.labelBuildStage = 1;
            }
            return this.label;
        }

        void label(String label) {
            this.label = label;
            this.labelBuildStage = 1;
        }

        ICompleteness.Immutable bodyCriticalEdges() {
            if (this.bodyCriticalEdgesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.bodyCriticalEdgesBuildStage == 0) {
                this.bodyCriticalEdgesBuildStage = (byte)-1;
                this.bodyCriticalEdges = Rule.super.bodyCriticalEdges();
                this.bodyCriticalEdgesBuildStage = 1;
            }
            return this.bodyCriticalEdges;
        }

        void bodyCriticalEdges(ICompleteness.Immutable bodyCriticalEdges) {
            this.bodyCriticalEdges = bodyCriticalEdges;
            this.bodyCriticalEdgesBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.labelBuildStage == -1) {
                attributes.add("label");
            }
            if (this.bodyCriticalEdgesBuildStage == -1) {
                attributes.add("bodyCriticalEdges");
            }
            return "Cannot build Rule, attribute initializers form cycle " + attributes;
        }
    }
}

