/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spoofax;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;
import java.util.Optional;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.unification.OccursException;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.terms.unification.u.PersistentUnifier;
import mb.scopegraph.oopsla20.reference.ScopeGraph;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.spoofax.StatixPrimitive;
import mb.statix.spoofax.StatixTerms;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;

public class STX_get_scopegraph
extends StatixPrimitive {
    @Inject
    public STX_get_scopegraph() {
        super(STX_get_scopegraph.class.getSimpleName(), 0);
    }

    @Override
    protected Optional<? extends ITerm> call(IContext env, ITerm term, List<ITerm> terms) throws InterpreterException {
        List analyses = (List)TermMatch.M.cases(TermMatch.M.blobValue(SolverResult.class).map(ImmutableList::of), TermMatch.M.listElems(TermMatch.M.blobValue(SolverResult.class))).match(term).orElseThrow(() -> new InterpreterException("Expected solver result."));
        ScopeGraph.Transient scopeGraph = ScopeGraph.Transient.of();
        IUnifier.Transient unifier = PersistentUnifier.Immutable.of().melt();
        for (SolverResult analysis : analyses) {
            scopeGraph.addAll(analysis.state().scopeGraph());
            try {
                unifier.unify(analysis.state().unifier());
            }
            catch (OccursException e) {
                throw new InterpreterException("Cannot combine unifiers.", e);
            }
        }
        ITerm scopeGraphTerm = StatixTerms.toTerm(scopeGraph.freeze(), unifier.freeze());
        return Optional.of(scopeGraphTerm);
    }
}

