/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spoofax;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.p_raffrayi.IUnitResult;
import mb.p_raffrayi.PRaffrayiSettings;
import mb.p_raffrayi.impl.Broker;
import mb.p_raffrayi.impl.Result;
import mb.statix.concurrent.GroupResult;
import mb.statix.concurrent.IStatixProject;
import mb.statix.concurrent.IStatixResult;
import mb.statix.concurrent.InputMatchers;
import mb.statix.concurrent.ProjectResult;
import mb.statix.concurrent.ProjectTypeChecker;
import mb.statix.concurrent.SolverState;
import mb.statix.concurrent.UnitResult;
import mb.statix.concurrent.nameresolution.ScopeImpl;
import mb.statix.constraints.CFalse;
import mb.statix.constraints.messages.IMessage;
import mb.statix.constraints.messages.IMessagePart;
import mb.statix.constraints.messages.Message;
import mb.statix.constraints.messages.MessageKind;
import mb.statix.constraints.messages.TextPart;
import mb.statix.scopegraph.Scope;
import mb.statix.solver.IConstraint;
import mb.statix.solver.log.IDebugContext;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.spec.Spec;
import mb.statix.spoofax.SolverMode;
import mb.statix.spoofax.StatixPrimitive;
import mb.statix.spoofax.StatixTerms;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;
import org.metaborg.util.unit.Unit;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;

public class STX_solve_multi
extends StatixPrimitive {
    private static final ILogger logger = LoggerUtils.logger(STX_solve_multi.class);

    @Inject
    public STX_solve_multi() {
        super(STX_solve_multi.class.getSimpleName(), 5);
    }

    @Override
    protected Optional<? extends ITerm> call(IContext env, ITerm term, List<ITerm> terms) throws InterpreterException {
        Spec spec = StatixTerms.spec().match(terms.get(1)).orElseThrow(() -> new InterpreterException("Expected spec."));
        this.reportOverlappingRules(spec);
        IDebugContext debug = this.getDebugContext(terms.get(2));
        IProgress progress = this.getProgress(terms.get(3));
        ICancel cancel = this.getCancel(terms.get(4));
        IStatixProject project = InputMatchers.project().match(term).orElseThrow(() -> new InterpreterException("Expected project."));
        ScopeImpl scopeImpl = new ScopeImpl();
        ArrayList results = Lists.newArrayList();
        try {
            logger.info("Analyzing files");
            SolverMode solverMode = this.getSolverMode(terms.get(0));
            PRaffrayiSettings settings = this.solverModeToSettings(solverMode);
            int size = project.size(Runtime.getRuntime().availableProcessors());
            progress.setWorkRemaining(size + 1);
            double t0 = System.currentTimeMillis();
            IFuture<IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, ProjectResult, SolverState>>> futureResult = Broker.run(project.resource(), settings, new ProjectTypeChecker(project, spec, debug), scopeImpl, spec.allLabels(), project.changed(), project.previousResult(), cancel, progress);
            IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, ProjectResult, SolverState>> result = futureResult.asJavaCompletion().get();
            double dt = (double)System.currentTimeMillis() - t0;
            ArrayList unitResults = new ArrayList();
            Map<String, ITerm> resultMap = this.flattenResult(spec, result, unitResults);
            logger.info("Files analyzed in {} s", dt / 1000.0);
            if (settings.isIncremental()) {
                logger.info("* Initially changed units : {}", this.flattenTransitions(unitResults, IUnitResult.TransitionTrace.INITIALLY_STARTED));
                logger.info("* Restarted units         : {}", this.flattenTransitions(unitResults, IUnitResult.TransitionTrace.RESTARTED));
                logger.info("* Released units          : {}", this.flattenTransitions(unitResults, IUnitResult.TransitionTrace.RELEASED));
            }
            for (Map.Entry<String, ITerm> entry : resultMap.entrySet()) {
                results.add(TermBuild.B.newTuple(TermBuild.B.newString(entry.getKey()), entry.getValue()));
            }
            progress.work(1);
        }
        catch (InterruptedException ie) {
            logger.info("Async solving interrupted");
        }
        catch (ExecutionException ee) {
            Throwable c = ee.getCause();
            if (c instanceof InterruptedException) {
                logger.info("Async solving interrupted");
            }
            logger.error("Async solving failed.", c);
            throw new InterpreterException("Async solving failed.");
        }
        catch (Throwable e) {
            logger.error("Async solving failed.", e);
            throw new InterpreterException("Async solving failed.");
        }
        return Optional.of(TermBuild.B.newList(results));
    }

    private Map<String, ITerm> flattenResult(Spec spec, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, ProjectResult, SolverState>> result, List<IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, ?, SolverState>>> unitResults) {
        unitResults.add(result);
        if (result.result() == null) {
            logger.error("Missing result for project {}", result.id());
            return new HashMap<String, ITerm>();
        }
        HashMap<String, ITerm> resourceResults = new HashMap<String, ITerm>();
        ProjectResult projectResult = result.result().analysis();
        String resource = projectResult.resource();
        ArrayList groupResults = new ArrayList();
        projectResult.libraryResults().forEach((k, ur) -> this.flattenLibraryResult(spec, (IUnitResult<Scope, ITerm, ITerm, Unit>)ur));
        projectResult.groupResults().forEach((k, gr) -> this.flattenGroupResult(spec, String.valueOf(resource) + "/" + k, (IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult, SolverState>>)gr, groupResults, (Map<String, ITerm>)resourceResults, unitResults));
        projectResult.unitResults().forEach((k, ur) -> this.flattenUnitResult(spec, (IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult, SolverState>>)ur, (Map<String, ITerm>)resourceResults, unitResults));
        SolverResult solveResult = this.flatSolverResult(spec, result);
        for (SolverResult groupResult : groupResults) {
            solveResult = solveResult.combine(groupResult);
        }
        resourceResults.put(resource, TermBuild.B.newAppl("ProjectResult", TermBuild.B.newBlob(solveResult), TermBuild.B.newBlob(result)));
        return resourceResults;
    }

    private void flattenLibraryResult(Spec spec, IUnitResult<Scope, ITerm, ITerm, Unit> result) {
    }

    private void flattenGroupResult(Spec spec, String groupId, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult, SolverState>> result, List<SolverResult> groupResults, Map<String, ITerm> resourceResults, List<IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, ?, SolverState>>> unitResults) {
        unitResults.add(result);
        if (result.result() == null) {
            logger.error("Missing result for group {}", result.id());
            return;
        }
        GroupResult groupResult = result.result().analysis();
        groupResult.groupResults().forEach((k, gr) -> this.flattenGroupResult(spec, groupResult.resource(), (IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult, SolverState>>)gr, groupResults, resourceResults, unitResults));
        groupResult.unitResults().forEach((k, ur) -> this.flattenUnitResult(spec, (IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult, SolverState>>)ur, resourceResults, unitResults));
        SolverResult solveResult = this.flatSolverResult(spec, result);
        groupResults.add(solveResult);
        resourceResults.put(groupId, TermBuild.B.newAppl("GroupResult", TermBuild.B.newBlob(solveResult), TermBuild.B.newBlob(result)));
    }

    private void flattenUnitResult(Spec spec, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult, SolverState>> result, Map<String, ITerm> resourceResults, List<IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, ?, SolverState>>> unitResults) {
        unitResults.add(result);
        Result<Scope, ITerm, ITerm, UnitResult, SolverState> unitResult = result.result();
        if (unitResult != null) {
            SolverResult solveResult = this.flatSolverResult(spec, result);
            resourceResults.put(unitResult.analysis().resource(), TermBuild.B.newAppl("UnitResult", TermBuild.B.newBlob(solveResult), TermBuild.B.newBlob(result)));
        } else {
            logger.error("Missing result for unit {}", result.id());
        }
    }

    private <T extends IStatixResult> SolverResult flatSolverResult(Spec spec, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, T, SolverState>> result) {
        IStatixResult unitResult = (IStatixResult)result.result().analysis();
        SolverResult solveResult = Optional.ofNullable(unitResult.solveResult()).orElseGet(() -> SolverResult.of(spec));
        solveResult = solveResult.withState(solveResult.state().withScopeGraph(result.scopeGraph()));
        ImmutableMap.Builder messages = ImmutableMap.builder().putAll(solveResult.messages());
        if (((IStatixResult)result.result().analysis()).exception() != null) {
            Message message = new Message(MessageKind.ERROR, (Iterable<IMessagePart>)ImmutableList.of((Object)new TextPart("Exception: " + ((IStatixResult)result.result().analysis()).exception().getMessage())), TermBuild.B.newTuple(new ITerm[0]));
            messages.put((Object)new CFalse(message), (Object)message);
        }
        for (Throwable failure : result.failures()) {
            Message message = new Message(MessageKind.ERROR, (Iterable<IMessagePart>)ImmutableList.of((Object)new TextPart("Exception: " + failure.getMessage())), TermBuild.B.newTuple(new ITerm[0]));
            messages.put((Object)new CFalse(message), (Object)message);
        }
        solveResult = solveResult.withMessages((Map<? extends IConstraint, ? extends IMessage>)messages.build());
        return solveResult;
    }

    private String flattenTransitions(List<IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, ?, SolverState>>> unitResults, IUnitResult.TransitionTrace flow) {
        return unitResults.stream().filter(r -> r.stateTransitionTrace() == flow).map(IUnitResult::id).collect(Collectors.joining(", "));
    }

    private SolverMode getSolverMode(ITerm term) throws InterpreterException {
        return TermMatch.M.blobValue(SolverMode.class).match(term).orElseThrow(() -> new InterpreterException("Expected project condiguration, got " + term));
    }

    private PRaffrayiSettings solverModeToSettings(SolverMode mode) throws InterpreterException {
        switch (mode) {
            case TRADITIONAL: {
                throw new InterpreterException("Cannot create concurrent settings for TRADITIONAL solver mode.");
            }
            case CONCURRENT: {
                return PRaffrayiSettings.concurrent();
            }
            case INCREMENTAL: {
                return PRaffrayiSettings.incremental();
            }
        }
        throw new InterpreterException("Unknown solver mode: " + (Object)((Object)mode));
    }
}

