/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.config;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.config.AConfigBuilder;
import org.metaborg.core.config.AConfigurationReaderWriter;
import org.metaborg.core.config.IConfig;
import org.metaborg.core.config.IExportConfig;
import org.metaborg.core.config.IProjectConfig;
import org.metaborg.core.config.IProjectConfigBuilder;
import org.metaborg.core.config.ProjectConfig;
import org.metaborg.core.language.LanguageIdentifier;

public class ProjectConfigBuilder
extends AConfigBuilder
implements IProjectConfigBuilder {
    @Nullable
    protected String metaborgVersion;
    @Nullable
    protected List<IExportConfig> sources;
    @Nullable
    protected Set<LanguageIdentifier> compileDeps;
    @Nullable
    protected Set<LanguageIdentifier> sourceDeps;
    @Nullable
    protected Set<LanguageIdentifier> javaDeps;

    @Inject
    public ProjectConfigBuilder(AConfigurationReaderWriter configReaderWriter) {
        super(configReaderWriter);
    }

    @Override
    public IProjectConfig build(@Nullable FileObject rootFolder) {
        if (this.configuration == null) {
            this.configuration = this.configReaderWriter.create(null, rootFolder);
        }
        return this.build((HierarchicalConfiguration<ImmutableNode>)this.configuration);
    }

    public ProjectConfig build(HierarchicalConfiguration<ImmutableNode> configuration) {
        return new ProjectConfig(configuration, this.metaborgVersion, this.sources, this.compileDeps, this.sourceDeps, this.javaDeps);
    }

    @Override
    public IProjectConfigBuilder reset() {
        this.configuration = null;
        this.metaborgVersion = null;
        this.compileDeps = null;
        this.sourceDeps = null;
        this.javaDeps = null;
        return this;
    }

    @Override
    public IProjectConfigBuilder copyFrom(IProjectConfig config) {
        if (config instanceof IConfig) {
            this.configuration = this.cloneConfiguration((IConfig)((Object)config));
        } else {
            this.copyValuesFrom(config);
        }
        return this;
    }

    protected void copyValuesFrom(IProjectConfig config) {
        this.configuration = null;
        this.withMetaborgVersion(config.metaborgVersion());
        this.withCompileDeps(config.compileDeps());
        this.withSourceDeps(config.sourceDeps());
        this.withJavaDeps(config.javaDeps());
    }

    @Override
    public IProjectConfigBuilder withMetaborgVersion(String metaborgVersion) {
        this.metaborgVersion = metaborgVersion;
        return this;
    }

    @Override
    public IProjectConfigBuilder withSources(Iterable<IExportConfig> sources) {
        if (this.sources != null) {
            this.sources.clear();
        }
        this.addSources(sources);
        return this;
    }

    @Override
    public IProjectConfigBuilder addSources(Iterable<IExportConfig> sources) {
        if (this.sources == null) {
            this.sources = Lists.newArrayList();
        }
        Iterables.addAll(this.sources, sources);
        return this;
    }

    @Override
    public IProjectConfigBuilder withCompileDeps(Iterable<LanguageIdentifier> deps) {
        if (this.compileDeps != null) {
            this.compileDeps.clear();
        }
        this.addCompileDeps(deps);
        return this;
    }

    @Override
    public IProjectConfigBuilder addCompileDeps(Iterable<LanguageIdentifier> deps) {
        if (this.compileDeps == null) {
            this.compileDeps = Sets.newHashSet();
        }
        Iterables.addAll(this.compileDeps, deps);
        return this;
    }

    @Override
    public IProjectConfigBuilder withSourceDeps(Iterable<LanguageIdentifier> deps) {
        if (this.sourceDeps != null) {
            this.sourceDeps.clear();
        }
        this.addSourceDeps(deps);
        return this;
    }

    @Override
    public IProjectConfigBuilder addSourceDeps(Iterable<LanguageIdentifier> deps) {
        if (this.sourceDeps == null) {
            this.sourceDeps = Sets.newHashSet();
        }
        Iterables.addAll(this.sourceDeps, deps);
        return this;
    }

    @Override
    public IProjectConfigBuilder withJavaDeps(Iterable<LanguageIdentifier> deps) {
        if (this.javaDeps != null) {
            this.javaDeps.clear();
        }
        this.addJavaDeps(deps);
        return this;
    }

    @Override
    public IProjectConfigBuilder addJavaDeps(Iterable<LanguageIdentifier> deps) {
        if (this.javaDeps == null) {
            this.javaDeps = Sets.newHashSet();
        }
        Iterables.addAll(this.javaDeps, deps);
        return this;
    }
}

