/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.parsetable.actions;

import org.metaborg.parsetable.Cache;
import org.metaborg.parsetable.actions.Accept;
import org.metaborg.parsetable.actions.IAccept;
import org.metaborg.parsetable.actions.IActionsFactory;
import org.metaborg.parsetable.actions.IReduce;
import org.metaborg.parsetable.actions.IReduceLookahead;
import org.metaborg.parsetable.actions.IShift;
import org.metaborg.parsetable.actions.Reduce;
import org.metaborg.parsetable.actions.ReduceLookahead;
import org.metaborg.parsetable.actions.Shift;
import org.metaborg.parsetable.characterclasses.ICharacterClass;
import org.metaborg.parsetable.productions.IProduction;
import org.metaborg.parsetable.productions.ProductionType;

public class ActionsFactory
implements IActionsFactory {
    private boolean cache;
    private Cache<IShift> shiftCache;
    private Cache<IReduce> reduceCache;
    private Cache<IReduceLookahead> reduceLookaheadCache;

    public ActionsFactory() {
        this(true);
    }

    public ActionsFactory(boolean cache) {
        this.cache = cache;
        if (cache) {
            this.shiftCache = new Cache();
            this.reduceCache = new Cache();
            this.reduceLookaheadCache = new Cache();
        }
    }

    @Override
    public IShift getShift(int shiftStateId) {
        Shift shift = new Shift(shiftStateId);
        return this.maybeCached(this.shiftCache, shift);
    }

    @Override
    public IReduce getReduce(IProduction production, ProductionType productionType, int arity) {
        Reduce reduce = new Reduce(production, productionType, arity);
        return this.maybeCached(this.reduceCache, reduce);
    }

    @Override
    public IReduceLookahead getReduceLookahead(IProduction production, ProductionType productionType, int arity, ICharacterClass[] followRestriction) {
        ReduceLookahead reduceLookahead = new ReduceLookahead(production, productionType, arity, followRestriction);
        return this.maybeCached(this.reduceLookaheadCache, reduceLookahead);
    }

    @Override
    public IAccept getAccept() {
        return Accept.SINGLETON;
    }

    private <T> T maybeCached(Cache<T> cacheT, T action) {
        if (this.cache) {
            return cacheT.cached(action);
        }
        return action;
    }
}

