/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.runtime.task.primitives;

import org.metaborg.runtime.task.ITask;
import org.metaborg.runtime.task.engine.ITaskEngine;
import org.metaborg.runtime.task.primitives.TaskEnginePrimitive;
import org.metaborg.runtime.task.util.TermTools;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.util.TermUtils;

public class task_api_debug_info_0_1
extends TaskEnginePrimitive {
    public static task_api_debug_info_0_1 instance = new task_api_debug_info_0_1();

    public task_api_debug_info_0_1() {
        super("task_api_debug_info", 0, 1);
    }

    @Override
    public boolean call(ITaskEngine taskEngine, IContext env, Strategy[] svars, IStrategoTerm[] tvars) throws InterpreterException {
        ITermFactory factory = env.getFactory();
        IStrategoTerm tupleOrSourceOrID = tvars[0];
        if (TermUtils.isTuple(tupleOrSourceOrID) && tupleOrSourceOrID.getSubtermCount() == 0) {
            env.setCurrent(this.createDebugTuples(taskEngine.getTaskIDs(), taskEngine, factory));
        } else if (TermUtils.isString(tupleOrSourceOrID)) {
            env.setCurrent(this.createDebugTuples(taskEngine.getFromSource(tupleOrSourceOrID), taskEngine, factory));
        } else {
            env.setCurrent(this.createDebugTuple(tupleOrSourceOrID, taskEngine, factory));
        }
        return true;
    }

    private IStrategoList createDebugTuples(Iterable<IStrategoTerm> taskIDs, ITaskEngine engine, ITermFactory factory) {
        IStrategoList list = factory.makeList();
        for (IStrategoTerm taskID : taskIDs) {
            list = factory.makeListCons(this.createDebugTuple(taskID, engine, factory), list);
        }
        return list;
    }

    private IStrategoTerm createDebugTuple(IStrategoTerm taskID, ITaskEngine engine, ITermFactory factory) {
        IStrategoTerm results;
        ITask task = engine.getTask(taskID);
        IStrategoList staticDependencies = TermTools.makeList(factory, engine.getDependencies(taskID, false));
        IStrategoList dynamicDependencies = TermTools.makeList(factory, engine.getDynamicDependencies(taskID));
        IStrategoTerm message = task.message() == null ? this.none(factory) : task.message();
        IStrategoList reads = TermTools.makeList(factory, engine.getReads(taskID));
        switch (task.status()) {
            case DependencyFail: {
                results = this.depfail(factory);
                break;
            }
            case Fail: {
                results = this.fail(factory);
                break;
            }
            case Success: {
                results = TermTools.makeList(factory, task.results());
                break;
            }
            default: {
                results = this.none(factory);
            }
        }
        return this.taskTuple(factory, taskID, task.initialInstruction(), staticDependencies, dynamicDependencies, reads, results, message, factory.makeInt((int)task.time()), factory.makeInt(task.evaluations()));
    }

    private IStrategoTerm taskTuple(ITermFactory factory, IStrategoTerm taskID, IStrategoTerm instruction, IStrategoTerm staticDependencies, IStrategoTerm dynamicDependencies, IStrategoTerm reads, IStrategoTerm results, IStrategoTerm message, IStrategoInt time, IStrategoInt evaluations) {
        return factory.makeTuple(taskID, instruction, staticDependencies, dynamicDependencies, reads, results, message, time, evaluations);
    }

    private IStrategoAppl fail(ITermFactory factory) {
        return factory.makeAppl(factory.makeConstructor("Fail", 0), new IStrategoTerm[0]);
    }

    private IStrategoAppl depfail(ITermFactory factory) {
        return factory.makeAppl(factory.makeConstructor("DepFail", 0), new IStrategoTerm[0]);
    }

    private IStrategoAppl none(ITermFactory factory) {
        return factory.makeAppl(factory.makeConstructor("None", 0), new IStrategoTerm[0]);
    }
}

