/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.runtime.task.specific;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.metaborg.runtime.task.ITask;
import org.metaborg.runtime.task.ITaskFactory;
import org.metaborg.runtime.task.ListTaskResults;
import org.metaborg.runtime.task.Task;
import org.metaborg.runtime.task.TaskStatus;
import org.metaborg.runtime.task.TaskStorageType;
import org.metaborg.runtime.task.TaskType;
import org.metaborg.runtime.task.engine.ITaskEngine;
import org.metaborg.runtime.task.evaluation.ITaskEvaluationFrontend;
import org.metaborg.runtime.task.evaluation.ITaskEvaluationQueue;
import org.metaborg.runtime.task.evaluation.ITaskEvaluator;
import org.metaborg.runtime.task.evaluation.ITaskQueuer;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.util.TermUtils;

public class SequenceTask
implements ITaskFactory,
ITaskQueuer,
ITaskEvaluator {
    private final ITermFactory factory;
    private final Map<IStrategoTerm, Iterator<IStrategoTerm>> iterators = Maps.newHashMap();
    private final Map<IStrategoTerm, IStrategoTerm> subtaskIDs = Maps.newHashMap();

    public SequenceTask(ITermFactory factory) {
        this.factory = factory;
    }

    @Override
    public IStrategoList adjustDependencies(IStrategoList dependencies) {
        return this.factory.makeList();
    }

    @Override
    public ITask create(IStrategoAppl instruction, IStrategoList dependencies, TaskType type, TaskStorageType storageType, TaskStorageType actualStorageType, boolean shortCircuit) {
        return new Task(instruction, dependencies, type, TaskStorageType.List, shortCircuit, new ListTaskResults());
    }

    @Override
    public ITask clone(ITask task) {
        return new Task((Task)task);
    }

    @Override
    public void queue(ITaskEngine taskEngine, ITaskEvaluationQueue evaluationQueue, Set<IStrategoTerm> scheduled) {
        for (IStrategoTerm taskID : scheduled) {
            ITask task = taskEngine.getTask(taskID);
            if (!SequenceTask.isSequence(task.instruction())) continue;
            evaluationQueue.queue(taskID);
        }
    }

    @Override
    public void evaluate(IStrategoTerm taskID, ITask task, ITaskEngine taskEngine, ITaskEvaluationQueue evaluationQueue, IContext context, Strategy collect, Strategy insert, Strategy perform, boolean cycle) {
        IStrategoTerm subtaskID;
        Iterator<IStrategoTerm> iter = this.iterators.get(taskID);
        if (iter == null) {
            iter = task.instruction().getSubterm(0).iterator();
            this.iterators.put(taskID, iter);
        }
        if ((subtaskID = this.subtaskIDs.get(taskID)) != null) {
            evaluationQueue.removeRuntimeDependency(taskID, subtaskID);
            ITask subtask = taskEngine.getTask(subtaskID);
            if (this.handleSolvedTask(task, taskID, iter, subtask, taskEngine, evaluationQueue)) {
                return;
            }
        }
        if (!iter.hasNext()) {
            this.sequenceFails(task, taskID, taskEngine, evaluationQueue);
            return;
        }
        IStrategoTerm subtaskResult = iter.next();
        IStrategoTerm subtaskID2 = this.getTaskID(subtaskResult);
        if (subtaskID2 == null) {
            evaluationQueue.queue(taskID);
            return;
        }
        this.subtaskIDs.put(taskID, subtaskID2);
        ITask subtask = taskEngine.getTask(subtaskID2);
        taskEngine.addDependency(taskID, subtaskID2);
        if (subtask.solved()) {
            if (this.handleSolvedTask(task, taskID, iter, subtask, taskEngine, evaluationQueue)) {
                return;
            }
        } else {
            this.queueTransitive(subtaskID2, taskEngine, evaluationQueue);
            evaluationQueue.addRuntimeDependency(taskID, subtaskID2);
            return;
        }
    }

    @Override
    public void reset() {
        this.iterators.clear();
        this.subtaskIDs.clear();
    }

    private IStrategoTerm getTaskID(IStrategoTerm resultTerm) {
        if (TermUtils.isAppl(resultTerm) && TermUtils.isAppl((IStrategoAppl)resultTerm, "Result", 1)) {
            return resultTerm.getSubterm(0);
        }
        return null;
    }

    private boolean handleSolvedTask(ITask task, IStrategoTerm taskID, Iterator<IStrategoTerm> iter, ITask subtask, ITaskEngine taskEngine, ITaskEvaluationQueue evaluationQueue) {
        if (subtask.failed()) {
            this.sequenceFails(task, taskID, taskEngine, evaluationQueue);
            return true;
        }
        if (!iter.hasNext()) {
            this.sequenceSucceeds(task, taskID, subtask, taskEngine, evaluationQueue);
            return true;
        }
        return false;
    }

    private void sequenceFails(ITask task, IStrategoTerm taskID, ITaskEngine taskEngine, ITaskEvaluationQueue evaluationQueue) {
        task.setFailed();
        evaluationQueue.solved(taskID);
        this.cleanupSequence(taskID, taskEngine, evaluationQueue);
    }

    private void sequenceSucceeds(ITask task, IStrategoTerm taskID, ITask subtask, ITaskEngine taskEngine, ITaskEvaluationQueue evaluationQueue) {
        task.results().set(subtask.results());
        task.setStatus(TaskStatus.Success);
        evaluationQueue.solved(taskID);
        this.cleanupSequence(taskID, taskEngine, evaluationQueue);
    }

    private void cleanupSequence(IStrategoTerm taskID, ITaskEngine taskEngine, ITaskEvaluationQueue evaluationQueue) {
        Iterator<IStrategoTerm> iter = this.iterators.get(taskID);
        if (iter != null) {
            while (iter.hasNext()) {
                IStrategoTerm subtaskResult = iter.next();
                IStrategoTerm subtaskID = this.getTaskID(subtaskResult);
                if (subtaskID == null) continue;
                evaluationQueue.skipped(subtaskID);
                for (IStrategoTerm dependencyTaskID : this.transitiveDependenciesNoSequence(subtaskID, taskEngine)) {
                    evaluationQueue.skipped(dependencyTaskID);
                }
            }
        }
        this.iterators.remove(taskID);
        this.subtaskIDs.remove(taskID);
    }

    private void queueTransitive(IStrategoTerm taskID, ITaskEngine taskEngine, ITaskEvaluationQueue evaluationQueue) {
        evaluationQueue.queueOrDefer(taskID);
        for (IStrategoTerm dependencyTaskID : this.transitiveDependenciesNoSequence(taskID, taskEngine)) {
            evaluationQueue.queueOrDefer(dependencyTaskID);
        }
    }

    private Set<IStrategoTerm> transitiveDependenciesNoSequence(IStrategoTerm taskID, ITaskEngine taskEngine) {
        IStrategoTerm queueTaskID;
        HashSet seen = Sets.newHashSet();
        LinkedList queue = Lists.newLinkedList();
        queue.add(taskID);
        seen.add(taskID);
        while ((queueTaskID = (IStrategoTerm)queue.poll()) != null) {
            ITask task = taskEngine.getTask(queueTaskID);
            if (SequenceTask.isSequence(task.instruction())) continue;
            for (IStrategoTerm dependency : taskEngine.getDependencies(queueTaskID, false)) {
                if (!seen.add(dependency)) continue;
                queue.add(dependency);
            }
        }
        seen.remove(taskID);
        return seen;
    }

    private static boolean isSequence(IStrategoTerm instruction) {
        return TermUtils.isAppl(instruction) && TermUtils.isAppl((IStrategoAppl)instruction, "Sequence", 1);
    }

    public static SequenceTask register(ITaskEngine taskEngine, ITaskEvaluationFrontend evaluationFrontend, ITermFactory factory) {
        SequenceTask evaluator = new SequenceTask(factory);
        IStrategoConstructor constructor = factory.makeConstructor("Sequence", 1);
        taskEngine.registerTaskFactory(constructor, evaluator);
        evaluationFrontend.registerTaskEvaluator(constructor, evaluator);
        return evaluator;
    }
}

