/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.io;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.sdf2table.grammar.IAttribute;
import org.metaborg.sdf2table.grammar.IProduction;
import org.metaborg.sdf2table.grammar.ISymbol;
import org.metaborg.sdf2table.grammar.Priority;
import org.metaborg.sdf2table.grammar.Symbol;
import org.metaborg.sdf2table.io.ParseTableIO;
import org.metaborg.sdf2table.parsetable.LRItem;
import org.metaborg.sdf2table.parsetable.ParseTable;
import org.metaborg.sdf2table.parsetable.State;
import org.metaborg.sdf2table.parsetable.StateStatus;

public class IncrementalParseTableGenerator
extends ParseTableIO {
    private Set<IProduction> additionalProds;
    private SetMultimap<IProduction, IAttribute> additionalProdAttributes = null;
    private Set<IProduction> removedProds;
    private Set<Symbol> changedSymbols;
    SetMultimap<Priority, Integer> additionalPrios;
    SetMultimap<Priority, Integer> removedPrios;

    public IncrementalParseTableGenerator(FileObject grammarFile, ParseTable reference) throws Exception {
        super(grammarFile);
        boolean changed;
        ParseTable current = this.getParseTable();
        Set currentProductions = current.productionLabels().keySet();
        Set referenceProductions = reference.productionLabels().keySet();
        this.additionalProds = Sets.newHashSet((Iterable)Sets.filter((Set)currentProductions, e -> !referenceProductions.contains(e)));
        this.removedProds = Sets.newHashSet((Iterable)Sets.filter((Set)referenceProductions, e -> !currentProductions.contains(e)));
        if (!this.additionalProds.isEmpty()) {
            this.additionalProdAttributes = HashMultimap.create();
        }
        for (IProduction p : this.additionalProds) {
            this.additionalProdAttributes.putAll((Object)p, (Iterable)current.normalizedGrammar().getProductionAttributesMapping().get((Object)p));
        }
        SetMultimap<Priority, Integer> currentPriorities = current.normalizedGrammar().priorities();
        SetMultimap<Priority, Integer> referencePriorities = reference.normalizedGrammar().priorities();
        this.additionalPrios = HashMultimap.create((Multimap)Multimaps.filterEntries(currentPriorities, e -> !referencePriorities.containsEntry(e.getKey(), e.getValue())));
        this.removedPrios = HashMultimap.create((Multimap)Multimaps.filterEntries(referencePriorities, e -> !currentPriorities.containsEntry(e.getKey(), e.getValue())));
        this.changedSymbols = Sets.newHashSet();
        boolean bl = changed = !this.additionalPrios.isEmpty() || !this.removedPrios.isEmpty() || !this.additionalProds.isEmpty() || !this.removedProds.isEmpty();
        if (changed) {
            this.updateParseTable(reference);
        }
    }

    private void updateParseTable(ParseTable reference) {
        this.setParseTable(reference);
        ParseTable currentPT = this.getParseTable();
        for (Map.Entry f : this.additionalPrios.entries()) {
            currentPT.normalizedGrammar().priorities().put((Object)((Priority)f.getKey()), (Object)((Integer)f.getValue()));
            this.changedSymbols.add((Symbol)((Priority)f.getKey()).lower().leftHand());
        }
        for (Map.Entry f : this.removedPrios.entries()) {
            currentPT.normalizedGrammar().priorities().remove(f.getKey(), f.getValue());
            this.changedSymbols.add((Symbol)((Priority)f.getKey()).lower().leftHand());
        }
        BiMap<IProduction, Integer> prod_labels = this.getParseTable().productionLabels();
        for (IProduction p : this.removedProds) {
            currentPT.getProdLabelFactory().releaseLabel((Integer)prod_labels.remove((Object)p));
            this.changedSymbols.add((Symbol)p.leftHand());
        }
        for (IProduction p : this.additionalProds) {
            prod_labels.put((Object)p, (Object)currentPT.getProdLabelFactory().getNextLabel());
            currentPT.normalizedGrammar().getProductionAttributesMapping().putAll(this.additionalProdAttributes);
            this.getParseTable().normalizedGrammar().getSymbolProductionsMapping().put((Object)((Symbol)p.leftHand()), (Object)p);
            this.changedSymbols.add((Symbol)p.leftHand());
        }
        for (IProduction p : this.additionalProds) {
            for (State s : currentPT.getSymbolStatesMapping().getStatesfromProduction(p, currentPT.normalizedGrammar().priorities())) {
                if (!s.status().equals((Object)StateStatus.PROCESSED)) continue;
                this.invalidateCacheItemSets(s);
                s.markDirty();
            }
        }
    }

    private void invalidateCacheItemSets(State state) {
        for (ISymbol iSymbol : this.changedSymbols) {
            for (LRItem item : state.getItems()) {
                if (!item.getProd().rightHand().get(item.getDotPosition()).equals(iSymbol)) continue;
                this.getParseTable().cachedItems().remove(item);
            }
        }
    }
}

