/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.parsetable;

import java.io.Serializable;
import org.metaborg.parsetable.actions.IReduce;
import org.metaborg.parsetable.characterclasses.ICharacterClass;
import org.metaborg.parsetable.productions.IProduction;
import org.metaborg.parsetable.productions.ProductionType;
import org.metaborg.sdf2table.grammar.GeneralAttribute;
import org.metaborg.sdf2table.grammar.IAttribute;
import org.metaborg.sdf2table.parsetable.Action;
import org.metaborg.sdf2table.parsetable.ParseTable;
import org.metaborg.sdf2table.parsetable.ParseTableProduction;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public class Reduce
extends Action
implements IReduce,
Serializable {
    private static final long serialVersionUID = 4938045344795755011L;
    int prod_label;
    ParseTableProduction prod;

    public Reduce(ParseTableProduction prod, int prod_label, ICharacterClass cc) {
        this.prod = prod;
        this.prod_label = prod_label;
        this.cc = cc;
    }

    @Override
    public IStrategoTerm toAterm(ITermFactory tf, ParseTable pt) {
        return tf.makeAppl(tf.makeConstructor("reduce", 3), tf.makeInt(this.prod.getProduction().arity()), tf.makeInt(this.prod_label), tf.makeInt(this.getStatusFromParseTableProduction(pt)));
    }

    protected int getStatusFromParseTableProduction(ParseTable pt) {
        for (IAttribute attr : pt.normalizedGrammar().getProductionAttributesMapping().get((Object)this.prod.getProduction())) {
            if (!(attr instanceof GeneralAttribute)) continue;
            GeneralAttribute ga = (GeneralAttribute)attr;
            switch (ga.getName()) {
                case "reject": {
                    return 1;
                }
                case "prefer": {
                    return 2;
                }
                case "avoid": {
                    return 4;
                }
            }
        }
        return 0;
    }

    public String toString() {
        return "reduce(" + this.prod.getProduction().arity() + "," + this.prod_label + "," + (Object)((Object)this.productionType()) + ")";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.prod_label;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Reduce other = (Reduce)obj;
        return this.prod_label == other.prod_label;
    }

    @Override
    public IProduction production() {
        return this.prod;
    }

    @Override
    public ProductionType productionType() {
        return this.prod.getProductionType();
    }

    @Override
    public int arity() {
        return this.prod.getProduction().arity();
    }
}

