/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.shell;

import javax.annotation.Nullable;
import org.metaborg.spoofax.core.esv.ESVReader;
import org.metaborg.spoofax.core.shell.ShellFacet;
import org.spoofax.interpreter.terms.IStrategoAppl;

public class ShellFacetFromESV {
    @Nullable
    public static ShellFacet create(IStrategoAppl esv) {
        IStrategoAppl shellTerm = ESVReader.findTerm(esv, "Shell");
        if (shellTerm == null) {
            return null;
        }
        String commandPrefix = ShellFacetFromESV.commandPrefix(shellTerm);
        String evaluationMethod = ShellFacetFromESV.evaluationMethod(shellTerm);
        String shellStartSymbol = ShellFacetFromESV.shellStartSymbol(shellTerm);
        return new ShellFacet(commandPrefix, evaluationMethod, shellStartSymbol);
    }

    private static String commandPrefix(IStrategoAppl term) {
        return ESVReader.getProperty(term, "CommandPrefix", ":");
    }

    private static String evaluationMethod(IStrategoAppl term) {
        return ESVReader.getProperty(term, "EvaluationMethod", "dynsem");
    }

    private static String shellStartSymbol(IStrategoAppl term) {
        return ESVReader.getProperty(term, "ShellStartSymbol", "Shell");
    }
}

