/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.stratego;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.metaborg.spoofax.core.esv.ESVReader;
import org.metaborg.spoofax.core.stratego.StrategoRuntimeFacet;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.resource.ResourceUtils;
import org.spoofax.interpreter.terms.IStrategoAppl;

public class StrategoRuntimeFacetFromESV {
    private static final ILogger logger = LoggerUtils.logger(StrategoRuntimeFacetFromESV.class);

    public static StrategoRuntimeFacet create(IStrategoAppl esv, FileObject location) throws FileSystemException {
        Set<FileObject> strategoFiles = StrategoRuntimeFacetFromESV.providerResources(esv, location);
        LinkedHashSet ctreeFiles = Sets.newLinkedHashSet();
        for (FileObject strategoFile : strategoFiles) {
            String extension;
            switch (extension = strategoFile.getName().getExtension()) {
                case "ctree": {
                    ctreeFiles.add(strategoFile);
                    break;
                }
                default: {
                    logger.warn("Stratego provider file {} has unknown extension {}, ignoring", strategoFile, extension);
                }
                case "jar": 
            }
        }
        return new StrategoRuntimeFacet(ctreeFiles);
    }

    private static Set<FileObject> providerResources(IStrategoAppl esv, FileObject location) throws FileSystemException {
        LinkedHashSet attachedFiles = Sets.newLinkedHashSet();
        for (IStrategoAppl s : ESVReader.collectTerms(esv, "SemanticProvider")) {
            attachedFiles.add(ResourceUtils.resolveFile(location, ESVReader.termContents(s)));
        }
        return attachedFiles;
    }
}

