/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.stratego.primitive;

import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import org.metaborg.spoofax.core.stratego.primitive.generic.ASpoofaxPrimitive;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.util.TermUtils;

public class DigestPrimitive
extends ASpoofaxPrimitive {
    public DigestPrimitive() {
        super("digest", 0, 0);
    }

    @Override
    protected IStrategoTerm call(IStrategoTerm current, Strategy[] svars, IStrategoTerm[] tvars, ITermFactory factory, IContext context) {
        if (!TermUtils.isString(current)) {
            return null;
        }
        String str = TermUtils.toJavaString(current);
        String hash = Hashing.sha256().hashString((CharSequence)str, StandardCharsets.UTF_8).toString();
        return factory.makeString(hash);
    }
}

