/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.tracing;

import com.google.inject.Inject;
import javax.annotation.Nullable;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.MetaborgRuntimeException;
import org.metaborg.core.context.ContextException;
import org.metaborg.core.context.IContext;
import org.metaborg.core.context.IContextService;
import org.metaborg.core.language.FacetContribution;
import org.metaborg.core.language.ILanguageComponent;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.project.IProject;
import org.metaborg.core.project.IProjectService;
import org.metaborg.core.source.ISourceRegion;
import org.metaborg.core.source.SourceRegion;
import org.metaborg.core.tracing.Hover;
import org.metaborg.spoofax.core.stratego.IStrategoRuntimeService;
import org.metaborg.spoofax.core.tracing.HoverFacet;
import org.metaborg.spoofax.core.tracing.ISpoofaxHoverService;
import org.metaborg.spoofax.core.tracing.ISpoofaxTracingService;
import org.metaborg.spoofax.core.tracing.TracingCommon;
import org.metaborg.spoofax.core.unit.ISpoofaxAnalyzeUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxParseUnit;
import org.metaborg.util.concurrent.IClosableLock;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.util.TermUtils;
import org.strategoxt.HybridInterpreter;

public class HoverService
implements ISpoofaxHoverService {
    private static final ILogger logger = LoggerUtils.logger(HoverService.class);
    private final IProjectService projectService;
    private final IContextService contextService;
    private final ITermFactory termFactory;
    private final IStrategoRuntimeService strategoRuntimeService;
    private final ISpoofaxTracingService tracingService;
    private final TracingCommon common;

    @Inject
    public HoverService(IProjectService projectService, IContextService contextService, ITermFactory termFactory, IStrategoRuntimeService strategoRuntimeService, ISpoofaxTracingService tracingService, TracingCommon common) {
        this.projectService = projectService;
        this.contextService = contextService;
        this.termFactory = termFactory;
        this.strategoRuntimeService = strategoRuntimeService;
        this.tracingService = tracingService;
        this.common = common;
    }

    @Override
    public boolean available(ILanguageImpl language) {
        return language.facet(HoverFacet.class) != null;
    }

    @Override
    public Hover hover(int offset, ISpoofaxParseUnit result) throws MetaborgException {
        IContext context;
        if (!result.valid()) {
            return null;
        }
        FileObject source = result.source();
        IProject project = this.projectService.get(source);
        ILanguageImpl langImpl = result.input().langImpl();
        if (project == null) {
            context = null;
        } else {
            try {
                context = this.contextService.get(source, project, langImpl);
            }
            catch (MetaborgRuntimeException | ContextException e) {
                context = null;
            }
        }
        FacetContribution<HoverFacet> facetContrib = this.facet(langImpl);
        HoverFacet facet = (HoverFacet)facetContrib.facet;
        ILanguageComponent contributor = facetContrib.contributor;
        String strategy = facet.strategyName;
        try {
            HybridInterpreter interpreter = context == null ? this.strategoRuntimeService.runtime(contributor, source) : this.strategoRuntimeService.runtime(contributor, context);
            Iterable<IStrategoTerm> inRegion = this.tracingService.fragments(result, (ISourceRegion)new SourceRegion(offset));
            TracingCommon.TermWithRegion tuple = this.common.outputs(this.termFactory, interpreter, context.location(), source, result.ast(), inRegion, strategy);
            return this.hover(tuple);
        }
        catch (MetaborgException e) {
            throw new MetaborgException("Getting hover tooltip information failed unexpectedly", e);
        }
    }

    @Override
    public Hover hover(int offset, ISpoofaxAnalyzeUnit result) throws MetaborgException {
        if (!result.valid() || !result.hasAst()) {
            return null;
        }
        FileObject source = result.source();
        IContext context = result.context();
        ILanguageImpl language = context.language();
        FacetContribution<HoverFacet> facetContrib = this.facet(language);
        HoverFacet facet = (HoverFacet)facetContrib.facet;
        String strategy = facet.strategyName;
        try {
            TracingCommon.TermWithRegion tuple;
            HybridInterpreter interpreter = this.strategoRuntimeService.runtime(facetContrib.contributor, context);
            Iterable<IStrategoTerm> inRegion = this.tracingService.fragments(result, (ISourceRegion)new SourceRegion(offset));
            Throwable throwable = null;
            Object var13_14 = null;
            try (IClosableLock _lock = context.read();){
                tuple = this.common.outputs(this.termFactory, interpreter, context.location(), source, result.ast(), inRegion, strategy);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return this.hover(tuple);
        }
        catch (MetaborgException e) {
            throw new MetaborgException("Getting hover tooltip information failed unexpectedly", e);
        }
    }

    private FacetContribution<HoverFacet> facet(ILanguageImpl language) throws MetaborgException {
        FacetContribution<HoverFacet> facet = language.facetContribution(HoverFacet.class);
        if (facet == null) {
            String message = logger.format("Cannot get hover tooltip information for {}, it does not have a hover facet", language);
            throw new MetaborgException(message);
        }
        return facet;
    }

    private Hover hover(@Nullable TracingCommon.TermWithRegion tuple) {
        if (tuple == null) {
            return null;
        }
        IStrategoTerm output = tuple.term;
        ISourceRegion offsetRegion = tuple.region;
        String text = TermUtils.isString(output) ? TermUtils.toJavaString(output) : output.toString();
        String massagedText = text.replace("\\\"", "\"").replace("\\n", "");
        return new Hover(offsetRegion, massagedText);
    }
}

