/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.collection;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.metaborg.util.collection.BiSetMultimap;

public class BiLinkedHashMultimap<K, V>
implements BiSetMultimap<K, V> {
    private final SetMultimap<K, V> keyToValue;
    private final SetMultimap<V, K> valueToKey;

    public static <K, V> BiSetMultimap<K, V> create() {
        return new BiLinkedHashMultimap<K, V>();
    }

    public static <K, V> BiSetMultimap<K, V> create(BiSetMultimap<K, V> map) {
        return new BiLinkedHashMultimap<K, V>(map);
    }

    public BiLinkedHashMultimap() {
        this.keyToValue = LinkedHashMultimap.create();
        this.valueToKey = LinkedHashMultimap.create();
    }

    public BiLinkedHashMultimap(BiSetMultimap<K, V> map) {
        this.keyToValue = LinkedHashMultimap.create(map.keyToValue());
        this.valueToKey = LinkedHashMultimap.create(map.valueToKey());
    }

    public void clear() {
        this.keyToValue.clear();
        this.valueToKey.clear();
    }

    public boolean containsKey(Object key) {
        return this.keyToValue.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.keyToValue.containsValue(value);
    }

    public Map<K, Collection<V>> asMap() {
        return this.keyToValue.asMap();
    }

    @Override
    public Map<V, Collection<K>> asInverseMap() {
        return this.valueToKey.asMap();
    }

    public boolean containsEntry(Object key, Object value) {
        return this.keyToValue.containsEntry(key, value);
    }

    public Set<Map.Entry<K, V>> entries() {
        return this.keyToValue.entries();
    }

    public Set<V> get(K key) {
        return this.keyToValue.get(key);
    }

    @Override
    public Set<K> getInverse(V value) {
        return this.valueToKey.get(value);
    }

    public boolean isEmpty() {
        return this.keyToValue.isEmpty();
    }

    public Set<K> keySet() {
        return this.keyToValue.keySet();
    }

    public Multiset<K> keys() {
        return this.keyToValue.keys();
    }

    public boolean put(K key, V value) {
        return this.keyToValue.put(key, value) & this.valueToKey.put(value, key);
    }

    public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
        boolean result = this.keyToValue.putAll(multimap);
        for (Map.Entry entry : multimap.entries()) {
            result &= this.valueToKey.put(entry.getValue(), entry.getKey());
        }
        return result;
    }

    public boolean putAll(K key, Iterable<? extends V> values) {
        boolean result = this.keyToValue.putAll(key, values);
        for (V value : values) {
            result &= this.valueToKey.put(value, key);
        }
        return result;
    }

    public boolean remove(Object key, Object value) {
        return this.keyToValue.remove(key, value) & this.valueToKey.remove(value, key);
    }

    public Set<V> removeAll(Object key) {
        Set removed = this.keyToValue.removeAll(key);
        for (Object r : removed) {
            this.valueToKey.remove(r, key);
        }
        return removed;
    }

    @Override
    public Set<K> removeAllInverse(Object value) {
        Set removed = this.valueToKey.removeAll(value);
        for (Object r : removed) {
            this.keyToValue.remove(r, value);
        }
        return removed;
    }

    public Set<V> replaceValues(K key, Iterable<? extends V> values) {
        Set replaced = this.keyToValue.replaceValues(key, values);
        for (Object r : replaced) {
            this.valueToKey.remove(r, key);
        }
        for (Object value : values) {
            this.valueToKey.put(value, key);
        }
        return replaced;
    }

    public int size() {
        return this.keyToValue.size();
    }

    public Collection<V> values() {
        return this.keyToValue.values();
    }

    @Override
    public SetMultimap<K, V> keyToValue() {
        return this.keyToValue;
    }

    @Override
    public SetMultimap<V, K> valueToKey() {
        return this.valueToKey;
    }
}

