/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.iterators;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.metaborg.util.iterators.ArrayIterable;
import org.metaborg.util.iterators.CompoundIterable;
import org.metaborg.util.iterators.ConsIterable;
import org.metaborg.util.iterators.IteratorIterable;
import org.metaborg.util.iterators.IteratorIterableOnce;
import org.metaborg.util.iterators.Zip2Iterable;

public final class Iterables2 {
    public static <T> Iterable<T> empty() {
        return ImmutableList.of();
    }

    public static <T> Iterable<T> singleton(T t) {
        return ImmutableList.of(t);
    }

    @SafeVarargs
    public static <T> Iterable<T> from(T ... array) {
        return new ArrayIterable<T>(array);
    }

    public static <T> Iterable<T> cons(T head, Iterable<T> tail) {
        return new ConsIterable<T>(head, tail);
    }

    public static <T> Iterable<T> from(Supplier<Iterator<T>> iteratorGenerator) {
        return new IteratorIterable<T>(iteratorGenerator);
    }

    public static <T> Iterable<T> fromOnce(Iterator<T> iterator) {
        return new IteratorIterableOnce<T>(iterator);
    }

    public static <T> Iterable<T> fromConcat(Iterable<? extends Iterable<? extends T>> iterables) {
        return new CompoundIterable(iterables);
    }

    @SafeVarargs
    public static <T> Iterable<T> fromConcat(Iterable<? extends T> ... iterablesArray) {
        return Iterables2.fromConcat(Iterables2.from(iterablesArray));
    }

    public static <T> Stream<T> stream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <T1, T2, R> Iterable<R> zip(Iterable<T1> iterable1, Iterable<T2> iterable2, BiFunction<? super T1, ? super T2, R> combine) {
        return new Zip2Iterable<T1, T2, R>(iterable1, iterable2, combine);
    }
}

