/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.spoofax.interpreter.core.BindingInfo;
import org.spoofax.interpreter.core.Context;
import org.spoofax.interpreter.stratego.SDefT;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.util.DebugUtil;

public class VarScope {
    private VarScope parent;
    private Map<String, IStrategoTerm> vars;
    private Map<String, SDefT> svars;
    private Set<String> semiBound;

    public VarScope(VarScope parent) {
        this.parent = parent;
        this.vars = new HashMap<String, IStrategoTerm>(0);
        this.svars = new HashMap<String, SDefT>(0);
        this.semiBound = new HashSet<String>();
    }

    @Nullable
    public IStrategoTerm lookup(String name) {
        IStrategoTerm t = this.vars.get(name);
        if (t == null && this.parent != null) {
            t = this.parent.lookup(name);
        }
        if (DebugUtil.isDebugging()) {
            Context.debug(DebugUtil.buildIndent(2), "lookup : ", name, " = ", t);
            VarScope vs = this;
            while (vs != null) {
                Context.debug((Object)DebugUtil.buildIndent(2), (Object)vs);
                vs = vs.parent;
            }
        }
        return t;
    }

    @Nullable
    public SDefT lookupSVar(String name) {
        SDefT t = this.svars.get(name);
        if (t == null && this.parent != null) {
            return this.parent.lookupSVar(name);
        }
        return t;
    }

    public void addSVar(String svar, SDefT strat) {
        this.svars.put(svar, strat);
    }

    public void addSVars(SDefT[] sdefs) {
        int i = 0;
        int sz = sdefs.length;
        while (i < sz) {
            this.svars.put(sdefs[i].getName(), sdefs[i]);
            ++i;
        }
    }

    public void add(String var, IStrategoTerm t) {
        this.vars.put(var, t);
        this.semiBound.remove(var);
    }

    public void addVars(List<String> vars) {
        for (String var : vars) {
            this.vars.put(var, null);
            this.semiBound.remove(var);
        }
    }

    public Collection<String> getVarNames() {
        return Collections.unmodifiableCollection(this.vars.keySet());
    }

    public Collection<SDefT> getSVars() {
        return Collections.unmodifiableCollection(this.svars.values());
    }

    public String printVars() {
        StringBuilder sb = new StringBuilder("");
        Iterator<String> it = this.vars.keySet().iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(":");
        return sb.toString();
    }

    public boolean hasVarInLocalScope(String name) {
        return this.vars.containsKey(name) && this.vars.get(name) != null && !this.semiBound.contains(name);
    }

    public VarScope getParent() {
        return this.parent;
    }

    public VarScope scopeOf(String name) {
        if (this.vars.containsKey(name)) {
            return this;
        }
        if (this.parent != null) {
            return this.parent.scopeOf(name);
        }
        return null;
    }

    public String dump(String prefix, boolean localOnly) {
        String pre = prefix;
        if (!localOnly && this.parent != null) {
            pre = this.parent.dump(prefix);
        }
        if (DebugUtil.isDebugging()) {
            VarScope.debug(pre, "=== ", this);
            for (String t : this.vars.keySet()) {
                VarScope.debug(pre, "[v] ", t, "   ", this.vars.get(t));
            }
            for (String t : this.svars.keySet()) {
                VarScope.debug(pre, "[s] ", t, "   ", this.svars.get(t));
            }
            if (this.svars.size() == 0 && this.vars.size() == 0) {
                VarScope.debug(pre, "<empty>");
            }
        }
        return String.valueOf(pre) + "  ";
    }

    public String dump(String prefix) {
        return this.dump(prefix, false);
    }

    private static void debug(Object ... s) {
        DebugUtil.debug(s);
    }

    public void clear() {
        this.vars.clear();
        this.semiBound.clear();
        this.svars.clear();
    }

    public List<BindingInfo> saveUnboundVars() {
        return this.saveUnboundVars(new ArrayList<BindingInfo>());
    }

    private List<BindingInfo> saveUnboundVars(ArrayList<BindingInfo> results) {
        for (String k : this.vars.keySet()) {
            if (this.vars.get(k) != null) continue;
            results.add(new BindingInfo(this, k));
        }
        if (this.parent != null) {
            return this.parent.saveUnboundVars(results);
        }
        return results;
    }

    public static void backtrackUnboundVars(List<BindingInfo> bindings) {
        for (BindingInfo binding : bindings) {
            VarScope.debug("backtracking variable: ", binding.name);
            binding.scope.backtrackVar(binding.name);
        }
    }

    public static void restoreUnboundVars(List<BindingInfo> bindings) {
        for (BindingInfo binding : bindings) {
            VarScope.debug("restoring backtracked variable: ", binding.name);
            binding.scope.restoreVar(binding.name);
        }
    }

    private void backtrackVar(String name) {
        this.semiBound.add(name);
    }

    private void restoreVar(String name) {
        this.semiBound.remove(name);
    }

    public Collection<SDefT> getStrategyDefinitions() {
        return this.svars.values();
    }

    public boolean removeVar(String varName) {
        this.semiBound.remove(varName);
        return this.vars.remove(varName) != null;
    }

    public boolean removeSVar(String svarName) {
        return this.svars.remove(svarName) != null;
    }

    public void removeAllVars() {
        this.vars.clear();
        this.semiBound.clear();
    }
}

