/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.index;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.spoofax.interpreter.library.index.IndexEntry;
import org.spoofax.interpreter.library.index.IndexEntryFactory;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermFactory;

public class IndexCollector {
    private final ITermFactory termFactory;
    private final IndexEntryFactory entryFactory;
    private final Multiset<IndexEntry> addedEntries = HashMultiset.create();
    private final Multiset<IndexEntry> removedEntries = HashMultiset.create();
    private final Multiset<IndexEntry> oldEntries = HashMultiset.create();
    private IStrategoTerm sourceInCollection = null;

    public IndexCollector(ITermFactory termFactory, IndexEntryFactory entryFactory) {
        this.termFactory = termFactory;
        this.entryFactory = entryFactory;
    }

    public void start(IStrategoTerm source, Iterable<IndexEntry> currentEntries) {
        this.addedEntries.clear();
        this.removedEntries.clear();
        this.oldEntries.clear();
        Iterables.addAll(this.removedEntries, currentEntries);
        Iterables.addAll(this.oldEntries, currentEntries);
        this.sourceInCollection = source;
    }

    public IStrategoTuple stop() {
        this.sourceInCollection = null;
        Method method = IndexCollector.getRemoveOccurrencesMethod();
        try {
            method.invoke(null, this.addedEntries, this.oldEntries);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException("Could not invoke remove occurrences", e);
        }
        return this.termFactory.makeTuple(this.entryFactory.toKeyTerms((Iterable<IndexEntry>)this.removedEntries), this.entryFactory.toKeyTerms((Iterable<IndexEntry>)this.addedEntries));
    }

    public IndexEntry add(IStrategoTerm key, IStrategoTerm value) {
        return this.add(this.entryFactory.create(key, value, this.sourceInCollection));
    }

    public IndexEntry add(IStrategoTerm key) {
        return this.add(this.entryFactory.create(key, this.sourceInCollection));
    }

    public IndexEntry add(IndexEntry entry) {
        assert (entry.source.match(this.sourceInCollection));
        this.addedEntries.add((Object)entry);
        this.removedEntries.remove((Object)entry);
        return entry;
    }

    public Iterable<IndexEntry> getAddedEntries() {
        return this.addedEntries;
    }

    public boolean inCollection() {
        return this.sourceInCollection != null;
    }

    public void recover() {
        this.reset();
    }

    public void reset() {
        this.addedEntries.clear();
        this.removedEntries.clear();
        this.oldEntries.clear();
        this.sourceInCollection = null;
    }

    private static Method getRemoveOccurrencesMethod() {
        String methodName = "removeOccurrences";
        try {
            return Multisets.class.getDeclaredMethod("removeOccurrences", Multiset.class, Multiset.class);
        }
        catch (NoSuchMethodException e1) {
            try {
                return Multisets.class.getDeclaredMethod("removeOccurrences", Multiset.class, Iterable.class);
            }
            catch (NoSuchMethodException e2) {
                throw new RuntimeException("Cannot find removeOccurrences method via reflection", e2);
            }
        }
    }
}

