/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.jsglr.origin;

import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.library.AbstractPrimitive;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;

public class OriginSetLocationOffsetPrimitive
extends AbstractPrimitive {
    public OriginSetLocationOffsetPrimitive() {
        super("SSL_EXT_set_origin_location_offset", 0, 1);
    }

    @Override
    public final boolean call(IContext env, Strategy[] svars, IStrategoTerm[] tvars) {
        IStrategoTerm location = tvars[0];
        if (!Tools.isTermTuple(location) && location.getSubtermCount() != 4) {
            return false;
        }
        String filename = Tools.asJavaString(location.getSubterm(0));
        int line = Tools.asJavaInt(location.getSubterm(1));
        int column = Tools.asJavaInt(location.getSubterm(2));
        int startOffset = Tools.asJavaInt(location.getSubterm(3));
        int endOffset = Tools.asJavaInt(location.getSubterm(4));
        ImploderAttachment attachment = ImploderAttachment.createCompactPositionAttachment(filename, line, column, startOffset, endOffset);
        env.current().putAttachment(attachment);
        return true;
    }
}

