/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.jsglr.origin;

import java.util.ArrayList;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.library.jsglr.origin.AbstractOriginPrimitive;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.jsglr.client.imploder.IToken;
import org.spoofax.jsglr.client.imploder.ITokenizer;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;
import org.spoofax.terms.attachments.OriginAttachment;

public class OriginTokenStreamPrimitive
extends AbstractOriginPrimitive {
    public OriginTokenStreamPrimitive() {
        super("SSL_EXT_origin_token_stream");
    }

    @Override
    public IStrategoTerm call(IContext env, IStrategoTerm origin) {
        ITokenizer tokenizer = (ITokenizer)ImploderAttachment.getTokenizer(origin);
        int startIndex = ImploderAttachment.getLeftToken(origin).getIndex();
        int endIndex = ImploderAttachment.getRightToken(origin).getIndex();
        ArrayList<IStrategoTuple> tokenTuples = new ArrayList<IStrategoTuple>();
        int i = startIndex;
        while (i <= endIndex) {
            if (tokenizer.getTokenAt(i).getKind() != IToken.Kind.TK_EOF) {
                IStrategoString tokenText = env.getFactory().makeString(tokenizer.getTokenAt(i).toString());
                IStrategoInt tokenSort = env.getFactory().makeInt(tokenizer.getTokenAt(i).getKind().ordinal());
                IStrategoInt tokenIndex = env.getFactory().makeInt(i);
                IStrategoTuple tokenInfo = env.getFactory().makeTuple(tokenIndex, tokenText, tokenSort);
                IStrategoTerm nodeOfToken = OriginAttachment.getOrigin(tokenizer.getTokenAt(i).getAstNode());
                if (nodeOfToken != null) {
                    OriginAttachment.setOrigin(tokenInfo, nodeOfToken);
                }
                tokenTuples.add(tokenInfo);
            }
            ++i;
        }
        return env.getFactory().makeList(tokenTuples);
    }
}

