/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.stratego;

import java.util.ArrayList;
import org.spoofax.interpreter.core.IConstruct;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.core.Pair;
import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.stratego.StupidFormatter;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoPlaceholder;
import org.spoofax.interpreter.terms.IStrategoReal;
import org.spoofax.interpreter.terms.IStrategoRef;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.util.DebugUtil;
import org.spoofax.terms.util.NotImplementedException;
import org.spoofax.terms.util.TermUtils;

public class Match
extends Strategy {
    protected IStrategoAppl pattern;

    public Match(IStrategoAppl pattern) {
        this.pattern = pattern;
    }

    @Override
    public IConstruct eval(IContext env) throws InterpreterException {
        Match.debug("Match.eval() - ", " !", env.current(), " ; ?", this.pattern);
        IStrategoTerm current = env.current();
        Results r = this.match(env, current, this.pattern);
        if (r == null) {
            return this.getHook().pop().onFailure(env);
        }
        boolean b = env.bindVars(r);
        if (b) {
            return this.getHook().pop().onSuccess(env);
        }
        return this.getHook().pop().onFailure(env);
    }

    public Results matchAppl(IContext env, IStrategoAppl t, IStrategoAppl p) throws InterpreterException {
        if (Tools.isAnno(p, env)) {
            return this.matchAnyAnno(env, t, p);
        }
        if (Tools.isOp(p, env)) {
            return this.matchApplOp(env, t, p);
        }
        if (Tools.isInt(p, env)) {
            return this.matchApplInt(env, t, p);
        }
        if (Tools.isStr(p, env)) {
            return null;
        }
        if (Tools.isVar(p, env)) {
            return this.matchAnyVar(t, p);
        }
        if (Tools.isExplode(p, env)) {
            return this.matchAnyExplode(env, t, p);
        }
        if (Tools.isAs(p, env)) {
            return this.matchCompoundAs(env, t, p);
        }
        if (Tools.isWld(p, env)) {
            return this.matchAnyWld(p);
        }
        throw new InterpreterException("Unknown Appl case '" + p + "'");
    }

    protected Results matchApplInt(IContext env, IStrategoTerm t, IStrategoAppl p) throws InterpreterException {
        if (TermUtils.isInt(t)) {
            return this.match(env, TermUtils.toIntAt(t, 0), TermUtils.toApplAt(p, 0));
        }
        return null;
    }

    protected Results matchApplStr(IStrategoTerm t, IStrategoTerm p) {
        throw new NotImplementedException();
    }

    protected Results matchApplOp(IContext env, IStrategoAppl t, IStrategoAppl p) throws InterpreterException {
        String c = TermUtils.toJavaStringAt(p, 0);
        if (c.equals("Cons")) {
            return null;
        }
        if (c.equals("Nil")) {
            return null;
        }
        IStrategoList ctorArgs = TermUtils.toListAt(p, 1);
        if (ctorArgs.getSubtermCount() != t.getSubtermCount()) {
            return null;
        }
        if (!t.getConstructor().getName().equals(c)) {
            return null;
        }
        Results r = this.emptyList();
        int i = 0;
        while (i < ctorArgs.size()) {
            Results m = this.match(env, t.getSubterm(i), TermUtils.toApplAt(ctorArgs, i));
            if (m == null) {
                return null;
            }
            r.addAll(m);
            ++i;
        }
        return r;
    }

    private Results emptyList() {
        return new Results();
    }

    protected Results matchInt(IContext env, IStrategoInt t, IStrategoAppl p) throws InterpreterException {
        Match.debug("term is Int");
        if (Tools.isAnno(p, env)) {
            return this.matchAnyAnno(env, t, p);
        }
        if (Tools.isInt(p, env)) {
            return this.matchIntInt(t, p);
        }
        if (Tools.isReal(p, env)) {
            return null;
        }
        if (Tools.isVar(p, env)) {
            return this.matchAnyVar(t, p);
        }
        if (Tools.isOp(p, env)) {
            return null;
        }
        if (Tools.isExplode(p, env)) {
            return this.matchAnyExplode(env, t, p);
        }
        if (Tools.isWld(p, env)) {
            return this.matchAnyWld(p);
        }
        if (Tools.isAs(p, env)) {
            return this.matchCompoundAs(env, t, p);
        }
        if (Tools.isStr(p, env)) {
            return null;
        }
        throw new InterpreterException("Unknown Int case '" + p + "'");
    }

    protected Results matchReal(IContext env, IStrategoReal t, IStrategoAppl p) throws InterpreterException {
        Match.debug("term is Real");
        if (Tools.isAnno(p, env)) {
            return this.matchAnyAnno(env, t, p);
        }
        if (Tools.isInt(p, env)) {
            return null;
        }
        if (Tools.isReal(p, env)) {
            return this.matchRealReal(t, p);
        }
        if (Tools.isVar(p, env)) {
            return this.matchAnyVar(t, p);
        }
        if (Tools.isOp(p, env)) {
            return null;
        }
        if (Tools.isExplode(p, env)) {
            return this.matchAnyExplode(env, t, p);
        }
        if (Tools.isWld(p, env)) {
            return this.matchAnyWld(p);
        }
        if (Tools.isAs(p, env)) {
            return this.matchCompoundAs(env, t, p);
        }
        if (Tools.isStr(p, env)) {
            return null;
        }
        throw new InterpreterException("Unknown Real case '" + p + "'");
    }

    private Results matchRealReal(IStrategoReal t, IStrategoAppl p) {
        Double realVal = new Double(TermUtils.toJavaStringAt(p, 0));
        if (realVal.doubleValue() == t.realValue()) {
            return this.emptyList();
        }
        return null;
    }

    private Results matchAnyWld(IStrategoAppl p) {
        return this.emptyList();
    }

    protected Results matchAnyAnno(IContext env, IStrategoTerm t, IStrategoAppl p) throws InterpreterException {
        Results r1 = this.matchList(env, t.getAnnotations(), TermUtils.toApplAt(p, 1));
        if (r1 == null) {
            return null;
        }
        Results r2 = this.match(env, t, TermUtils.toApplAt(p, 0));
        if (r2 == null) {
            return null;
        }
        r2.addAll(r1);
        return r2;
    }

    protected Results matchIntInt(IStrategoInt t, IStrategoAppl p) {
        Integer intVal = new Integer(TermUtils.toJavaStringAt(p, 0));
        if (intVal.intValue() == t.intValue()) {
            return this.emptyList();
        }
        return null;
    }

    private Results newResult(Binding initial) {
        Results r = new Results();
        r.add(initial);
        return r;
    }

    private Results matchAnyExplode(IContext env, IStrategoTerm t, IStrategoAppl p) throws InterpreterException {
        DebugUtil.debug((Object)"  pattern is Explode");
        IStrategoAppl opPattern = TermUtils.toApplAt(p, 0);
        IStrategoAppl argsPattern = TermUtils.toApplAt(p, 1);
        IStrategoTerm op = this.getTermConstructor(env, t);
        IStrategoTerm args = this.getTermArguments(env, t);
        Results opResult = this.match(env, op, opPattern);
        Results argsResult = this.match(env, args, argsPattern);
        if (opResult == null || argsResult == null) {
            return null;
        }
        opResult.addAll(argsResult);
        return opResult;
    }

    private IStrategoTerm getTermArguments(IContext env, IStrategoTerm t) throws InterpreterException {
        switch (t.getType()) {
            case INT: 
            case REAL: {
                return env.getFactory().makeList();
            }
            case APPL: {
                IStrategoAppl a = (IStrategoAppl)t;
                if (Tools.isNil(a, env) || Tools.isCons(a, env)) {
                    return t;
                }
                return env.getFactory().makeList(a.getAllSubterms());
            }
            case LIST: {
                return t;
            }
            case STRING: {
                return env.getFactory().makeList();
            }
            case TUPLE: {
                IStrategoTuple tup = (IStrategoTuple)t;
                IStrategoTerm[] args = new IStrategoTerm[tup.getSubtermCount()];
                int i = 0;
                while (i < args.length) {
                    args[i] = tup.get(i);
                    ++i;
                }
                return env.getFactory().makeList(args);
            }
        }
        throw new InterpreterException("Unknown term '" + t + "'");
    }

    private IStrategoTerm getTermConstructor(IContext env, IStrategoTerm t) throws InterpreterException {
        if (TermUtils.isInt(t) || TermUtils.isReal(t)) {
            return t;
        }
        if (TermUtils.isString(t)) {
            return env.getFactory().makeString("\"" + ((IStrategoString)t).stringValue() + "\"");
        }
        if (TermUtils.isAppl(t)) {
            IStrategoAppl a = (IStrategoAppl)t;
            if (Tools.isCons(a, env) || Tools.isNil(a, env)) {
                return env.getFactory().makeAppl(env.getStrategoSignature().getNil(), new IStrategoTerm[0]);
            }
            return env.getFactory().makeString(((IStrategoAppl)t).getConstructor().getName());
        }
        if (TermUtils.isList(t)) {
            return env.getFactory().makeList();
        }
        if (TermUtils.isTuple(t)) {
            return env.getFactory().makeString("");
        }
        throw new InterpreterException("Unknown term '" + t + "'");
    }

    public Results match(IContext env, IStrategoTerm t, IStrategoAppl p) throws InterpreterException {
        if (t == null) {
            throw new InterpreterException("Null term while matching: term library or one of the primitives is defective");
        }
        switch (t.getType()) {
            case APPL: {
                return this.matchAppl(env, (IStrategoAppl)t, p);
            }
            case INT: {
                return this.matchInt(env, (IStrategoInt)t, p);
            }
            case REAL: {
                return this.matchReal(env, (IStrategoReal)t, p);
            }
            case STRING: {
                return this.matchString(env, (IStrategoString)t, p);
            }
            case LIST: {
                return this.matchList(env, (IStrategoList)t, p);
            }
            case TUPLE: {
                return this.matchTuple(env, (IStrategoTuple)t, p);
            }
            case PLACEHOLDER: {
                return this.matchPlaceholder(env, (IStrategoPlaceholder)t, p);
            }
            case REF: {
                return this.matchRef(env, (IStrategoRef)t, p);
            }
            case BLOB: {
                return this.matchBlob(env, t, p);
            }
        }
        throw new InterpreterException("Unsupported term type : " + t.getClass().toString() + " [" + (Object)((Object)t.getType()) + "]");
    }

    private Results matchBlob(IContext env, IStrategoTerm t, IStrategoAppl p) throws InterpreterException {
        Match.debug("term is Blob");
        if (Tools.isAnno(p, env)) {
            return this.matchAnyAnno(env, t, p);
        }
        if (Tools.isWld(p, env)) {
            return this.matchAnyWld(p);
        }
        if (Tools.isAs(p, env)) {
            return this.matchCompoundAs(env, t, p);
        }
        if (Tools.isVar(p, env)) {
            return this.matchAnyVar(t, p);
        }
        if (Tools.isExplode(p, env)) {
            return null;
        }
        if (Tools.isStr(p, env)) {
            return null;
        }
        if (Tools.isInt(p, env)) {
            return null;
        }
        if (Tools.isReal(p, env)) {
            return null;
        }
        if (Tools.isOp(p, env)) {
            return null;
        }
        throw new InterpreterException("Unknown Tuple case '" + p + "'");
    }

    private Results matchRef(IContext env, IStrategoRef ref, IStrategoAppl p) {
        throw new NotImplementedException();
    }

    private Results matchTuple(IContext env, IStrategoTuple t, IStrategoAppl p) throws InterpreterException {
        Match.debug("term is Tuple");
        if (Tools.isAnno(p, env)) {
            return this.matchAnyAnno(env, t, p);
        }
        if (Tools.isInt(p, env)) {
            return null;
        }
        if (Tools.isReal(p, env)) {
            return null;
        }
        if (Tools.isVar(p, env)) {
            return this.matchAnyVar(t, p);
        }
        if (Tools.isOp(p, env)) {
            return this.matchTupleOp(env, t, p);
        }
        if (Tools.isWld(p, env)) {
            return this.matchAnyWld(p);
        }
        if (Tools.isAs(p, env)) {
            return this.matchCompoundAs(env, t, p);
        }
        if (Tools.isExplode(p, env)) {
            return this.matchAnyExplode(env, t, p);
        }
        if (Tools.isStr(p, env)) {
            return null;
        }
        throw new InterpreterException("Unknown Tuple case '" + p + "'");
    }

    private Results matchTupleOp(IContext env, IStrategoTuple t, IStrategoAppl p) throws InterpreterException {
        String c = TermUtils.toJavaStringAt(p, 0);
        if (!c.equals("")) {
            return null;
        }
        IStrategoList ctorArgs = TermUtils.toListAt(p, 1);
        if (ctorArgs.size() != t.size()) {
            return null;
        }
        Results r = this.emptyList();
        int i = 0;
        while (i < ctorArgs.size()) {
            Results m = this.match(env, t.get(i), TermUtils.toApplAt(ctorArgs, i));
            if (m == null) {
                return null;
            }
            r.addAll(m);
            ++i;
        }
        return r;
    }

    private Results matchPlaceholder(IContext env, IStrategoPlaceholder t, IStrategoAppl p) throws InterpreterException {
        Match.debug("term is Placeholder");
        if (Tools.isAnno(p, env)) {
            return this.matchAnyAnno(env, t, p);
        }
        if (Tools.isInt(p, env)) {
            return null;
        }
        if (Tools.isReal(p, env)) {
            return null;
        }
        if (Tools.isVar(p, env)) {
            return this.matchAnyVar(t, p);
        }
        if (Tools.isOp(p, env)) {
            return null;
        }
        if (Tools.isWld(p, env)) {
            return this.matchAnyWld(p);
        }
        if (Tools.isAs(p, env)) {
            return this.matchCompoundAs(env, t, p);
        }
        if (Tools.isExplode(p, env)) {
            return null;
        }
        if (Tools.isStr(p, env)) {
            return null;
        }
        throw new InterpreterException("Unknown Placeholder case '" + p + "'");
    }

    protected Results matchList(IContext env, IStrategoList t, IStrategoAppl p) throws InterpreterException {
        Match.debug("term is List");
        if (Tools.isAnno(p, env)) {
            return this.matchAnyAnno(env, t, p);
        }
        if (Tools.isInt(p, env)) {
            return null;
        }
        if (Tools.isReal(p, env)) {
            return null;
        }
        if (Tools.isVar(p, env)) {
            return this.matchAnyVar(t, p);
        }
        if (Tools.isOp(p, env)) {
            return this.matchListOp(env, t, p);
        }
        if (Tools.isWld(p, env)) {
            return this.matchAnyWld(p);
        }
        if (Tools.isAs(p, env)) {
            return this.matchCompoundAs(env, t, p);
        }
        if (Tools.isExplode(p, env)) {
            return this.matchAnyExplode(env, t, p);
        }
        if (Tools.isStr(p, env)) {
            return null;
        }
        throw new InterpreterException("Unknown List case '" + p + "'");
    }

    private Results matchCompoundAs(IContext env, IStrategoTerm t, IStrategoAppl p) throws InterpreterException {
        Results r = this.match(env, t, TermUtils.toApplAt(p, 1));
        if (r == null) {
            return null;
        }
        Match.debug("matching CompoundAs", p);
        String varName = TermUtils.toJavaStringAt(TermUtils.toApplAt(p, 0), 0);
        r.add(new Binding(varName, t));
        return r;
    }

    private Results matchListOp(IContext env, IStrategoList t, IStrategoAppl p) throws InterpreterException {
        String c = TermUtils.toJavaStringAt(p, 0);
        if (c.equals("Nil")) {
            if (t.isEmpty()) {
                return this.emptyList();
            }
        } else if (c.equals("Cons")) {
            if (t.size() < 1) {
                return null;
            }
            IStrategoTerm head = t.head();
            IStrategoList tail = t.tail();
            IStrategoList pattern = TermUtils.toListAt(p, 1);
            Results r = this.match(env, head, TermUtils.toApplAt(pattern, 0));
            if (r == null) {
                return null;
            }
            Results r2 = this.match(env, tail, TermUtils.toApplAt(pattern, 1));
            if (r2 == null) {
                return null;
            }
            r.addAll(r2);
            return r;
        }
        return null;
    }

    private Results matchAnyVar(IStrategoTerm t, IStrategoAppl p) {
        String varName = TermUtils.toJavaStringAt(p, 0);
        return this.newResult(new Binding(varName, t));
    }

    private Results matchString(IContext env, IStrategoString t, IStrategoAppl p) throws InterpreterException {
        Match.debug("term is String");
        if (Tools.isAnno(p, env)) {
            return this.matchAnyAnno(env, t, p);
        }
        if (Tools.isStr(p, env)) {
            return this.matchStrStr(env, t, p);
        }
        if (Tools.isInt(p, env)) {
            return null;
        }
        if (Tools.isReal(p, env)) {
            return null;
        }
        if (Tools.isVar(p, env)) {
            return this.matchAnyVar(t, p);
        }
        if (Tools.isOp(p, env)) {
            return null;
        }
        if (Tools.isExplode(p, env)) {
            return this.matchAnyExplode(env, t, p);
        }
        if (Tools.isWld(p, env)) {
            return this.matchAnyWld(p);
        }
        if (Tools.isAs(p, env)) {
            return this.matchCompoundAs(env, t, p);
        }
        throw new InterpreterException("Unknown String case '" + p + "'");
    }

    private Results matchStrStr(IContext env, IStrategoString t, IStrategoAppl p) {
        DebugUtil.debug((Object)"  pattern is Str");
        if (!TermUtils.isStringAt(p, 0, t.stringValue())) {
            return null;
        }
        return this.emptyList();
    }

    @Override
    public void prettyPrint(StupidFormatter sf) {
        sf.first("Match(" + this.pattern.toString() + ")");
    }

    @Override
    protected String getTraceName() {
        return String.valueOf(super.getTraceName()) + "(" + this.pattern + ")";
    }

    public static final class Binding
    extends Pair<String, IStrategoTerm> {
        public Binding(String first, IStrategoTerm second) {
            super(first, second);
        }
    }

    public static final class Results
    extends ArrayList<Binding> {
    }
}

