/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client;

import org.spoofax.jsglr.client.Frame;
import org.spoofax.jsglr.client.Link;
import org.spoofax.jsglr.client.Path;

public class PooledPathList {
    int rememberIndex = 0;
    int allocIndex = 1;
    Path[] rememberPool;
    Path[] makePool;
    int usage = 0;
    public static int maxRemembered;
    public static int maxAllocated;

    public PooledPathList(int capacity, boolean deepInit) {
        this.rememberPool = new Path[capacity];
        this.makePool = new Path[capacity];
        if (deepInit) {
            int i = 0;
            while (i < capacity) {
                this.rememberPool[i] = new Path();
                ++i;
            }
            i = 0;
            while (i < capacity) {
                this.makePool[i] = new Path();
                ++i;
            }
        }
    }

    public Path rememberPath(Path parent, Link link, Frame frame, int length, int parentCount) {
        Path p;
        if (this.rememberIndex == this.rememberPool.length) {
            this.rememberPool = this.resizeArray(this.rememberPool);
        }
        if (this.rememberPool[this.rememberIndex] == null) {
            this.rememberPool[this.rememberIndex] = p = new Path();
        } else {
            p = this.rememberPool[this.rememberIndex];
        }
        ++this.rememberIndex;
        return p.reuse(parent, link, frame, length, parentCount);
    }

    public Path makePath(Path parent, Link link, Frame frame, int length, int parentCount) {
        Path p;
        if (this.allocIndex == this.makePool.length) {
            this.makePool = this.resizeArray(this.makePool);
        }
        if (this.makePool[this.allocIndex] == null) {
            this.makePool[this.allocIndex] = p = new Path();
        } else {
            p = this.makePool[this.allocIndex];
        }
        ++this.allocIndex;
        return p.reuse(parent, link, frame, length, parentCount);
    }

    private Path[] resizeArray(Path[] array) {
        Path[] result = new Path[array.length * 2];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    public int size() {
        return this.rememberIndex;
    }

    public Path get(int index) {
        return this.rememberPool[index];
    }

    public void end() {
        --this.usage;
        if (this.usage != 0) {
            throw new IllegalStateException("Must always end() the PooledPathList after use");
        }
        this.reset();
    }

    public PooledPathList start() {
        if (this.usage == 0) {
            ++this.usage;
            this.rememberIndex = 0;
            this.allocIndex = 1;
            return this;
        }
        throw new IllegalStateException("PooledPathList may not be used recursively");
    }

    public static void resetPerformanceCounters() {
        maxRemembered = 0;
        maxAllocated = 0;
    }

    public void reset() {
        maxRemembered = Math.max(maxRemembered, this.rememberIndex);
        maxAllocated = Math.max(maxAllocated, this.allocIndex);
        this.usage = 0;
        this.rememberIndex = 0;
        this.allocIndex = 0;
    }
}

