/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client;

public class StructuralTokenRecognizer {
    private static final String[] closingTokens = new String[]{"}", ")", "]|", ">", "|", "]", "*/"};
    private static final String[] openingTokens = new String[]{"{", "(", "|[", "<", "|", "["};
    private static final String[] separatorTokens = new String[]{",", ";", "<+", "+>", "+", ">", "<", "=>", "->", "&&", "&", "||", "|"};

    public boolean isScopeClosingLine(String s) {
        return this.startsWith(s, closingTokens);
    }

    public boolean isScopeOpeningLine(String s) {
        return this.startsWith(s, openingTokens);
    }

    public boolean isSeparatorStartedLine(String s) {
        return this.startsWith(s, separatorTokens);
    }

    private boolean startsWith(String s, String[] tokens) {
        int i = 0;
        while (i < tokens.length) {
            if (s.startsWith(tokens[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean endsWith(String s, String[] tokens) {
        s = s.trim();
        int i = 0;
        while (i < tokens.length) {
            if (s.endsWith(tokens[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int separatorIndent(String lineContent) {
        String line = lineContent.trim();
        int length = line.length();
        int i = 0;
        while (i < separatorTokens.length) {
            if (line.startsWith(separatorTokens[i])) {
                line = line.substring(separatorTokens[i].length());
                line = line.trim();
            }
            ++i;
        }
        return length - line.length();
    }

    public boolean isSeparatorEndingLine(String line) {
        return this.endsWith(line, separatorTokens);
    }

    public char[] removeSeparatorAtTheEnd(String aLine) {
        String line = aLine.trim();
        int i = 0;
        while (i < separatorTokens.length) {
            if (line.endsWith(separatorTokens[i])) {
                String toParse = line.substring(0, line.length() - separatorTokens[i].length());
                return toParse.toCharArray();
            }
            ++i;
        }
        return new char[0];
    }
}

