/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client.imploder;

import java.util.List;
import org.spoofax.interpreter.terms.ISimpleTerm;
import org.spoofax.jsglr.client.imploder.AbstractTokenizer;
import org.spoofax.jsglr.client.imploder.IToken;
import org.spoofax.jsglr.client.imploder.ITokens;

public class Token
implements IToken,
Cloneable {
    private static final long serialVersionUID = -6972938219235720902L;
    private transient ITokens tokens;
    private final String filename;
    private final int line;
    private final int column;
    private int startOffset;
    private int endOffset;
    private int index;
    private IToken.Kind kind;
    private String errorMessage;
    private ISimpleTerm astNode;

    public Token(ITokens tokens, String filename, int index, int line, int column, int startOffset, int endOffset, IToken.Kind kind) {
        this.tokens = tokens;
        this.filename = filename;
        this.index = index;
        this.line = line;
        this.column = column;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.kind = kind;
    }

    @Override
    public ITokens getTokenizer() {
        return this.tokens;
    }

    protected void setTokenizer(ITokens tokenizer) {
        this.tokens = tokenizer;
    }

    @Override
    public IToken.Kind getKind() {
        return this.kind;
    }

    @Override
    @Deprecated
    public int getIndex() {
        return this.index;
    }

    protected void setIndex(int index) {
        this.index = index;
    }

    @Override
    public final int getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(int startOffset) {
        this.startOffset = startOffset;
    }

    @Override
    public final int getEndOffset() {
        return this.endOffset;
    }

    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getEndLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public int getEndColumn() {
        return this.column - 1 + (this.tokens != null && this.tokens.getInput() != null && this.getStartOffset() >= 0 && this.getEndOffset() < this.tokens.getInput().length() && this.getStartOffset() <= this.getEndOffset() ? this.tokens.getInput().codePointCount(this.getStartOffset(), this.getEndOffset() + 1) : this.getLength());
    }

    @Override
    public int getLength() {
        return this.getEndOffset() - this.getStartOffset() + 1;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    public String getError() {
        return this.errorMessage;
    }

    public void setError(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Override
    public void setAstNode(ISimpleTerm astNode) {
        this.astNode = astNode;
    }

    @Override
    public ISimpleTerm getAstNode() {
        ITokens tokens;
        if (this.astNode == null && (tokens = this.getTokenizer()) instanceof AbstractTokenizer) {
            ((AbstractTokenizer)this.getTokenizer()).initAstNodeBinding();
        }
        return this.astNode;
    }

    @Override
    public IToken getTokenBefore() {
        int prevOffset = this.getStartOffset();
        List tokens = (List)this.getTokenizer().allTokens();
        int i = this.getIndex() - 1;
        while (i >= 0) {
            IToken result = (IToken)tokens.get(i);
            if (result.getEndOffset() < prevOffset && (result.getStartOffset() <= result.getEndOffset() || result.getKind() == IToken.Kind.TK_RESERVED)) {
                return result;
            }
            --i;
        }
        return null;
    }

    @Override
    public IToken getTokenAfter() {
        int nextOffset = this.getEndOffset();
        List tokens = (List)this.getTokenizer().allTokens();
        int i = this.getIndex() + 1;
        int max2 = tokens.size();
        while (i < max2) {
            IToken result = (IToken)tokens.get(i);
            if (result.getStartOffset() > nextOffset && (result.getStartOffset() <= result.getEndOffset() || result.getKind() == IToken.Kind.TK_EOF)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        return this.tokens.toString(this, this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.column;
        result = 31 * result + this.endOffset;
        result = 31 * result + this.index;
        result = 31 * result + this.kind.ordinal();
        result = 31 * result + this.line;
        result = 31 * result + this.startOffset;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Token other = (Token)obj;
        if (this.column != other.column) {
            return false;
        }
        if (this.endOffset != other.endOffset) {
            return false;
        }
        if (this.index != other.index) {
            return false;
        }
        if (this.kind != other.kind) {
            return false;
        }
        if (this.line != other.line) {
            return false;
        }
        return this.startOffset == other.startOffset;
    }

    @Override
    public int compareTo(IToken other) {
        if (this.endOffset <= other.getEndOffset()) {
            return -1;
        }
        if (this.startOffset > other.getStartOffset()) {
            return 1;
        }
        return 0;
    }

    public static int indexOf(IToken token, int c) {
        String stream = token.getTokenizer().getInput();
        int i = token.getStartOffset();
        int last = token.getEndOffset();
        while (i <= last) {
            if (stream.codePointAt(i) == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean isWhiteSpace(IToken token) {
        String input = token.getTokenizer().getInput();
        int i = token.getStartOffset();
        int last = token.getEndOffset();
        while (i <= last) {
            switch (input.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    @Override
    public Token clone() {
        try {
            return (Token)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

