/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.imploder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.metaborg.parsetable.productions.IProduction;
import org.metaborg.parsetable.symbols.IMetaVarSymbol;
import org.spoofax.jsglr2.JSGLR2Request;
import org.spoofax.jsglr2.imploder.AbstractTreeImploder;
import org.spoofax.jsglr2.imploder.ImplodeResult;
import org.spoofax.jsglr2.imploder.input.IImplodeInputFactory;
import org.spoofax.jsglr2.imploder.input.ImplodeInput;
import org.spoofax.jsglr2.imploder.treefactory.ITreeFactory;
import org.spoofax.jsglr2.parseforest.ICharacterNode;
import org.spoofax.jsglr2.parseforest.IDerivation;
import org.spoofax.jsglr2.parseforest.IParseForest;
import org.spoofax.jsglr2.parseforest.IParseNode;

public class TreeImploder<ParseForest extends IParseForest, ParseNode extends IParseNode<ParseForest, Derivation>, Derivation extends IDerivation<ParseForest>, Cache, Tree, Input extends ImplodeInput>
extends AbstractTreeImploder<ParseForest, ParseNode, Derivation, SubTree<Tree>, Cache, Tree, ImplodeResult<SubTree<Tree>, Cache, Tree>> {
    protected final IImplodeInputFactory<Input> inputFactory;
    protected final ITreeFactory<Tree> treeFactory;

    public TreeImploder(IImplodeInputFactory<Input> inputFactory, ITreeFactory<Tree> treeFactory) {
        this.inputFactory = inputFactory;
        this.treeFactory = treeFactory;
    }

    @Override
    public ImplodeResult<SubTree<Tree>, Cache, Tree> implode(JSGLR2Request request, ParseForest parseForest, Cache resultCache) {
        SubTree<Tree> result = this.implodeParseNode(this.inputFactory.get(request.input), parseForest, 0);
        return new ImplodeResult(result, null, result.tree, result.containsAmbiguity);
    }

    protected SubTree<Tree> implodeParseNode(Input input, ParseForest parseForest, int startOffset) {
        if (parseForest instanceof ICharacterNode) {
            return new SubTree<Tree>(this.treeFactory.createCharacterTerminal(((ICharacterNode)parseForest).character()), null, parseForest.width(), true);
        }
        IParseNode parseNode = this.implodeInjection((IParseNode)parseForest);
        IProduction production = parseNode.production();
        if (production.isContextFree() && !production.isSkippableInParseForest()) {
            List filteredDerivations = this.applyDisambiguationFilters(parseNode);
            if (filteredDerivations.size() > 1) {
                ArrayList trees = new ArrayList(filteredDerivations.size());
                ArrayList subTrees = new ArrayList(filteredDerivations.size());
                if (production.isList()) {
                    for (List derivationParseForests : this.implodeAmbiguousLists(filteredDerivations)) {
                        SubTree<Tree> result = this.implodeDerivationChildren(input, production, this.getChildParseForests(production, derivationParseForests), startOffset);
                        trees.add(result.tree);
                        subTrees.add(result);
                    }
                } else {
                    for (IDerivation derivation : filteredDerivations) {
                        SubTree<Tree> result = this.implodeDerivation(input, derivation, startOffset);
                        trees.add(result.tree);
                        subTrees.add(result);
                    }
                }
                return new SubTree<Tree>(this.treeFactory.createAmb(trees), subTrees, null, ((SubTree)subTrees.get((int)0)).width, false, true, false);
            }
            return this.implodeDerivation(input, (IDerivation)filteredDerivations.get(0), startOffset);
        }
        int width = parseNode.width();
        return new SubTree<Tree>(this.createLexicalTerm(production, ((ImplodeInput)input).inputString, startOffset, width), production, width, false);
    }

    protected SubTree<Tree> implodeDerivation(Input input, Derivation derivation, int startOffset) {
        IProduction production = derivation.production();
        if (!production.isContextFree()) {
            throw new RuntimeException("non context free imploding not supported");
        }
        return this.implodeDerivationChildren(input, production, this.getChildParseForests(derivation), startOffset);
    }

    protected SubTree<Tree> implodeDerivationChildren(Input input, IProduction production, List<ParseForest> childParseForests, int startOffset) {
        ArrayList childASTs = new ArrayList();
        ArrayList subTrees = new ArrayList();
        for (IParseForest childParseForest : childParseForests) {
            SubTree<Tree> subTree = this.implodeParseNode(input, childParseForest, startOffset);
            if (subTree.tree != null) {
                childASTs.add(subTree.tree);
            }
            subTrees.add(subTree);
            startOffset += subTree.width;
        }
        Object contextFreeTerm = this.createContextFreeTerm(production, childASTs);
        return new SubTree(contextFreeTerm, subTrees, production, childASTs.size() == 1 && contextFreeTerm == childASTs.get(0));
    }

    protected List<ParseForest> getChildParseForests(Derivation derivation) {
        return this.getChildParseForests(derivation.production(), Arrays.asList(derivation.parseForests()));
    }

    protected List<ParseForest> getChildParseForests(IProduction production, List<ParseForest> parseForests) {
        if (production.isList()) {
            LinkedList<IParseForest> listQueueDone = new LinkedList<IParseForest>();
            LinkedList<ParseForest> listQueueTodo = new LinkedList<ParseForest>(parseForests);
            while (!listQueueTodo.isEmpty()) {
                List filteredDerivations;
                IParseForest childParseForest = (IParseForest)listQueueTodo.removeFirst();
                IParseNode childParseNode = (IParseNode)childParseForest;
                IProduction childProduction = childParseNode.production();
                if (childProduction.isList() && childProduction.constructor() == null && (filteredDerivations = this.applyDisambiguationFilters(childParseNode)).size() <= 1) {
                    listQueueTodo.addAll(0, Arrays.asList(((IDerivation)filteredDerivations.get(0)).parseForests()));
                    continue;
                }
                listQueueDone.add(childParseForest);
            }
            return listQueueDone;
        }
        return parseForests;
    }

    protected Tree createLexicalTerm(IProduction production, String inputString, int startOffset, int width) {
        if (production.isLayout() || production.isLiteral()) {
            return null;
        }
        if (production.isLexical()) {
            String substring = inputString.substring(startOffset, startOffset + width);
            if (production.lhs() instanceof IMetaVarSymbol) {
                return this.treeFactory.createMetaVar((IMetaVarSymbol)production.lhs(), substring);
            }
            return this.treeFactory.createStringTerminal(production.lhs(), substring);
        }
        throw new RuntimeException("invalid term type");
    }

    protected Tree createContextFreeTerm(IProduction production, List<Tree> childASTs) {
        String constructor = production.constructor();
        if (constructor != null) {
            return this.treeFactory.createNonTerminal(production.lhs(), constructor, childASTs);
        }
        if (production.isOptional()) {
            return this.treeFactory.createOptional(production.lhs(), childASTs);
        }
        if (production.isList()) {
            return this.treeFactory.createList(childASTs);
        }
        if (childASTs.size() == 1) {
            return childASTs.get(0);
        }
        return this.treeFactory.createTuple(childASTs);
    }

    public static class SubTree<Tree> {
        public final Tree tree;
        public final List<SubTree<Tree>> children;
        public final IProduction production;
        public final int width;
        public final boolean isInjection;
        public final boolean isAmbiguous;
        public final boolean containsAmbiguity;
        public final boolean isCharacterTerminal;

        public SubTree(Tree tree, List<SubTree<Tree>> children, IProduction production, int width, boolean isInjection, boolean isAmbiguous, boolean isCharacterTerminal) {
            this.tree = tree;
            this.children = children;
            this.production = production;
            this.width = width;
            this.isInjection = isInjection;
            this.isAmbiguous = isAmbiguous;
            this.containsAmbiguity = isAmbiguous || SubTree.childrenContainAmbiguity(children);
            this.isCharacterTerminal = isCharacterTerminal;
        }

        public SubTree(Tree tree, List<SubTree<Tree>> children, IProduction production, boolean isInjection) {
            this(tree, children, production, SubTree.sumWidth(children), isInjection, false, false);
        }

        public SubTree(Tree tree, IProduction production, int width, boolean isCharacterTerminal) {
            this(tree, Collections.emptyList(), production, width, false, false, isCharacterTerminal);
        }

        private static <Tree> int sumWidth(List<SubTree<Tree>> children) {
            int result = 0;
            for (SubTree<Tree> child : children) {
                result += child.width;
            }
            return result;
        }

        private static <Tree> boolean childrenContainAmbiguity(List<SubTree<Tree>> children) {
            for (SubTree<Tree> child : children) {
                if (!child.containsAmbiguity) continue;
                return true;
            }
            return false;
        }
    }
}

