/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.incremental.parseforest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.metaborg.parsetable.actions.IGoto;
import org.metaborg.parsetable.productions.IProduction;
import org.metaborg.parsetable.query.ActionsForCharacterSeparated;
import org.metaborg.parsetable.query.ActionsPerCharacterClass;
import org.metaborg.parsetable.query.ProductionToGotoForLoop;
import org.metaborg.parsetable.states.IState;
import org.metaborg.parsetable.states.State;
import org.spoofax.jsglr2.incremental.parseforest.IncrementalDerivation;
import org.spoofax.jsglr2.incremental.parseforest.IncrementalParseForest;
import org.spoofax.jsglr2.parseforest.IParseForest;
import org.spoofax.jsglr2.parseforest.IParseNode;
import org.spoofax.jsglr2.util.TreePrettyPrinter;
import org.spoofax.jsglr2.util.iterators.SingleElementWithListIterable;

public class IncrementalParseNode
extends IncrementalParseForest
implements IParseNode<IncrementalParseForest, IncrementalDerivation> {
    public static final State NO_STATE = new State(-1, new ActionsForCharacterSeparated(new ActionsPerCharacterClass[0], Collections.emptySet()), new ProductionToGotoForLoop(new IGoto[0]));
    protected final IProduction production;
    private IncrementalDerivation firstDerivation;
    private List<IncrementalDerivation> otherDerivations;
    protected IState state;

    public IncrementalParseNode(IProduction production, IncrementalDerivation firstDerivation, IState state) {
        super(IParseForest.sumWidth(firstDerivation.parseForests()));
        this.production = production;
        this.firstDerivation = firstDerivation;
        this.state = state;
    }

    public IncrementalParseNode(IncrementalParseForest ... parseForests) {
        this(null, new IncrementalDerivation(null, null, parseForests), (IState)NO_STATE);
    }

    protected IncrementalParseNode(int width, IProduction production, IState state) {
        super(width);
        this.production = production;
        this.firstDerivation = null;
        this.state = state;
    }

    @Override
    public boolean isReusable() {
        return this.state != NO_STATE;
    }

    @Override
    public boolean isReusable(IState stackState) {
        if (this.production == null) {
            return false;
        }
        if (stackState.id() == this.state.id()) {
            return true;
        }
        return stackState.getGotoId(this.production.id(), -1) == this.state.getGotoId(this.production.id(), -2);
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public IProduction production() {
        return this.production;
    }

    @Override
    public void addDerivation(IncrementalDerivation derivation) {
        if (this.otherDerivations == null) {
            this.otherDerivations = new ArrayList<IncrementalDerivation>();
        }
        this.otherDerivations.add(derivation);
        this.state = NO_STATE;
    }

    @Override
    public boolean hasDerivations() {
        return this.firstDerivation != null;
    }

    @Override
    public Iterable<IncrementalDerivation> getDerivations() {
        if (this.firstDerivation == null) {
            return Collections.emptyList();
        }
        if (this.otherDerivations == null) {
            return Collections.singleton(this.firstDerivation);
        }
        return SingleElementWithListIterable.of(this.firstDerivation, this.otherDerivations);
    }

    @Override
    public IncrementalDerivation getFirstDerivation() {
        return this.firstDerivation;
    }

    @Override
    public boolean isAmbiguous() {
        return this.otherDerivations != null;
    }

    @Override
    public void disambiguate(IncrementalDerivation derivation) {
        this.firstDerivation = derivation;
        this.otherDerivations = null;
    }

    @Override
    protected void prettyPrint(TreePrettyPrinter printer) {
        if (this.production == null) {
            printer.println("p null {");
        } else {
            printer.println("p" + this.production.id() + " : " + this.production.lhs() + " (s" + this.state.id() + ") {");
        }
        if (this.isAmbiguous()) {
            printer.indent(1);
            printer.println("amb[");
            printer.indent(1);
        } else {
            printer.indent(2);
        }
        this.firstDerivation.prettyPrint(printer);
        if (this.otherDerivations != null) {
            for (IncrementalDerivation derivation : this.otherDerivations) {
                derivation.prettyPrint(printer);
            }
        }
        if (this.isAmbiguous()) {
            printer.indent(-1);
            printer.println("]");
            printer.indent(-1);
        } else {
            printer.indent(-2);
        }
        printer.println("}");
    }

    @Override
    public String getYield() {
        StringBuilder sb = new StringBuilder(this.width());
        IncrementalParseForest[] incrementalParseForestArray = this.firstDerivation.parseForests;
        int n = this.firstDerivation.parseForests.length;
        int n2 = 0;
        while (n2 < n) {
            IncrementalParseForest parseForest = incrementalParseForestArray[n2];
            sb.append(parseForest.getYield());
            ++n2;
        }
        return sb.toString();
    }

    @Override
    public String getYield(int length) {
        StringBuilder sb = new StringBuilder(length);
        int offset = 0;
        IncrementalParseForest[] incrementalParseForestArray = this.firstDerivation.parseForests;
        int n = this.firstDerivation.parseForests.length;
        int n2 = 0;
        while (n2 < n) {
            IncrementalParseForest parseForest = incrementalParseForestArray[n2];
            int width = parseForest.width();
            if (offset + width <= length) {
                sb.append(parseForest.getYield());
                offset += width;
            } else {
                sb.append(parseForest.getYield(length - offset));
                break;
            }
            ++n2;
        }
        return sb.toString();
    }
}

