/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms.io;

import java.io.IOException;
import java.util.Iterator;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoPlaceholder;
import org.spoofax.interpreter.terms.IStrategoReal;
import org.spoofax.interpreter.terms.IStrategoRef;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.terms.attachments.ITermAttachment;
import org.spoofax.terms.io.TextTermWriter;
import org.spoofax.terms.util.StringUtils;

public class SimpleTextTermWriter
implements TextTermWriter {
    private static final SimpleTextTermWriter INSTANCE = new SimpleTextTermWriter();
    private static final String ELLIPSIS = "\u2026";
    private static final String LIST_SEPARATOR = ",";
    private static final String LIST_TAIL_SEPARATOR = "|";
    private final int maxDepth;
    private final boolean ignoreAnnotations;
    private final boolean ignoreAttachments;
    private final boolean ignoreListTailAttributes;
    private final boolean ignoreAnnotationAttributes;

    public static SimpleTextTermWriter getInstance() {
        return INSTANCE;
    }

    public SimpleTextTermWriter() {
        this(Integer.MAX_VALUE);
    }

    public SimpleTextTermWriter(int maxDepth) {
        this(maxDepth, false, true);
    }

    public SimpleTextTermWriter(int maxDepth, boolean ignoreAnnotations, boolean ignoreAttachments) {
        this(maxDepth, ignoreAnnotations, ignoreAttachments, true, true);
    }

    public SimpleTextTermWriter(int maxDepth, boolean ignoreAnnotations, boolean ignoreAttachments, boolean ignoreListTailAttributes, boolean ignoreAnnotationAttributes) {
        this.maxDepth = maxDepth;
        this.ignoreAnnotations = ignoreAnnotations;
        this.ignoreAttachments = ignoreAttachments;
        this.ignoreListTailAttributes = ignoreListTailAttributes;
        this.ignoreAnnotationAttributes = ignoreAnnotationAttributes;
    }

    @Override
    public void write(IStrategoTerm term, Appendable writer) throws IOException {
        this.writeTerm(term, writer, this.maxDepth, false);
    }

    protected void writeTerm(IStrategoTerm term, Appendable writer, int depth, boolean isAnnotation) throws IOException {
        if (depth <= 0) {
            this.writeElided(writer);
            return;
        }
        switch (term.getType()) {
            case APPL: {
                this.writeApplBody((IStrategoAppl)term, writer, depth, isAnnotation);
                break;
            }
            case LIST: {
                this.writeListBody((IStrategoList)term, writer, depth, isAnnotation);
                break;
            }
            case TUPLE: {
                this.writeTupleBody((IStrategoTuple)term, writer, depth, isAnnotation);
                break;
            }
            case INT: {
                this.writeIntBody((IStrategoInt)term, writer, depth, isAnnotation);
                break;
            }
            case REAL: {
                this.writeRealBody((IStrategoReal)term, writer, depth, isAnnotation);
                break;
            }
            case STRING: {
                this.writeStringBody((IStrategoString)term, writer, depth, isAnnotation);
                break;
            }
            case REF: {
                this.writeRefBody((IStrategoRef)term, writer, depth, isAnnotation);
                break;
            }
            case PLACEHOLDER: {
                this.writePlaceholderBody((IStrategoPlaceholder)term, writer, depth, isAnnotation);
                break;
            }
            default: {
                throw new RuntimeException("Unknown term type: " + (Object)((Object)term.getType()) + " for term of type " + term.getClass().getSimpleName());
            }
        }
        if (this.termHasAnnotations(term, isAnnotation)) {
            this.writeAnnotations(term, writer, depth, isAnnotation);
        }
        if (this.termHasAttachments(term, isAnnotation)) {
            this.writeAttachments(term, writer, depth, isAnnotation);
        }
    }

    protected void writeApplBody(IStrategoAppl term, Appendable writer, int depth, boolean isAnnotation) throws IOException {
        writer.append(term.getConstructor().getName());
        writer.append('(');
        this.writeSubterms(term, writer, depth - 1, isAnnotation);
        writer.append(')');
    }

    protected void writeListBody(IStrategoList term, Appendable writer, int depth, boolean isAnnotation) throws IOException {
        writer.append('[');
        if (!term.isEmpty()) {
            this.writeTerm(term.head(), writer, depth - 1, isAnnotation);
            IStrategoList tail = term.tail();
            while (!tail.isEmpty()) {
                if (this.tailHasTermAttributes(tail, isAnnotation)) {
                    writer.append(LIST_TAIL_SEPARATOR);
                    this.writeTerm(tail, writer, depth, isAnnotation);
                } else {
                    writer.append(LIST_SEPARATOR);
                    this.writeTerm(tail.head(), writer, depth - 1, isAnnotation);
                }
                tail = tail.tail();
            }
        }
        writer.append(']');
    }

    protected void writeTupleBody(IStrategoTuple term, Appendable writer, int depth, boolean isAnnotation) throws IOException {
        writer.append('(');
        this.writeSubterms(term, writer, depth - 1, isAnnotation);
        writer.append(')');
    }

    protected void writeIntBody(IStrategoInt term, Appendable writer, int depth, boolean isAnnotation) throws IOException {
        writer.append(Integer.toString(term.intValue()));
    }

    protected void writeRealBody(IStrategoReal term, Appendable writer, int depth, boolean isAnnotation) throws IOException {
        writer.append(Double.toString(term.realValue()));
    }

    protected void writeStringBody(IStrategoString term, Appendable writer, int depth, boolean isAnnotation) throws IOException {
        writer.append('\"');
        StringUtils.appendEscape(term.stringValue(), writer);
        writer.append('\"');
    }

    protected void writeRefBody(IStrategoRef term, Appendable writer, int depth, boolean isAnnotation) throws IOException {
        throw new RuntimeException("REF terms are not supported.");
    }

    protected void writePlaceholderBody(IStrategoPlaceholder term, Appendable writer, int depth, boolean isAnnotation) throws IOException {
        writer.append('<');
        this.writeTerm(term.getTemplate(), writer, this.maxDepth - 1, isAnnotation);
        writer.append('>');
    }

    protected void writeAnnotations(IStrategoTerm term, Appendable writer, int depth, boolean isAnnotation) throws IOException {
        IStrategoList annos = term.getAnnotations();
        if (depth <= 1 || annos.isEmpty()) {
            return;
        }
        writer.append('{');
        this.writeSubterms(annos, writer, depth - 1, true);
        writer.append('}');
    }

    protected void writeAttachments(IStrategoTerm term, Appendable writer, int depth, boolean isAnnotation) throws IOException {
        Object attachment = term.getAttachment(null);
        if (depth <= 1 || attachment == null) {
            return;
        }
        writer.append('\u00ab');
        this.writeAttachment((ITermAttachment)attachment, writer, depth - 1);
        attachment = attachment.getNext();
        while (attachment != null) {
            writer.append(LIST_SEPARATOR);
            this.writeAttachment((ITermAttachment)attachment, writer, depth - 1);
            attachment = attachment.getNext();
        }
        writer.append('\u00bb');
    }

    protected void writeAttachment(ITermAttachment attachment, Appendable writer, int depth) throws IOException {
        writer.append(attachment.getClass().getSimpleName());
        writer.append('<');
        writer.append(attachment.toString());
        writer.append('>');
    }

    private void writeSubterms(IStrategoTerm term, Appendable writer, int depth, boolean isAnnotation) throws IOException {
        Iterator<IStrategoTerm> iterator = term.iterator();
        if (iterator.hasNext()) {
            this.writeTerm(iterator.next(), writer, depth, isAnnotation);
            while (iterator.hasNext()) {
                writer.append(LIST_SEPARATOR);
                this.writeTerm(iterator.next(), writer, depth, isAnnotation);
            }
        }
    }

    private boolean tailHasTermAttributes(IStrategoList term, boolean isAnnotation) {
        return !this.ignoreListTailAttributes || this.termHasAnnotations(term, isAnnotation) || this.termHasAttachments(term, isAnnotation);
    }

    private boolean termHasAnnotations(IStrategoTerm term, boolean isAnnotation) {
        return !this.ignoreAnnotations && (!this.ignoreAnnotationAttributes || !isAnnotation) && !term.getAnnotations().isEmpty();
    }

    private boolean termHasAttachments(IStrategoTerm term, boolean isAnnotation) {
        return !this.ignoreAttachments && (!this.ignoreAnnotationAttributes || !isAnnotation) && term.getAttachment(null) != null;
    }

    protected void writeElided(Appendable writer) throws IOException {
        writer.append(ELLIPSIS);
    }
}

