/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.spoofax.terms.util.NotImplementedException;

public class WeakValueHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private Map hash;
    private ReferenceQueue queue = new ReferenceQueue();

    @Override
    public Set entrySet() {
        this.processQueue();
        throw new NotImplementedException();
    }

    private void processQueue() {
        WeakValueRef ref;
        while ((ref = (WeakValueRef)this.queue.poll()) != null) {
            if (ref != (WeakValueRef)this.hash.get(ref.key)) continue;
            this.hash.remove(ref.key);
        }
    }

    public WeakValueHashMap(int initialCapacity, float loadFactor) {
        this.hash = new HashMap(initialCapacity, loadFactor);
    }

    public WeakValueHashMap(int initialCapacity) {
        this.hash = new HashMap(initialCapacity);
    }

    public WeakValueHashMap() {
        this.hash = new HashMap();
    }

    public WeakValueHashMap(Map t) {
        this(Math.max(2 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    @Override
    public int size() {
        this.processQueue();
        return this.hash.size();
    }

    @Override
    public boolean isEmpty() {
        this.processQueue();
        return this.hash.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.processQueue();
        return this.hash.containsKey(key);
    }

    @Override
    public V get(Object key) {
        this.processQueue();
        WeakReference ref = (WeakReference)this.hash.get(key);
        if (ref != null) {
            return (V)ref.get();
        }
        return null;
    }

    @Override
    public Object put(Object key, Object value) {
        this.processQueue();
        WeakValueRef rtn = this.hash.put(key, WeakValueRef.create(key, value, this.queue));
        if (rtn != null) {
            rtn = ((WeakReference)rtn).get();
        }
        return rtn;
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        return (V)((WeakReference)this.hash.remove(key)).get();
    }

    @Override
    public void clear() {
        this.processQueue();
        this.hash.clear();
    }

    private static class WeakValueRef
    extends WeakReference {
        public Object key;

        private WeakValueRef(Object key, Object val, ReferenceQueue q) {
            super(val, q);
            this.key = key;
        }

        private static WeakValueRef create(Object key, Object val, ReferenceQueue q) {
            if (val == null) {
                return null;
            }
            return new WeakValueRef(key, val, q);
        }
    }
}

