/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang.gradual;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.strategoxt.lang.gradual.Type;

public class OneOf
implements Type {
    public final Set<Type> types;

    public OneOf(Set<Type> types) {
        if (types.isEmpty()) {
            throw new IllegalArgumentException("Types in OneOf may not be empty");
        }
        this.types = new HashSet<Type>();
        for (Type type : types) {
            if (type instanceof OneOf) {
                this.types.addAll(((OneOf)type).types);
                continue;
            }
            this.types.add(type);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.types.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OneOf other = (OneOf)obj;
        return this.types.equals(other.types);
    }

    @Override
    public String toString() {
        StringBuilder typesStringBuilder = new StringBuilder();
        Iterator<Type> iterator = this.types.iterator();
        while (true) {
            typesStringBuilder.append(iterator.next().toString());
            if (!iterator.hasNext()) break;
            typesStringBuilder.append(", ");
        }
        return "oneOf(" + typesStringBuilder + ")";
    }
}

