/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.client;

import com.google.common.base.Strings;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.SessionContext;
import oracle.pgx.client.PgxRemoteRequest;
import oracle.pgx.client.RemoteResponse;
import oracle.pgx.common.AsyncStatus;
import oracle.pgx.common.marshalers.Marshaler;
import oracle.pgx.common.marshalers.Marshalers;
import oracle.pgx.common.util.Constants;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.function.LoggerFunctionalInterface;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.fluent.Executor;
import org.apache.hc.client5.http.fluent.Response;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.cookie.BasicClientCookie;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.StatusLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteUtils.class);

    public static String stripTrailingSlash(String path) {
        if (path == null || !path.endsWith("/")) {
            return path;
        }
        return path.substring(0, path.length() - 1);
    }

    public static String getResponseContent(Response response) throws ExecutionException, RequestPendingException, IOException {
        return RemoteUtils.getResponseContent(response, Logger::debug);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResponseContent(Response response, LoggerFunctionalInterface logger) throws IOException, ExecutionException, RequestPendingException {
        String string;
        HttpEntity entity = null;
        try {
            ClassicHttpResponse httpResponse = (ClassicHttpResponse)response.returnResponse();
            int status = httpResponse.getCode();
            logger.log(LOG, "received HTTP status {}", new Object[]{status});
            if (status == 202) {
                throw new RequestPendingException();
            }
            entity = httpResponse.getEntity();
            String json = RemoteUtils.httpEntityToString(entity);
            if (LOG.isDebugEnabled()) {
                logger.log(LOG, json.length() < 2500 ? json : json.substring(0, 2500), new Object[0]);
            }
            if (status >= 400) {
                throw RemoteUtils.parseExceptionalResponse(status, (HttpResponse)httpResponse, entity, json);
            }
            string = json;
        }
        catch (Throwable throwable) {
            EntityUtils.consume(entity);
            throw throwable;
        }
        EntityUtils.consume((HttpEntity)entity);
        return string;
    }

    static ExecutionException parseExceptionalResponse(int status, HttpResponse httpResponse, HttpEntity entity, String json) throws IOException {
        Throwable cause;
        if (status == 401) {
            cause = new IllegalArgumentException("UNAUTHORIZED_RESPONSE");
        } else {
            ContentType contentType = ContentType.parse((CharSequence)entity.getContentType());
            String mimeType = contentType.getMimeType();
            if (!mimeType.equals(ContentType.APPLICATION_JSON.getMimeType())) {
                LOG.error(ErrorMessages.getMessage((String)"WRONG_CONTENT_TYPE", (Object[])new Object[]{mimeType, ContentType.APPLICATION_JSON.getMimeType()}));
                cause = new IOException(ErrorMessages.getMessage((String)"FAIL_TO_PARSE_CONTENT", (Object[])new Object[]{new StatusLine(httpResponse), mimeType, ContentType.APPLICATION_JSON.getMimeType()}));
            } else {
                cause = Marshalers.EXCEPTION_MARSHALER.unmarshal(json);
            }
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        return new ExecutionException(cause);
    }

    public static <T> T parse(Response response, Marshaler<T> marshaler) throws IOException, ExecutionException, RequestPendingException {
        String json = RemoteUtils.getResponseContent(response);
        return (T)marshaler.unmarshal(json);
    }

    public static AsyncStatus parseAsyncStatus(Response response) throws IOException, ExecutionException, RequestPendingException {
        String json = RemoteUtils.getResponseContent(response, Logger::trace);
        return (AsyncStatus)Marshalers.ASYNC_STATUS_MARSHALER.unmarshal(json);
    }

    public static Executor newHttpExecutor(CloseableHttpClient client, String baseUrl, SessionContext sessionContext, String csrfToken, Cookie clientStickyCookie) {
        return Executor.newInstance((CloseableHttpClient)client).use(RemoteUtils.createCookieStore(baseUrl, sessionContext, csrfToken, clientStickyCookie));
    }

    public static CookieStore createCookieStore(String baseUrl, SessionContext sessionContext, String csrfToken, Cookie clientStickyCookie) {
        BasicCookieStore cookieStore = new BasicCookieStore();
        if (sessionContext != null && sessionContext.getSessionId() != null) {
            String sessionId = sessionContext.getSessionId();
            LOG.debug("create session cookie (session ID = {})", (Object)sessionId);
            cookieStore.addCookie(RemoteUtils.createCookie(baseUrl, "SID", sessionId));
            RemoteUtils.addStickySessionCookie(baseUrl, sessionContext, (CookieStore)cookieStore);
        }
        if (csrfToken != null) {
            LOG.debug("create csrf token cookie (token = {})", (Object)csrfToken);
            cookieStore.addCookie(RemoteUtils.createCookie(baseUrl, "_csrf_token", csrfToken));
        }
        if (clientStickyCookie != null) {
            LOG.debug("create client sticky cookie (value = {})", (Object)clientStickyCookie.getValue());
            cookieStore.addCookie(clientStickyCookie);
        }
        return cookieStore;
    }

    private static void addStickySessionCookie(String baseUrl, SessionContext sessionContext, CookieStore cookieStore) {
        String cookieValue = sessionContext.getStickyCookieValue();
        if (cookieValue != null) {
            LOG.debug("create sticky cookie");
            RemoteUtils.validateStickyCookieValue(cookieValue);
            cookieStore.addCookie(RemoteUtils.createCookie(baseUrl, "PGX_SESSION_STICKY_COOKIE", cookieValue));
        } else {
            LOG.debug("no value for the sticky cookie given");
        }
    }

    public static Optional<Cookie> findCookie(String cookieName, CookieStore cookieStore) {
        return cookieStore.getCookies().stream().filter(cookie -> Objects.equals(cookie.getName(), cookieName)).findAny();
    }

    public static Cookie createCookie(String baseUrl, String name, String value) {
        assert (baseUrl != null);
        assert (name != null);
        assert (value != null);
        BasicClientCookie cookie = new BasicClientCookie(name, value);
        try {
            String host = new URL(baseUrl).getHost();
            if (Strings.isNullOrEmpty((String)host)) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"PARAMETER_IS_REQUIRED", (Object[])new Object[]{"domain"}));
            }
            cookie.setDomain(host);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("cannot set domain of cookie", e);
        }
        return cookie;
    }

    static RemoteResponse buildRemoteResponse(HttpResponse httpResponse, URI remoteFutureLocation) {
        if (httpResponse.getFirstHeader("Location") == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"COULD_NOT_RETRIEVE_HTTP_HEADER", (Object[])new Object[]{"Location"}));
        }
        if (httpResponse.getFirstHeader("x-future-id") == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"COULD_NOT_RETRIEVE_HTTP_HEADER", (Object[])new Object[]{"x-future-id"}));
        }
        String futureUuid = httpResponse.getFirstHeader("x-future-id").getValue();
        return new RemoteResponse(remoteFutureLocation, futureUuid);
    }

    public static <T> PgxFuture<T> asyncRequest(ExecutorService executorService, PgxRemoteRequest<T> request) {
        PgxFuture promise = new PgxFuture();
        executorService.execute(() -> {
            try {
                Object result = request.request();
                promise.complete(result);
            }
            catch (ExecutionException e) {
                promise.completeExceptionally(e.getCause());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                promise.completeExceptionally((Throwable)e);
            }
            catch (Throwable e) {
                promise.completeExceptionally(e);
            }
        });
        return promise;
    }

    static String httpEntityToString(HttpEntity entity) throws IOException {
        try {
            return EntityUtils.toString((HttpEntity)entity);
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    static void validateStickyCookieValue(String stickyCookieValue) {
        if (!Constants.STICKY_COOKIE_SANITIZATION_REGEX_PATTERN.matcher(stickyCookieValue).matches()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_STICKY_COOKIE_VALUE", (Object[])new Object[]{stickyCookieValue}));
        }
    }

    public static class RequestPendingException
    extends Exception {
    }
}

