
# Autogenerated by mlir-tblgen; don't manually edit.

from ._ods_common import _cext as _ods_cext
from ._ods_common import extend_opview_class as _ods_extend_opview_class, segmented_accessor as _ods_segmented_accessor, equally_sized_accessor as _ods_equally_sized_accessor, get_default_loc_context as _ods_get_default_loc_context, get_op_result_or_value as _get_op_result_or_value, get_op_results_or_values as _get_op_results_or_values, get_op_result_or_op_results as _get_op_result_or_op_results
_ods_ir = _ods_cext.ir

try:
  from . import _memref_ops_ext as _ods_ext_module
except ImportError:
  _ods_ext_module = None

import builtins
from typing import Sequence as _Sequence, Union as _Union


@_ods_cext.register_dialect
class _Dialect(_ods_ir.Dialect):
  DIALECT_NAMESPACE = "memref"
  pass


@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class AssumeAlignmentOp(_ods_ir.OpView):
  OPERATION_NAME = "memref.assume_alignment"

  _ODS_REGIONS = (0, True)

  def __init__(self, memref, alignment, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(memref))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["alignment"] = (alignment if (
    issubclass(type(alignment), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(alignment, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def memref(self):
    return self.operation.operands[0]

  @builtins.property
  def alignment(self):
    return self.operation.attributes["alignment"]

  @alignment.setter
  def alignment(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["alignment"] = value

def assume_alignment(memref, alignment, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(AssumeAlignmentOp(memref=memref, alignment=alignment, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class AtomicRMWOp(_ods_ir.OpView):
  OPERATION_NAME = "memref.atomic_rmw"

  _ODS_REGIONS = (0, True)

  def __init__(self, kind, value, memref, indices, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(value))
    operands.append(_get_op_result_or_value(memref))
    operands.extend(_get_op_results_or_values(indices))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["kind"] = (kind if (
    issubclass(type(kind), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('AtomicRMWKindAttr')) else
      _ods_ir.AttrBuilder.get('AtomicRMWKindAttr')(kind, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def value(self):
    return self.operation.operands[0]

  @builtins.property
  def memref(self):
    return self.operation.operands[1]

  @builtins.property
  def indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[2:2 + _ods_variadic_group_length]

  @builtins.property
  def kind(self):
    return self.operation.attributes["kind"]

  @kind.setter
  def kind(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["kind"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def atomic_rmw(kind, value, memref, indices, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return _get_op_result_or_op_results(AtomicRMWOp(kind=kind, value=value, memref=memref, indices=indices, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class AtomicYieldOp(_ods_ir.OpView):
  OPERATION_NAME = "memref.atomic_yield"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(result))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def result(self):
    return self.operation.operands[0]

def atomic_yield(result, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(AtomicYieldOp(result=result, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class CopyOp(_ods_ir.OpView):
  OPERATION_NAME = "memref.copy"

  _ODS_REGIONS = (0, True)

  def __init__(self, source, target, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_result_or_value(target))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def target(self):
    return self.operation.operands[1]

def copy(source, target, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(CopyOp(source=source, target=target, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class GenericAtomicRMWOp(_ods_ir.OpView):
  OPERATION_NAME = "memref.generic_atomic_rmw"

  _ODS_REGIONS = (1, True)

  @builtins.property
  def memref(self):
    return self.operation.operands[0]

  @builtins.property
  def indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

  @builtins.property
  def atomic_body(self):
    return self.regions[0]

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class LoadOp(_ods_ir.OpView):
  OPERATION_NAME = "memref.load"

  _ODS_REGIONS = (0, True)

  def __init__(self, memref, indices, *, nontemporal=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(memref))
    operands.extend(_get_op_results_or_values(indices))
    _ods_context = _ods_get_default_loc_context(loc)
    if nontemporal is not None: attributes["nontemporal"] = (nontemporal if (
        issubclass(type(nontemporal), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(nontemporal, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def memref(self):
    return self.operation.operands[0]

  @builtins.property
  def indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def nontemporal(self):
    if "nontemporal" not in self.operation.attributes:
      return None
    return self.operation.attributes["nontemporal"]

  @nontemporal.setter
  def nontemporal(self, value):
    if value is not None:
      self.operation.attributes["nontemporal"] = value
    elif "nontemporal" in self.operation.attributes:
      del self.operation.attributes["nontemporal"]

  @nontemporal.deleter
  def nontemporal(self):
    del self.operation.attributes["nontemporal"]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def load(memref, indices, *, nontemporal=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return _get_op_result_or_op_results(LoadOp(memref=memref, indices=indices, nontemporal=nontemporal, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class AllocOp(_ods_ir.OpView):
  OPERATION_NAME = "memref.alloc"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, memref, dynamicSizes, symbolOperands, *, alignment=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(dynamicSizes))
    operands.append(_get_op_results_or_values(symbolOperands))
    _ods_context = _ods_get_default_loc_context(loc)
    if alignment is not None: attributes["alignment"] = (alignment if (
        issubclass(type(alignment), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(alignment, context=_ods_context))
    results.append(memref)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def dynamicSizes(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def symbolOperands(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def alignment(self):
    if "alignment" not in self.operation.attributes:
      return None
    return self.operation.attributes["alignment"]

  @alignment.setter
  def alignment(self, value):
    if value is not None:
      self.operation.attributes["alignment"] = value
    elif "alignment" in self.operation.attributes:
      del self.operation.attributes["alignment"]

  @alignment.deleter
  def alignment(self):
    del self.operation.attributes["alignment"]

  @builtins.property
  def memref(self):
    return self.operation.results[0]

def alloc(memref, dynamic_sizes, symbol_operands, *, alignment=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return _get_op_result_or_op_results(AllocOp(memref=memref, dynamicSizes=dynamic_sizes, symbolOperands=symbol_operands, alignment=alignment, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class AllocaOp(_ods_ir.OpView):
  OPERATION_NAME = "memref.alloca"

  _ODS_OPERAND_SEGMENTS = [-1,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, memref, dynamicSizes, symbolOperands, *, alignment=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_results_or_values(dynamicSizes))
    operands.append(_get_op_results_or_values(symbolOperands))
    _ods_context = _ods_get_default_loc_context(loc)
    if alignment is not None: attributes["alignment"] = (alignment if (
        issubclass(type(alignment), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(alignment, context=_ods_context))
    results.append(memref)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def dynamicSizes(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range

  @builtins.property
  def symbolOperands(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def alignment(self):
    if "alignment" not in self.operation.attributes:
      return None
    return self.operation.attributes["alignment"]

  @alignment.setter
  def alignment(self, value):
    if value is not None:
      self.operation.attributes["alignment"] = value
    elif "alignment" in self.operation.attributes:
      del self.operation.attributes["alignment"]

  @alignment.deleter
  def alignment(self):
    del self.operation.attributes["alignment"]

  @builtins.property
  def memref(self):
    return self.operation.results[0]

def alloca(memref, dynamic_sizes, symbol_operands, *, alignment=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return _get_op_result_or_op_results(AllocaOp(memref=memref, dynamicSizes=dynamic_sizes, symbolOperands=symbol_operands, alignment=alignment, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class AllocaScopeOp(_ods_ir.OpView):
  OPERATION_NAME = "memref.alloca_scope"

  _ODS_REGIONS = (1, True)

  def __init__(self, results_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(results_)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def results_(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

  @builtins.property
  def bodyRegion(self):
    return self.regions[0]

def alloca_scope(results_, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return _get_op_result_or_op_results(AllocaScopeOp(results_=results_, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class AllocaScopeReturnOp(_ods_ir.OpView):
  OPERATION_NAME = "memref.alloca_scope.return"

  _ODS_REGIONS = (0, True)

  def __init__(self, results_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(results_))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def results_(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def alloca_scope_return(results_, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(AllocaScopeReturnOp(results_=results_, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class CastOp(_ods_ir.OpView):
  OPERATION_NAME = "memref.cast"

  _ODS_REGIONS = (0, True)

  def __init__(self, dest, source, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(dest)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def dest(self):
    return self.operation.results[0]

def cast(dest, source, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return _get_op_result_or_op_results(CastOp(dest=dest, source=source, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class CollapseShapeOp(_ods_ir.OpView):
  OPERATION_NAME = "memref.collapse_shape"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, src, reassociation, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(src))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["reassociation"] = (reassociation if (
    issubclass(type(reassociation), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('IndexListArrayAttr')) else
      _ods_ir.AttrBuilder.get('IndexListArrayAttr')(reassociation, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def src(self):
    return self.operation.operands[0]

  @builtins.property
  def reassociation(self):
    return self.operation.attributes["reassociation"]

  @reassociation.setter
  def reassociation(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["reassociation"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def collapse_shape(result, src, reassociation, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return _get_op_result_or_op_results(CollapseShapeOp(result=result, src=src, reassociation=reassociation, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class DeallocOp(_ods_ir.OpView):
  OPERATION_NAME = "memref.dealloc"

  _ODS_REGIONS = (0, True)

  def __init__(self, memref, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(memref))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def memref(self):
    return self.operation.operands[0]

def dealloc(memref, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(DeallocOp(memref=memref, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class DimOp(_ods_ir.OpView):
  OPERATION_NAME = "memref.dim"

  _ODS_REGIONS = (0, True)

  def __init__(self, source, index, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_result_or_value(index))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def index(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def dim(source, index, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return _get_op_result_or_op_results(DimOp(source=source, index=index, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class DmaStartOp(_ods_ir.OpView):
  OPERATION_NAME = "memref.dma_start"

  _ODS_REGIONS = (0, True)

  def __init__(self, operands_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(operands_))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def operands_(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def dma_start(operands_, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(DmaStartOp(operands_=operands_, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class DmaWaitOp(_ods_ir.OpView):
  OPERATION_NAME = "memref.dma_wait"

  _ODS_REGIONS = (0, True)

  def __init__(self, tagMemRef, tagIndices, numElements, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(tagMemRef))
    operands.extend(_get_op_results_or_values(tagIndices))
    operands.append(_get_op_result_or_value(numElements))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def tagMemRef(self):
    return self.operation.operands[0]

  @builtins.property
  def tagIndices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def numElements(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[2 + _ods_variadic_group_length - 1]

def dma_wait(tag_mem_ref, tag_indices, num_elements, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(DmaWaitOp(tagMemRef=tag_mem_ref, tagIndices=tag_indices, numElements=num_elements, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ExpandShapeOp(_ods_ir.OpView):
  OPERATION_NAME = "memref.expand_shape"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, src, reassociation, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(src))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["reassociation"] = (reassociation if (
    issubclass(type(reassociation), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('IndexListArrayAttr')) else
      _ods_ir.AttrBuilder.get('IndexListArrayAttr')(reassociation, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def src(self):
    return self.operation.operands[0]

  @builtins.property
  def reassociation(self):
    return self.operation.attributes["reassociation"]

  @reassociation.setter
  def reassociation(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["reassociation"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def expand_shape(result, src, reassociation, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return _get_op_result_or_op_results(ExpandShapeOp(result=result, src=src, reassociation=reassociation, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ExtractAlignedPointerAsIndexOp(_ods_ir.OpView):
  OPERATION_NAME = "memref.extract_aligned_pointer_as_index"

  _ODS_REGIONS = (0, True)

  def __init__(self, source, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def aligned_pointer(self):
    return self.operation.results[0]

def extract_aligned_pointer_as_index(source, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return _get_op_result_or_op_results(ExtractAlignedPointerAsIndexOp(source=source, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ExtractStridedMetadataOp(_ods_ir.OpView):
  OPERATION_NAME = "memref.extract_strided_metadata"

  _ODS_REGIONS = (0, True)

  def __init__(self, source, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def base_buffer(self):
    start, pg = _ods_equally_sized_accessor(operation.results, 2, 0, 0)
    return self.operation.results[start]

  @builtins.property
  def offset(self):
    start, pg = _ods_equally_sized_accessor(operation.results, 2, 1, 0)
    return self.operation.results[start]

  @builtins.property
  def sizes(self):
    start, pg = _ods_equally_sized_accessor(operation.results, 2, 2, 0)
    return self.operation.results[start:start + pg]

  @builtins.property
  def strides(self):
    start, pg = _ods_equally_sized_accessor(operation.results, 2, 2, 1)
    return self.operation.results[start:start + pg]

def extract_strided_metadata(source, *, loc=None, ip=None) -> _Sequence[_ods_ir.OpResult]:
  return _get_op_result_or_op_results(ExtractStridedMetadataOp(source=source, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class GetGlobalOp(_ods_ir.OpView):
  OPERATION_NAME = "memref.get_global"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, name, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["name"] = (name if (
    issubclass(type(name), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
      _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(name, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def name(self):
    return self.operation.attributes["name"]

  @name.setter
  def name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["name"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def get_global(result, name, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return _get_op_result_or_op_results(GetGlobalOp(result=result, name=name, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class GlobalOp(_ods_ir.OpView):
  OPERATION_NAME = "memref.global"

  _ODS_REGIONS = (0, True)

  def __init__(self, sym_name, type_, *, sym_visibility=None, initial_value=None, constant=None, alignment=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    issubclass(type(sym_name), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    if sym_visibility is not None: attributes["sym_visibility"] = (sym_visibility if (
        issubclass(type(sym_visibility), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(sym_visibility, context=_ods_context))
    attributes["type"] = (type_ if (
    issubclass(type(type_), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('MemRefTypeAttr')) else
      _ods_ir.AttrBuilder.get('MemRefTypeAttr')(type_, context=_ods_context))
    if initial_value is not None: attributes["initial_value"] = (initial_value if (
        issubclass(type(initial_value), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('AnyAttr')) else
          _ods_ir.AttrBuilder.get('AnyAttr')(initial_value, context=_ods_context))
    if bool(constant): attributes["constant"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if alignment is not None: attributes["alignment"] = (alignment if (
        issubclass(type(alignment), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(alignment, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def sym_visibility(self):
    if "sym_visibility" not in self.operation.attributes:
      return None
    return self.operation.attributes["sym_visibility"]

  @sym_visibility.setter
  def sym_visibility(self, value):
    if value is not None:
      self.operation.attributes["sym_visibility"] = value
    elif "sym_visibility" in self.operation.attributes:
      del self.operation.attributes["sym_visibility"]

  @sym_visibility.deleter
  def sym_visibility(self):
    del self.operation.attributes["sym_visibility"]

  @builtins.property
  def type_(self):
    return self.operation.attributes["type"]

  @type_.setter
  def type_(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["type"] = value

  @builtins.property
  def initial_value(self):
    if "initial_value" not in self.operation.attributes:
      return None
    return self.operation.attributes["initial_value"]

  @initial_value.setter
  def initial_value(self, value):
    if value is not None:
      self.operation.attributes["initial_value"] = value
    elif "initial_value" in self.operation.attributes:
      del self.operation.attributes["initial_value"]

  @initial_value.deleter
  def initial_value(self):
    del self.operation.attributes["initial_value"]

  @builtins.property
  def constant(self):
    return "constant" in self.operation.attributes

  @constant.setter
  def constant(self, value):
    if bool(value):
      self.operation.attributes["constant"] = _ods_ir.UnitAttr.get()
    elif "constant" in self.operation.attributes:
      del self.operation.attributes["constant"]

  @constant.deleter
  def constant(self):
    del self.operation.attributes["constant"]

  @builtins.property
  def alignment(self):
    if "alignment" not in self.operation.attributes:
      return None
    return self.operation.attributes["alignment"]

  @alignment.setter
  def alignment(self, value):
    if value is not None:
      self.operation.attributes["alignment"] = value
    elif "alignment" in self.operation.attributes:
      del self.operation.attributes["alignment"]

  @alignment.deleter
  def alignment(self):
    del self.operation.attributes["alignment"]

def global_(sym_name, type_, *, sym_visibility=None, initial_value=None, constant=None, alignment=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(GlobalOp(sym_name=sym_name, type_=type_, sym_visibility=sym_visibility, initial_value=initial_value, constant=constant, alignment=alignment, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class MemorySpaceCastOp(_ods_ir.OpView):
  OPERATION_NAME = "memref.memory_space_cast"

  _ODS_REGIONS = (0, True)

  def __init__(self, dest, source, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(dest)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def dest(self):
    return self.operation.results[0]

def memory_space_cast(dest, source, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return _get_op_result_or_op_results(MemorySpaceCastOp(dest=dest, source=source, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class PrefetchOp(_ods_ir.OpView):
  OPERATION_NAME = "memref.prefetch"

  _ODS_REGIONS = (0, True)

  def __init__(self, memref, indices, isWrite, localityHint, isDataCache, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(memref))
    operands.extend(_get_op_results_or_values(indices))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["isWrite"] = (isWrite if (
    issubclass(type(isWrite), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('BoolAttr')) else
      _ods_ir.AttrBuilder.get('BoolAttr')(isWrite, context=_ods_context))
    attributes["localityHint"] = (localityHint if (
    issubclass(type(localityHint), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(localityHint, context=_ods_context))
    attributes["isDataCache"] = (isDataCache if (
    issubclass(type(isDataCache), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('BoolAttr')) else
      _ods_ir.AttrBuilder.get('BoolAttr')(isDataCache, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def memref(self):
    return self.operation.operands[0]

  @builtins.property
  def indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def isWrite(self):
    return self.operation.attributes["isWrite"]

  @isWrite.setter
  def isWrite(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["isWrite"] = value

  @builtins.property
  def localityHint(self):
    return self.operation.attributes["localityHint"]

  @localityHint.setter
  def localityHint(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["localityHint"] = value

  @builtins.property
  def isDataCache(self):
    return self.operation.attributes["isDataCache"]

  @isDataCache.setter
  def isDataCache(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["isDataCache"] = value

def prefetch(memref, indices, is_write, locality_hint, is_data_cache, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(PrefetchOp(memref=memref, indices=indices, isWrite=is_write, localityHint=locality_hint, isDataCache=is_data_cache, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class RankOp(_ods_ir.OpView):
  OPERATION_NAME = "memref.rank"

  _ODS_REGIONS = (0, True)

  def __init__(self, memref, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(memref))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def memref(self):
    return self.operation.operands[0]

def rank(memref, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return _get_op_result_or_op_results(RankOp(memref=memref, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ReallocOp(_ods_ir.OpView):
  OPERATION_NAME = "memref.realloc"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, source, *, dynamicResultSize=None, alignment=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    if dynamicResultSize is not None: operands.append(_get_op_result_or_value(dynamicResultSize))
    _ods_context = _ods_get_default_loc_context(loc)
    if alignment is not None: attributes["alignment"] = (alignment if (
        issubclass(type(alignment), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I64Attr')) else
          _ods_ir.AttrBuilder.get('I64Attr')(alignment, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def dynamicResultSize(self):
    return None if len(self.operation.operands) < 2 else self.operation.operands[1]

  @builtins.property
  def alignment(self):
    if "alignment" not in self.operation.attributes:
      return None
    return self.operation.attributes["alignment"]

  @alignment.setter
  def alignment(self, value):
    if value is not None:
      self.operation.attributes["alignment"] = value
    elif "alignment" in self.operation.attributes:
      del self.operation.attributes["alignment"]

  @alignment.deleter
  def alignment(self):
    del self.operation.attributes["alignment"]

def realloc(result, source, *, dynamic_result_size=None, alignment=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return _get_op_result_or_op_results(ReallocOp(result=result, source=source, dynamicResultSize=dynamic_result_size, alignment=alignment, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ReinterpretCastOp(_ods_ir.OpView):
  OPERATION_NAME = "memref.reinterpret_cast"

  _ODS_OPERAND_SEGMENTS = [1,-1,-1,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, result, source, offsets, sizes, strides, static_offsets, static_sizes, static_strides, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_results_or_values(offsets))
    operands.append(_get_op_results_or_values(sizes))
    operands.append(_get_op_results_or_values(strides))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["static_offsets"] = (static_offsets if (
    issubclass(type(static_offsets), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(static_offsets, context=_ods_context))
    attributes["static_sizes"] = (static_sizes if (
    issubclass(type(static_sizes), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(static_sizes, context=_ods_context))
    attributes["static_strides"] = (static_strides if (
    issubclass(type(static_strides), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(static_strides, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def offsets(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def sizes(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def strides(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range

  @builtins.property
  def static_offsets(self):
    return self.operation.attributes["static_offsets"]

  @static_offsets.setter
  def static_offsets(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["static_offsets"] = value

  @builtins.property
  def static_sizes(self):
    return self.operation.attributes["static_sizes"]

  @static_sizes.setter
  def static_sizes(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["static_sizes"] = value

  @builtins.property
  def static_strides(self):
    return self.operation.attributes["static_strides"]

  @static_strides.setter
  def static_strides(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["static_strides"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def reinterpret_cast(result, source, offsets, sizes, strides, static_offsets, static_sizes, static_strides, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return _get_op_result_or_op_results(ReinterpretCastOp(result=result, source=source, offsets=offsets, sizes=sizes, strides=strides, static_offsets=static_offsets, static_sizes=static_sizes, static_strides=static_strides, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ReshapeOp(_ods_ir.OpView):
  OPERATION_NAME = "memref.reshape"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, source, shape, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_result_or_value(shape))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def shape(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def reshape(result, source, shape, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return _get_op_result_or_op_results(ReshapeOp(result=result, source=source, shape=shape, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class StoreOp(_ods_ir.OpView):
  OPERATION_NAME = "memref.store"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, memref, indices, *, nontemporal=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(value))
    operands.append(_get_op_result_or_value(memref))
    operands.extend(_get_op_results_or_values(indices))
    _ods_context = _ods_get_default_loc_context(loc)
    if nontemporal is not None: attributes["nontemporal"] = (nontemporal if (
        issubclass(type(nontemporal), _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(nontemporal, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def value(self):
    return self.operation.operands[0]

  @builtins.property
  def memref(self):
    return self.operation.operands[1]

  @builtins.property
  def indices(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[2:2 + _ods_variadic_group_length]

  @builtins.property
  def nontemporal(self):
    if "nontemporal" not in self.operation.attributes:
      return None
    return self.operation.attributes["nontemporal"]

  @nontemporal.setter
  def nontemporal(self, value):
    if value is not None:
      self.operation.attributes["nontemporal"] = value
    elif "nontemporal" in self.operation.attributes:
      del self.operation.attributes["nontemporal"]

  @nontemporal.deleter
  def nontemporal(self):
    del self.operation.attributes["nontemporal"]

def store(value, memref, indices, *, nontemporal=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(StoreOp(value=value, memref=memref, indices=indices, nontemporal=nontemporal, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class TransposeOp(_ods_ir.OpView):
  OPERATION_NAME = "memref.transpose"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, in_, permutation, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(in_))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["permutation"] = (permutation if (
    issubclass(type(permutation), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('AffineMapAttr')) else
      _ods_ir.AttrBuilder.get('AffineMapAttr')(permutation, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def in_(self):
    return self.operation.operands[0]

  @builtins.property
  def permutation(self):
    return self.operation.attributes["permutation"]

  @permutation.setter
  def permutation(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["permutation"] = value

def transpose(result, in_, permutation, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return _get_op_result_or_op_results(TransposeOp(result=result, in_=in_, permutation=permutation, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class ViewOp(_ods_ir.OpView):
  OPERATION_NAME = "memref.view"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, source, byte_shift, sizes, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_result_or_value(byte_shift))
    operands.extend(_get_op_results_or_values(sizes))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def byte_shift(self):
    return self.operation.operands[1]

  @builtins.property
  def sizes(self):
    _ods_variadic_group_length = len(self.operation.operands) - 3 + 1
    return self.operation.operands[2:2 + _ods_variadic_group_length]

def view(result, source, byte_shift, sizes, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return _get_op_result_or_op_results(ViewOp(result=result, source=source, byte_shift=byte_shift, sizes=sizes, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class SubViewOp(_ods_ir.OpView):
  OPERATION_NAME = "memref.subview"

  _ODS_OPERAND_SEGMENTS = [1,-1,-1,-1,]

  _ODS_REGIONS = (0, True)

  def __init__(self, result, source, offsets, sizes, strides, static_offsets, static_sizes, static_strides, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(source))
    operands.append(_get_op_results_or_values(offsets))
    operands.append(_get_op_results_or_values(sizes))
    operands.append(_get_op_results_or_values(strides))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["static_offsets"] = (static_offsets if (
    issubclass(type(static_offsets), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(static_offsets, context=_ods_context))
    attributes["static_sizes"] = (static_sizes if (
    issubclass(type(static_sizes), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(static_sizes, context=_ods_context))
    attributes["static_strides"] = (static_strides if (
    issubclass(type(static_strides), _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(static_strides, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def source(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def offsets(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range

  @builtins.property
  def sizes(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def strides(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range

  @builtins.property
  def static_offsets(self):
    return self.operation.attributes["static_offsets"]

  @static_offsets.setter
  def static_offsets(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["static_offsets"] = value

  @builtins.property
  def static_sizes(self):
    return self.operation.attributes["static_sizes"]

  @static_sizes.setter
  def static_sizes(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["static_sizes"] = value

  @builtins.property
  def static_strides(self):
    return self.operation.attributes["static_strides"]

  @static_strides.setter
  def static_strides(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["static_strides"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def subview(result, source, offsets, sizes, strides, static_offsets, static_sizes, static_strides, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return _get_op_result_or_op_results(SubViewOp(result=result, source=source, offsets=offsets, sizes=sizes, strides=strides, static_offsets=static_offsets, static_sizes=static_sizes, static_strides=static_strides, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
@_ods_extend_opview_class(_ods_ext_module)
class TensorStoreOp(_ods_ir.OpView):
  OPERATION_NAME = "memref.tensor_store"

  _ODS_REGIONS = (0, True)

  def __init__(self, tensor, memref, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(tensor))
    operands.append(_get_op_result_or_value(memref))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def tensor(self):
    return self.operation.operands[0]

  @builtins.property
  def memref(self):
    return self.operation.operands[1]

def tensor_store(tensor, memref, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(TensorStoreOp(tensor=tensor, memref=memref, loc=loc, ip=ip))
