/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.rowio;

import com.datapps.linkoopdb.jdbc.HsqlDateTime;
import com.datapps.linkoopdb.jdbc.rowio.RowOutputBinary;
import com.datapps.linkoopdb.jdbc.types.TimeData;
import com.datapps.linkoopdb.jdbc.types.TimestampData;
import com.datapps.linkoopdb.jdbc.types.Type;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class RowOutputBinary180
extends RowOutputBinary {
    Calendar tempCalDefault = new GregorianCalendar();

    public RowOutputBinary180(int initialSize, int scale) {
        super(initialSize, scale);
    }

    @Override
    protected void writeDate(TimestampData o, Type type) {
        long millis = o.getSeconds() * 1000L;
        millis = HsqlDateTime.convertMillisToCalendar(this.tempCalDefault, millis);
        this.writeLong(millis);
    }

    @Override
    protected void writeTime(TimeData o, Type type) {
        if (type.typeCode == 92) {
            long millis = (long)o.getSeconds() * 1000L;
            millis = HsqlDateTime.convertMillisToCalendar(this.tempCalDefault, millis);
            this.writeLong(millis);
        } else {
            this.writeInt(o.getSeconds());
            this.writeInt(o.getNanos());
            this.writeInt(o.getZone());
        }
    }

    @Override
    protected void writeTimestamp(TimestampData o, Type type) {
        if (type.typeCode == 93) {
            long millis = o.getSeconds() * 1000L;
            millis = HsqlDateTime.convertMillisToCalendar(this.tempCalDefault, millis);
            this.writeLong(millis);
            this.writeInt(o.getNanos());
        } else {
            this.writeLong(o.getSeconds());
            this.writeInt(o.getNanos());
            this.writeInt(o.getZone());
        }
    }
}

