from ..gen_platonic.angle_cal import angle_cal
from .cube_face_leg_reduce_coord_gen import cube_face_leg_reduce_coord_gen
from .cube_face_input_coord import cube_face_input_coord


def cube_face_write(radius: float, sigma: float,create_Solid: bool = False):
    """Writes input parameters and reaction details to a file for cube face-centered simulation.

    Args:
        radius (float): The radius of the cube face-centered structure.
        sigma (float): The sigma value used for simulation.

    Returns:
        parm.inp/cube.mol files: Inputs for NERDSS

    This function writes the input parameters and reaction details for a cube face-centered
    simulation to a file named 'parm.inp'. The function takes the radius and sigma as input
    arguments, and uses them to calculate the required input parameters and reaction details.
    The file 'parm.inp' contains input parameters such as number of iterations, time steps,
    write frequencies, box boundaries, number of molecules, and reaction details for four
    types of cubes (lg1, lg2, lg3, lg4) based on the given radius and sigma values. The
    function uses helper functions 'cube_face_input_coord', 'cube_face_leg_reduce_coord_gen',
    and 'angle_cal' from other modules to calculate the required input parameters.
    """
    if create_Solid == True:
        COM, lg1, lg2, lg3, lg4, n = cube_face_input_coord(radius, sigma)
        coord = cube_face_leg_reduce_coord_gen(radius, sigma)
        theta1, theta2, phi1, phi2, omega = angle_cal(
        coord[0][0], coord[0][3], coord[4][0], coord[4][1])

        output_reactions_dict :dict = {
                "n": n,
                "coord": coord,
                "theta1": theta1,
                "theta2": theta2,
                "phi1": phi1,
                "phi2": phi2,
                "omega": omega
        }
        output_mol_dict: dict = {
                "COM": COM,
                "lg1": lg1,
                "lg2": lg2,
                "lg3": lg3,
                "lg4": lg4,
        }
        return output_reactions_dict, output_mol_dict
    else:
        COM, lg1, lg2, lg3, lg4, n = cube_face_input_coord(radius, sigma)
        coord = cube_face_leg_reduce_coord_gen(radius, sigma)
        theta1, theta2, phi1, phi2, omega = angle_cal(
                coord[0][0], coord[0][1], coord[1][0], coord[1][1])

        f = open('parm.inp', 'w')
        f.write(' # Input file (cube face-centered)\n\n')
        f.write('start parameters\n')
        f.write('    nItr = 10000000 #iterations\n')
        f.write('    timeStep = 0.1\n')
        f.write('    timeWrite = 10000\n')
        f.write('    pdbWrite = 10000\n')
        f.write('    trajWrite = 10000\n')
        f.write('    restartWrite = 50000\n')
        f.write('    checkPoint = 1000000\n')
        f.write('    overlapSepLimit = 7.0\n')
        f.write('end parameters\n\n')
        f.write('start boundaries\n')
        f.write('    WaterBox = [500,500,500]\n')
        f.write('end boundaries\n\n')
        f.write('start molecules\n')
        f.write('    cube : 200\n')
        f.write('end molecules\n\n')
        f.write('start reactions\n')
        f.write('    cube(lg1) + cube(lg1) <-> cube(lg1!1).cube(lg1!1)\n')
        f.write('    onRate3Dka = 2\n')
        f.write('    offRatekb = 2\n')
        f.write('    norm1 = [' + str(n[0]) + ', ' +
                str(n[1]) + ', ' + str(n[2]) + ']\n')
        f.write('    norm2 = [' + str(n[0]) + ', ' +
                str(n[1]) + ', ' + str(n[2]) + ']\n')
        f.write('    sigma = ' + str(float(sigma)) + '\n')
        f.write('    assocAngles = [' + str(theta1) + ', ' + str(theta2) +
                ', ' + str(phi1) + ', ' + str(phi2) + ', ' + str(omega) + ']\n')
        f.write('    observeLabel = leg\n')
        f.write('    bindRadSameCom = 5.0\n')
        f.write('\n')
        f.write('    cube(lg2) + cube(lg2) <-> cube(lg2!1).cube(lg2!1)\n')
        f.write('    onRate3Dka = 2\n')
        f.write('    offRatekb = 2\n')
        f.write('    norm1 = [' + str(n[0]) + ', ' +
                str(n[1]) + ', ' + str(n[2]) + ']\n')
        f.write('    norm2 = [' + str(n[0]) + ', ' +
                str(n[1]) + ', ' + str(n[2]) + ']\n')
        f.write('    sigma = ' + str(float(sigma)) + '\n')
        f.write('    assocAngles = [' + str(theta1) + ', ' + str(theta2) +
                ', ' + str(phi1) + ', ' + str(phi2) + ', ' + str(omega) + ']\n')
        f.write('    observeLabel = leg\n')
        f.write('    bindRadSameCom = 5.0\n')
        f.write('\n')
        f.write('    cube(lg3) + cube(lg3) <-> cube(lg3!1).cube(lg3!1)\n')
        f.write('    onRate3Dka = 2\n')
        f.write('    offRatekb = 2\n')
        f.write('    norm1 = [' + str(n[0]) + ', ' +
                str(n[1]) + ', ' + str(n[2]) + ']\n')
        f.write('    norm2 = [' + str(n[0]) + ', ' +
                str(n[1]) + ', ' + str(n[2]) + ']\n')
        f.write('    sigma = ' + str(float(sigma)) + '\n')
        f.write('    assocAngles = [' + str(theta1) + ', ' + str(theta2) +
                ', ' + str(phi1) + ', ' + str(phi2) + ', ' + str(omega) + ']\n')
        f.write('    observeLabel = leg\n')
        f.write('    bindRadSameCom = 5.0\n')
        f.write('\n')
        f.write('    cube(lg4) + cube(lg4) <-> cube(lg4!1).cube(lg4!1)\n')
        f.write('    onRate3Dka = 2\n')
        f.write('    offRatekb = 2\n')
        f.write('    norm1 = [' + str(n[0]) + ', ' +
                str(n[1]) + ', ' + str(n[2]) + ']\n')
        f.write('    norm2 = [' + str(n[0]) + ', ' +
                str(n[1]) + ', ' + str(n[2]) + ']\n')
        f.write('    sigma = ' + str(float(sigma)) + '\n')
        f.write('    assocAngles = [' + str(theta1) + ', ' + str(theta2) +
                ', ' + str(phi1) + ', ' + str(phi2) + ', ' + str(omega) + ']\n')
        f.write('    observeLabel = leg\n')
        f.write('    bindRadSameCom = 5.0\n')
        f.write('\n')
        f.write('    cube(lg1) + cube(lg2) <-> cube(lg1!1).cube(lg2!1)\n')
        f.write('    onRate3Dka = 4\n')
        f.write('    offRatekb = 2\n')
        f.write('    norm1 = [' + str(n[0]) + ', ' +
                str(n[1]) + ', ' + str(n[2]) + ']\n')
        f.write('    norm2 = [' + str(n[0]) + ', ' +
                str(n[1]) + ', ' + str(n[2]) + ']\n')
        f.write('    sigma = ' + str(float(sigma)) + '\n')
        f.write('    assocAngles = [' + str(theta1) + ', ' + str(theta2) +
                ', ' + str(phi1) + ', ' + str(phi2) + ', ' + str(omega) + ']\n')
        f.write('    observeLabel = leg\n')
        f.write('    bindRadSameCom = 5.0\n')
        f.write('\n')
        f.write('    cube(lg1) + cube(lg3) <-> cube(lg1!1).cube(lg3!1)\n')
        f.write('    onRate3Dka = 4\n')
        f.write('    offRatekb = 2\n')
        f.write('    norm1 = [' + str(n[0]) + ', ' +
                str(n[1]) + ', ' + str(n[2]) + ']\n')
        f.write('    norm2 = [' + str(n[0]) + ', ' +
                str(n[1]) + ', ' + str(n[2]) + ']\n')
        f.write('    sigma = ' + str(float(sigma)) + '\n')
        f.write('    assocAngles = [' + str(theta1) + ', ' + str(theta2) +
                ', ' + str(phi1) + ', ' + str(phi2) + ', ' + str(omega) + ']\n')
        f.write('    observeLabel = leg\n')
        f.write('    bindRadSameCom = 5.0\n')
        f.write('\n')
        f.write('    cube(lg1) + cube(lg4) <-> cube(lg1!1).cube(lg4!1)\n')
        f.write('    onRate3Dka = 4\n')
        f.write('    offRatekb = 2\n')
        f.write('    norm1 = [' + str(n[0]) + ', ' +
                str(n[1]) + ', ' + str(n[2]) + ']\n')
        f.write('    norm2 = [' + str(n[0]) + ', ' +
                str(n[1]) + ', ' + str(n[2]) + ']\n')
        f.write('    sigma = ' + str(float(sigma)) + '\n')
        f.write('    assocAngles = [' + str(theta1) + ', ' + str(theta2) +
                ', ' + str(phi1) + ', ' + str(phi2) + ', ' + str(omega) + ']\n')
        f.write('    observeLabel = leg\n')
        f.write('    bindRadSameCom = 5.0\n')
        f.write('\n')
        f.write('    cube(lg2) + cube(lg3) <-> cube(lg2!1).cube(lg3!1)\n')
        f.write('    onRate3Dka = 4\n')
        f.write('    offRatekb = 2\n')
        f.write('    norm1 = [' + str(n[0]) + ', ' +
                str(n[1]) + ', ' + str(n[2]) + ']\n')
        f.write('    norm2 = [' + str(n[0]) + ', ' +
                str(n[1]) + ', ' + str(n[2]) + ']\n')
        f.write('    sigma = ' + str(float(sigma)) + '\n')
        f.write('    assocAngles = [' + str(theta1) + ', ' + str(theta2) +
                ', ' + str(phi1) + ', ' + str(phi2) + ', ' + str(omega) + ']\n')
        f.write('    observeLabel = leg\n')
        f.write('    bindRadSameCom = 5.0\n')
        f.write('\n')
        f.write('    cube(lg2) + cube(lg4) <-> cube(lg2!1).cube(lg4!1)\n')
        f.write('    onRate3Dka = 4\n')
        f.write('    offRatekb = 2\n')
        f.write('    norm1 = [' + str(n[0]) + ', ' +
                str(n[1]) + ', ' + str(n[2]) + ']\n')
        f.write('    norm2 = [' + str(n[0]) + ', ' +
                str(n[1]) + ', ' + str(n[2]) + ']\n')
        f.write('    sigma = ' + str(float(sigma)) + '\n')
        f.write('    assocAngles = [' + str(theta1) + ', ' + str(theta2) +
                ', ' + str(phi1) + ', ' + str(phi2) + ', ' + str(omega) + ']\n')
        f.write('    observeLabel = leg\n')
        f.write('    bindRadSameCom = 5.0\n')
        f.write('\n')
        f.write('    cube(lg3) + cube(lg4) <-> cube(lg3!1).cube(lg4!1)\n')
        f.write('    onRate3Dka = 4\n')
        f.write('    offRatekb = 2\n')
        f.write('    norm1 = [' + str(n[0]) + ', ' +
                str(n[1]) + ', ' + str(n[2]) + ']\n')
        f.write('    norm2 = [' + str(n[0]) + ', ' +
                str(n[1]) + ', ' + str(n[2]) + ']\n')
        f.write('    sigma = ' + str(float(sigma)) + '\n')
        f.write('    assocAngles = [' + str(theta1) + ', ' + str(theta2) +
                ', ' + str(phi1) + ', ' + str(phi2) + ', ' + str(omega) + ']\n')
        f.write('    observeLabel = leg\n')
        f.write('    bindRadSameCom = 5.0\n')
        f.write('\n')
        f.write('end reactions\n')

        f = open('cube.mol', 'w')
        f.write('##\n')
        f.write('# Cube (face-centered) information file.\n')
        f.write('##\n\n')
        f.write('Name = cube\n')
        f.write('checkOverlap = true\n\n')
        f.write('# translational diffusion constants\n')
        f.write('D = [13.0, 13.0, 13.0]\n\n')
        f.write('# rotational diffusion constants\n')
        f.write('Dr = [0.03, 0.03, 0.03]\n\n')
        f.write('# Coordinates\n')
        f.write('COM   ' + str(round(COM[0], 8)) + '   ' +
                str(round(COM[1], 8)) + '   ' + str(round(COM[2], 8)) + '\n')
        f.write('lg1   ' + str(round(lg1[0], 8)) + '   ' +
                str(round(lg1[1], 8)) + '   ' + str(round(lg1[2], 8)) + '\n')
        f.write('lg2   ' + str(round(lg2[0], 8)) + '   ' +
                str(round(lg2[1], 8)) + '   ' + str(round(lg2[2], 8)) + '\n')
        f.write('lg3   ' + str(round(lg3[0], 8)) + '   ' +
                str(round(lg3[1], 8)) + '   ' + str(round(lg3[2], 8)) + '\n')
        f.write('lg4   ' + str(round(lg4[0], 8)) + '   ' +
                str(round(lg4[1], 8)) + '   ' + str(round(lg4[2], 8)) + '\n')
        f.write('\n')
        f.write('# bonds\n')
        f.write('bonds = 4\n')
        f.write('com lg1\n')
        f.write('com lg2\n')
        f.write('com lg3\n')
        f.write('com lg4\n')
        f.write('\n')


# CUBE VERTEX AS COM

