/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineTimeOutException;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.cli.StreamFeeder;
import org.codehaus.plexus.util.cli.StreamPumper;

public abstract class CommandLineUtils {
    private static Map processes = Collections.synchronizedMap(new HashMap());
    private static Thread shutdownHook = new Thread("CommandlineUtil shutdown"){

        public void run() {
            if (processes != null && processes.size() > 0) {
                System.err.println("Destroying " + processes.size() + " processes");
                Iterator it2 = processes.values().iterator();
                while (it2.hasNext()) {
                    System.err.println("Destroying process..");
                    ((Process)it2.next()).destroy();
                }
                System.err.println("Destroyed " + processes.size() + " processes");
            }
        }
    };
    static /* synthetic */ Class class$java$lang$System;

    public static void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    public static void removeShutdownHook(boolean execute) {
        Runtime.getRuntime().removeShutdownHook(shutdownHook);
        if (execute) {
            shutdownHook.run();
        }
    }

    public static int executeCommandLine(Commandline cl, StreamConsumer systemOut, StreamConsumer systemErr) throws CommandLineException {
        return CommandLineUtils.executeCommandLine(cl, null, systemOut, systemErr, 0);
    }

    public static int executeCommandLine(Commandline cl, StreamConsumer systemOut, StreamConsumer systemErr, int timeoutInSeconds) throws CommandLineException {
        return CommandLineUtils.executeCommandLine(cl, null, systemOut, systemErr, timeoutInSeconds);
    }

    public static int executeCommandLine(Commandline cl, InputStream systemIn, StreamConsumer systemOut, StreamConsumer systemErr) throws CommandLineException {
        return CommandLineUtils.executeCommandLine(cl, systemIn, systemOut, systemErr, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeCommandLine(Commandline cl, InputStream systemIn, StreamConsumer systemOut, StreamConsumer systemErr, int timeoutInSeconds) throws CommandLineException {
        int n;
        block26: {
            if (cl == null) {
                throw new IllegalArgumentException("cl cannot be null.");
            }
            Process p3 = cl.execute();
            processes.put(new Long(cl.getPid()), p3);
            StreamFeeder inputFeeder = null;
            if (systemIn != null) {
                inputFeeder = new StreamFeeder(systemIn, p3.getOutputStream());
            }
            StreamPumper outputPumper = new StreamPumper(p3.getInputStream(), systemOut);
            StreamPumper errorPumper = new StreamPumper(p3.getErrorStream(), systemErr);
            if (inputFeeder != null) {
                inputFeeder.start();
            }
            outputPumper.start();
            errorPumper.start();
            try {
                int returnValue;
                if (timeoutInSeconds <= 0) {
                    returnValue = p3.waitFor();
                } else {
                    long now = System.currentTimeMillis();
                    long timeoutInMillis = 1000L * (long)timeoutInSeconds;
                    long finish2 = now + timeoutInMillis;
                    while (CommandLineUtils.isAlive(p3) && System.currentTimeMillis() < finish2) {
                        Thread.sleep(10L);
                    }
                    if (CommandLineUtils.isAlive(p3)) {
                        throw new InterruptedException("Process timeout out after " + timeoutInSeconds + " seconds");
                    }
                    returnValue = p3.exitValue();
                }
                if (inputFeeder != null) {
                    StreamFeeder streamFeeder = inputFeeder;
                    synchronized (streamFeeder) {
                        while (!inputFeeder.isDone()) {
                            inputFeeder.wait();
                        }
                    }
                }
                StreamPumper streamPumper = outputPumper;
                synchronized (streamPumper) {
                    while (!outputPumper.isDone()) {
                        outputPumper.wait();
                    }
                }
                streamPumper = errorPumper;
                synchronized (streamPumper) {
                    while (!errorPumper.isDone()) {
                        errorPumper.wait();
                    }
                }
                processes.remove(new Long(cl.getPid()));
                n = returnValue;
                Object var20_20 = null;
                if (inputFeeder != null) {
                    inputFeeder.close();
                }
                outputPumper.close();
                errorPumper.close();
                p3.destroy();
                if (processes.get(new Long(cl.getPid())) == null) break block26;
                processes.remove(new Long(cl.getPid()));
            }
            catch (InterruptedException ex) {
                try {
                    CommandLineUtils.killProcess(cl.getPid());
                    throw new CommandLineTimeOutException("Error while executing external command, process killed.", ex);
                }
                catch (Throwable throwable) {
                    block27: {
                        Object var20_21 = null;
                        if (inputFeeder != null) {
                            inputFeeder.close();
                        }
                        outputPumper.close();
                        errorPumper.close();
                        p3.destroy();
                        if (processes.get(new Long(cl.getPid())) == null) break block27;
                        processes.remove(new Long(cl.getPid()));
                    }
                    throw throwable;
                }
            }
        }
        return n;
    }

    public static Properties getSystemEnvVars() throws IOException {
        return CommandLineUtils.getSystemEnvVars(!Os.isFamily("windows"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getSystemEnvVars(boolean caseSensitive) throws IOException {
        Method getenvMethod = CommandLineUtils.getEnvMethod();
        if (getenvMethod != null) {
            try {
                return CommandLineUtils.getEnvFromSystem(getenvMethod, caseSensitive);
            }
            catch (IllegalAccessException e) {
                throw new IOException(e.getMessage());
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e.getMessage());
            }
            catch (InvocationTargetException e) {
                throw new IOException(e.getMessage());
            }
        }
        Process p3 = null;
        try {
            String line;
            Properties envVars = new Properties();
            Runtime r = Runtime.getRuntime();
            boolean overriddenEncoding = false;
            if (Os.isFamily("windows")) {
                if (Os.isFamily("win9x")) {
                    p3 = r.exec("command.com /c set");
                } else {
                    overriddenEncoding = true;
                    p3 = r.exec("cmd.exe /U /c set");
                }
            } else {
                p3 = r.exec("env");
            }
            InputStreamReader reader = overriddenEncoding ? new InputStreamReader(p3.getInputStream(), "UTF-16LE") : new InputStreamReader(p3.getInputStream());
            BufferedReader br = new BufferedReader(reader);
            String lastKey = null;
            String lastVal = null;
            while ((line = br.readLine()) != null) {
                int idx = line.indexOf(61);
                if (idx > 0) {
                    lastKey = line.substring(0, idx);
                    if (!caseSensitive) {
                        lastKey = lastKey.toUpperCase(Locale.ENGLISH);
                    }
                    lastVal = line.substring(idx + 1);
                    envVars.setProperty(lastKey, lastVal);
                    continue;
                }
                if (lastKey == null) continue;
                lastVal = lastVal + "\n" + line;
                envVars.setProperty(lastKey, lastVal);
            }
            Properties properties = envVars;
            return properties;
        }
        finally {
            if (p3 != null) {
                p3.destroy();
            }
        }
    }

    public static void killProcess(long pid) {
        Process p3 = (Process)processes.get(new Long(pid));
        if (p3 != null) {
            p3.destroy();
            System.out.println("Process " + pid + " is killed.");
            processes.remove(new Long(pid));
        } else {
            System.out.println("don't exist.");
        }
    }

    public static boolean isAlive(long pid) {
        return processes.get(new Long(pid)) != null;
    }

    public static boolean isAlive(Process p3) {
        if (p3 == null) {
            return false;
        }
        try {
            p3.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    public static String[] translateCommandline(String toProcess) throws Exception {
        if (toProcess == null || toProcess.length() == 0) {
            return new String[0];
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(toProcess, "\"' ", true);
        Vector<String> v = new Vector<String>();
        StringBuffer current = new StringBuffer();
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                state = 1;
                continue;
            }
            if ("\"".equals(nextTok)) {
                state = 2;
                continue;
            }
            if (" ".equals(nextTok)) {
                if (current.length() == 0) continue;
                v.addElement(current.toString());
                current.setLength(0);
                continue;
            }
            current.append(nextTok);
        }
        if (current.length() != 0) {
            v.addElement(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new CommandLineException("unbalanced quotes in " + toProcess);
        }
        Object[] args2 = new String[v.size()];
        v.copyInto(args2);
        return args2;
    }

    public static String quote(String argument2) throws CommandLineException {
        return CommandLineUtils.quote(argument2, false, false, true);
    }

    public static String quote(String argument2, boolean wrapExistingQuotes) throws CommandLineException {
        return CommandLineUtils.quote(argument2, false, false, wrapExistingQuotes);
    }

    public static String quote(String argument2, boolean escapeSingleQuotes, boolean escapeDoubleQuotes, boolean wrapExistingQuotes) throws CommandLineException {
        if (argument2.indexOf("\"") > -1) {
            if (argument2.indexOf("'") > -1) {
                throw new CommandLineException("Can't handle single and double quotes in same argument");
            }
            if (escapeSingleQuotes) {
                return "\\'" + argument2 + "\\'";
            }
            if (wrapExistingQuotes) {
                return '\'' + argument2 + '\'';
            }
        } else if (argument2.indexOf("'") > -1) {
            if (escapeDoubleQuotes) {
                return "\\\"" + argument2 + "\\\"";
            }
            if (wrapExistingQuotes) {
                return '\"' + argument2 + '\"';
            }
        } else if (argument2.indexOf(" ") > -1) {
            if (escapeDoubleQuotes) {
                return "\\\"" + argument2 + "\\\"";
            }
            return '\"' + argument2 + '\"';
        }
        return argument2;
    }

    public static String toString(String[] line) {
        if (line == null || line.length == 0) {
            return "";
        }
        StringBuffer result2 = new StringBuffer();
        for (int i = 0; i < line.length; ++i) {
            if (i > 0) {
                result2.append(' ');
            }
            try {
                result2.append(StringUtils.quoteAndEscape(line[i], '\"'));
                continue;
            }
            catch (Exception e) {
                System.err.println("Error quoting argument: " + e.getMessage());
            }
        }
        return result2.toString();
    }

    private static Method getEnvMethod() {
        try {
            return (class$java$lang$System == null ? (class$java$lang$System = CommandLineUtils.class$("java.lang.System")) : class$java$lang$System).getMethod("getenv", null);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    private static Properties getEnvFromSystem(Method method, boolean caseSensitive) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Properties envVars = new Properties();
        Map envs = (Map)method.invoke(null, null);
        Iterator iterator2 = envs.keySet().iterator();
        while (iterator2.hasNext()) {
            String key = (String)iterator2.next();
            String value2 = (String)envs.get(key);
            if (!caseSensitive) {
                key = key.toUpperCase(Locale.ENGLISH);
            }
            envVars.put(key, value2);
        }
        return envVars;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        shutdownHook.setContextClassLoader(null);
        CommandLineUtils.addShutdownHook();
    }

    public static class StringStreamConsumer
    implements StreamConsumer {
        private StringBuffer string = new StringBuffer();
        private String ls = System.getProperty("line.separator");

        public void consumeLine(String line) {
            this.string.append(line).append(this.ls);
        }

        public String getOutput() {
            return this.string.toString();
        }
    }
}

