/*
 * Decompiled with CFR 0.152.
 */
package parallel;

import datastructures.stdcollections.ListsKt;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import parallel.Parallel;
import parallel.ParallelKt;
import parallel.RPCJob;
import parallel.Sem;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0017\u001a\u00020\tH\u0016J\u001a\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001b"}, d2={"Lparallel/RPCJob;", "T", "Lparallel/Parallel;", "timeout", "Lkotlin/time/Duration;", "job", "Lkotlin/Function0;", "(Lkotlin/time/Duration;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "completeFlag", "", "deps", "", "getDeps", "()Ljava/util/List;", "future", "Ljava/util/concurrent/CompletableFuture;", "getFuture", "()Ljava/util/concurrent/CompletableFuture;", "setFuture", "(Ljava/util/concurrent/CompletableFuture;)V", "result", "getResult", "()Ljava/lang/Object;", "done", "schedule", "ioPool", "Ljava/util/concurrent/ExecutorService;", "GeneralUtils"})
public final class RPCJob<T>
extends Parallel<T> {
    @Nullable
    private final Duration timeout;
    @NotNull
    private final Function0<T> job;
    public volatile CompletableFuture<T> future;
    private boolean completeFlag;

    private RPCJob(Duration timeout, Function0<? extends T> job) {
        Intrinsics.checkNotNullParameter(job, "job");
        super(null);
        this.timeout = timeout;
        this.job = job;
    }

    @Override
    @NotNull
    public List<Parallel<?>> getDeps() {
        return ListsKt.listOf();
    }

    @NotNull
    public final CompletableFuture<T> getFuture() {
        CompletableFuture<T> completableFuture = this.future;
        if (completableFuture != null) {
            return completableFuture;
        }
        Intrinsics.throwUninitializedPropertyAccessException("future");
        return null;
    }

    public final void setFuture(@NotNull CompletableFuture<T> completableFuture) {
        Intrinsics.checkNotNullParameter(completableFuture, "<set-?>");
        this.future = completableFuture;
    }

    @Override
    public T getResult() {
        if (!this.getFuture().isDone()) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return this.getFuture().get();
    }

    @Override
    public boolean done() {
        return this.future != null && this.getFuture().isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<Parallel<?>> schedule(@NotNull ExecutorService ioPool) {
        Intrinsics.checkNotNullParameter(ioPool, "ioPool");
        ParallelKt.access$getLogger$p().debug(schedule.1.INSTANCE);
        Sem semaphore = new Sem(ParallelKt.access$getSemaphoreId$p().incrementAndGet());
        CompletableFuture<Object> completableFuture = CompletableFuture.supplyAsync(() -> RPCJob.schedule$lambda$1(this, semaphore), ioPool);
        Intrinsics.checkNotNullExpressionValue(completableFuture, "supplyAsync(...)");
        this.setFuture(completableFuture);
        Sem sem = semaphore;
        synchronized (sem) {
            boolean bl = false;
            long startTimeMillis = System.currentTimeMillis();
            boolean hitTimeout = false;
            while (!this.completeFlag && !hitTimeout) {
                if (this.timeout != null) {
                    long timeRemainingMillis = Duration.getInWholeMilliseconds-impl(this.timeout.unbox-impl()) - (System.currentTimeMillis() - startTimeMillis);
                    if (timeRemainingMillis < 0L) {
                        hitTimeout = true;
                        continue;
                    }
                    semaphore.wait(timeRemainingMillis);
                    continue;
                }
                semaphore.wait();
            }
            if (hitTimeout) {
                this.getFuture().cancel(true);
            }
            Unit unit = Unit.INSTANCE;
        }
        this.getFuture().get();
        return ListsKt.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object schedule$lambda$1(RPCJob this$0, Sem $semaphore) {
        Object t;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($semaphore, "$semaphore");
        ParallelKt.access$getLogger$p().debug(schedule.2.1.INSTANCE);
        try {
            t = this$0.job.invoke();
        }
        finally {
            Sem sem = $semaphore;
            synchronized (sem) {
                boolean bl = false;
                this$0.completeFlag = true;
                $semaphore.notifyAll();
                Unit unit = Unit.INSTANCE;
            }
        }
        Object r = t;
        return r;
    }

    public /* synthetic */ RPCJob(Duration timeout, Function0 job, DefaultConstructorMarker $constructor_marker) {
        this(timeout, job);
    }
}

