/*
 * Decompiled with CFR 0.152.
 */
package preprocessing;

import bridge.ContractInstanceInSDC;
import bridge.SingleDeployedContract;
import bridge.StorageLayout;
import bridge.VerificationQuery;
import bridge.VerificationQueryType;
import config.ConfigRegister;
import config.ConfigType;
import config.SharedConfig;
import config.TypecheckerConfig;
import datastructures.stdcollections.ListsKt;
import datastructures.stdcollections.SetsKt;
import disassembler.DisassembledEVMBytecode;
import java.io.File;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import log.Logger;
import log.LoggerKt;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import preprocessing.ProverInputPreprocessor;
import scene.ContractClassIdentifiers;
import scene.ContractUniverse;
import scene.ContractWithStateLinkInfo;
import scene.IContractClass;
import scene.IContractLoader;
import scene.IContractSource;
import scene.IContractWithSource;
import scene.IPerContractClassCache;
import scene.IScene;
import scene.ITACMethod;
import scene.MethodAttribute;
import scene.TrivialSceneFactory;
import spec.CVL;
import spec.CVLAstBuilder;
import spec.CVLInput;
import spec.DummyTypeResolver;
import spec.cvlast.CVLAst;
import spec.cvlast.SolidityContract;
import spec.cvlast.typechecker.CVLError;
import tac.DummyStorageInfo;
import tac.ICoreTACProgram;
import tac.IStorageInfo;
import tac.ITACSymbol;
import tac.TACStorageLayout;
import utils.CertoraException;
import utils.CollectingResult;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00060\u000b\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\b\u0010\u0011\u001a\u00020\u0006H\u0002J\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J$\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lpreprocessing/ProverInputPreprocessor;", "", "()V", "json", "Lkotlinx/serialization/json/Json;", "_main", "", "args", "", "", "astCb", "Lkotlin/Function1;", "Lspec/cvlast/CVLAst;", "([Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getCertoraVerifyFile", "Lbridge/VerificationQuery;", "filepath", "registerConfigurations", "withSpec", "Lutils/CollectingResult;", "Lspec/cvlast/typechecker/CVLError;", "verify", "withSpecAndContractBuildInformation", "Lspec/CVL;", "contractSource", "Lpreprocessing/ProverInputPreprocessor$BasicContractSource;", "BasicContractSource", "Shared"})
@SourceDebugExtension(value={"SMAP\nProverInputPreprocessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProverInputPreprocessor.kt\npreprocessing/ProverInputPreprocessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,247:1\n1789#2,3:248\n1855#2,2:251\n11065#3:253\n11400#3,3:254\n*S KotlinDebug\n*F\n+ 1 ProverInputPreprocessor.kt\npreprocessing/ProverInputPreprocessor\n*L\n169#1:248,3\n171#1:251,2\n220#1:253\n220#1:254,3\n*E\n"})
public final class ProverInputPreprocessor {
    @NotNull
    public static final ProverInputPreprocessor INSTANCE = new ProverInputPreprocessor();
    @NotNull
    private static final Json json = JsonKt.Json$default(null, json.1.INSTANCE, 1, null);

    private ProverInputPreprocessor() {
    }

    private final VerificationQuery getCertoraVerifyFile(String filepath) {
        String it2 = FilesKt.readText$default(new File(filepath), null, 1, null);
        boolean bl = false;
        return (VerificationQuery)json.decodeFromString((DeserializationStrategy)VerificationQuery.Companion.serializer(), it2);
    }

    private final CollectingResult<CVL, CVLError> withSpecAndContractBuildInformation(BasicContractSource contractSource, VerificationQuery verify) {
        IScene scene = TrivialSceneFactory.INSTANCE.getScene(contractSource);
        System.out.println((Object)("Type checking " + verify.getPrimary_contract()));
        CVLInput cVLInput = verify.toCVLInput();
        List<ContractInstanceInSDC> list = contractSource.instances();
        IContractClass iContractClass = scene.getContract(new SolidityContract(verify.getPrimary_contract()));
        Intrinsics.checkNotNull(iContractClass, "null cannot be cast to non-null type scene.IContractWithSource");
        return new CVLAstBuilder(cVLInput, list, ((IContractWithSource)((Object)iContractClass)).getSrc(), scene, null).build();
    }

    private final CollectingResult<CVLAst, CVLError> withSpec(VerificationQuery verify) {
        CollectingResult<CVLAst, CVLError> cvlAst2 = CollectingResult.Companion.bind(verify.toCVLInput().getRawCVLAst(new DummyTypeResolver(new SolidityContract(verify.getPrimary_contract()))), withSpec.cvlAst.1.INSTANCE);
        return cvlAst2;
    }

    private final void registerConfigurations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void _main(@NotNull String[] args2, @NotNull Function1<? super CVLAst, Unit> astCb) {
        Intrinsics.checkNotNullParameter(args2, "args");
        Intrinsics.checkNotNullParameter(astCb, "astCb");
        try {
            try {
                Object verify;
                CollectingResult collectingResult;
                VerificationQuery verify2;
                void $this$fold$iv;
                this.registerConfigurations();
                Iterable iterable = ConfigRegister.INSTANCE.getCLIOptions();
                Options initial$iv = new Options();
                boolean $i$f$fold = false;
                Options accumulator$iv = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    void o;
                    Option option2 = (Option)element$iv;
                    Options AllOptions = accumulator$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue(AllOptions.addOption((Option)o), "addOption(...)");
                }
                Options options = accumulator$iv;
                CommandLine cmdLineArgs = new DefaultParser(false).parse(options, args2);
                Iterable $this$forEach$iv = ConfigRegister.INSTANCE.getRegisteredConfigs();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ConfigType conf = (ConfigType)element$iv;
                    boolean bl = false;
                    if (!(conf instanceof ConfigType.CmdLine)) continue;
                    try {
                        ConfigType.CmdLine cmdLine = (ConfigType.CmdLine)conf;
                        Intrinsics.checkNotNull(cmdLineArgs);
                        cmdLine.setFromCLI(cmdLineArgs);
                    }
                    catch (Exception e) {
                        ConfigType.CmdLine cmdLine = (ConfigType.CmdLine)conf;
                        Intrinsics.checkNotNull(cmdLineArgs);
                        Option matchedOption = cmdLine.getMatchedOption(cmdLineArgs);
                        String err_msg = "Bad argument " + matchedOption + " = " + cmdLineArgs.getOptionValue(conf.getName()) + ": " + e.getMessage();
                        LoggerKt.always(Logger.Companion, err_msg, false);
                        System.exit(1);
                        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                    }
                }
                String verifyFileName = SharedConfig.INSTANCE.prependInternalDir(".certora_verify.json");
                boolean hasVerifyFile = new File(new File(verifyFileName).getAbsolutePath()).exists();
                boolean isTypeChecking = (Boolean)TypecheckerConfig.INSTANCE.getIsTypeChecking().get();
                if (isTypeChecking) {
                    String buildFileName = SharedConfig.INSTANCE.prependInternalDir(".certora_build.json");
                    boolean hasBuildFile = new File(new File(buildFileName).getAbsolutePath()).exists();
                    verify2 = this.getCertoraVerifyFile(verifyFileName);
                    BasicContractSource contractSource = new BasicContractSource(buildFileName);
                    if (verify2.getType() == VerificationQueryType.spec) {
                        if (hasBuildFile) {
                            collectingResult = this.withSpecAndContractBuildInformation(contractSource, verify2);
                        } else {
                            System.err.println("Could not find build file - type checking failed");
                            collectingResult = CollectingResult.Companion.getOk();
                        }
                    } else {
                        collectingResult = CollectingResult.Companion.getOk();
                    }
                } else if (hasVerifyFile) {
                    verify = this.getCertoraVerifyFile(verifyFileName);
                    collectingResult = ((VerificationQuery)verify).getType() != null && ((VerificationQuery)verify).getType() != VerificationQueryType.assertion ? CollectingResult.Companion.map(this.withSpec((VerificationQuery)verify), (Function1)new Function1<CVLAst, Unit>(astCb){
                        final /* synthetic */ Function1<CVLAst, Unit> $astCb;
                        {
                            this.$astCb = $astCb;
                            super(1);
                        }

                        public final void invoke(@NotNull CVLAst ast2) {
                            Intrinsics.checkNotNullParameter(ast2, "ast");
                            this.$astCb.invoke(ast2);
                        }
                    }) : (CollectingResult)CollectingResult.Companion.getOk();
                } else {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    verify = args2;
                    PrintStream printStream = System.err;
                    boolean $i$f$map = false;
                    verify2 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                    boolean $i$f$mapTo = false;
                    int n = ((void)$this$mapTo$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void it2;
                        void item$iv$iv;
                        void var17_30 = item$iv$iv = $this$mapTo$iv$iv[i];
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it2);
                    }
                    printStream.println("Bad input to CVL typechecker: " + (List)destination$iv$iv);
                    collectingResult = CollectingResult.Companion.getOk();
                }
                CollectingResult result2 = collectingResult;
                result2.resultOrExitProcess(1, _main.2.INSTANCE);
                System.exit(0);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            catch (CertoraException e) {
                System.err.println(e);
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            catch (Throwable e) {
                System.err.println(e);
                e.printStackTrace();
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
        }
        catch (Throwable throwable) {
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    public static final /* synthetic */ Json access$getJson$p() {
        return json;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u0010H\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R'\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR!\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\f\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lpreprocessing/ProverInputPreprocessor$BasicContractSource;", "Lscene/IContractSource;", "Lscene/IContractLoader;", "file", "", "(Ljava/lang/String;)V", "buildResources", "", "Lbridge/SingleDeployedContract;", "getBuildResources", "()Ljava/util/Map;", "buildResources$delegate", "Lkotlin/Lazy;", "getFile", "()Ljava/lang/String;", "instances", "", "Lbridge/ContractInstanceInSDC;", "getInstances", "()Ljava/util/List;", "instances$delegate", "aliases", "", "Ljava/math/BigInteger;", "load", "Lscene/IContractClass;", "sdc", "cache", "Lscene/IPerContractClassCache;", "Shared"})
    @SourceDebugExtension(value={"SMAP\nProverInputPreprocessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProverInputPreprocessor.kt\npreprocessing/ProverInputPreprocessor$BasicContractSource\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,247:1\n1549#2:248\n1620#2,3:249\n*S KotlinDebug\n*F\n+ 1 ProverInputPreprocessor.kt\npreprocessing/ProverInputPreprocessor$BasicContractSource\n*L\n123#1:248\n123#1:249,3\n*E\n"})
    public static final class BasicContractSource
    implements IContractSource,
    IContractLoader {
        @NotNull
        private final String file;
        @NotNull
        private final Lazy buildResources$delegate;
        @NotNull
        private final Lazy instances$delegate;

        public BasicContractSource(@NotNull String file) {
            Intrinsics.checkNotNullParameter(file, "file");
            this.file = file;
            this.buildResources$delegate = LazyKt.lazy((Function0)new Function0<Map<String, ? extends SingleDeployedContract>>(this){
                final /* synthetic */ BasicContractSource this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Map<String, SingleDeployedContract> invoke() {
                    String it2 = FilesKt.readText$default(new File(this.this$0.getFile()), null, 1, null);
                    boolean bl = false;
                    return (Map)ProverInputPreprocessor.access$getJson$p().decodeFromString((DeserializationStrategy)BuiltinSerializersKt.MapSerializer(BuiltinSerializersKt.serializer(StringCompanionObject.INSTANCE), SingleDeployedContract.Companion.serializer()), it2);
                }
            });
            this.instances$delegate = LazyKt.lazy((Function0)new Function0<List<? extends ContractInstanceInSDC>>(this){
                final /* synthetic */ BasicContractSource this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<ContractInstanceInSDC> invoke() {
                    void $this$mapTo$iv$iv;
                    Iterable $this$mapNotNullTo$iv$iv;
                    Map $this$mapNotNull$iv = BasicContractSource.access$getBuildResources(this.this$0);
                    boolean $i$f$mapNotNull = false;
                    Map map2 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Object object = $this$forEach$iv$iv$iv.entrySet().iterator();
                    while (object.hasNext()) {
                        ContractInstanceInSDC it$iv$iv;
                        Object v0;
                        block3: {
                            Map.Entry<K, V> element$iv$iv$iv;
                            Map.Entry<K, V> element$iv$iv = element$iv$iv$iv = object.next();
                            boolean bl = false;
                            Map.Entry<K, V> entry = element$iv$iv;
                            boolean bl2 = false;
                            SingleDeployedContract v = (SingleDeployedContract)entry.getValue();
                            Iterable $this$firstOrNull$iv = v.getContracts();
                            boolean $i$f$firstOrNull = false;
                            for (T element$iv : $this$firstOrNull$iv) {
                                ContractInstanceInSDC it2 = (ContractInstanceInSDC)element$iv;
                                boolean bl3 = false;
                                if (!Intrinsics.areEqual(it2.getAddress(), v.getPrimary_contract_address())) continue;
                                v0 = element$iv;
                                break block3;
                            }
                            v0 = null;
                        }
                        if ((ContractInstanceInSDC)v0 == null) continue;
                        boolean bl = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    Iterable $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    $this$mapNotNullTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void contractInstanceInSDC;
                        object = (ContractInstanceInSDC)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        boolean bl4 = contractInstanceInSDC.is_static_address();
                        Map<K, V> map3 = datastructures.stdcollections.MapsKt.mapOf();
                        collection.add(ContractInstanceInSDC.copy$default((ContractInstanceInSDC)contractInstanceInSDC, null, null, null, "", null, bl4, null, "", "", "", null, null, null, null, map3, null, null, null, null, null, null, null, null, null, null, null, null, null, 268418135, null));
                    }
                    return (List)destination$iv$iv;
                }
            });
        }

        @NotNull
        public final String getFile() {
            return this.file;
        }

        private final Map<String, SingleDeployedContract> getBuildResources() {
            Lazy lazy = this.buildResources$delegate;
            return (Map)lazy.getValue();
        }

        private final List<ContractInstanceInSDC> getInstances() {
            Lazy lazy = this.instances$delegate;
            return (List)lazy.getValue();
        }

        @Override
        @NotNull
        public IContractClass load(@NotNull ContractInstanceInSDC sdc, @NotNull IPerContractClassCache cache2) {
            Intrinsics.checkNotNullParameter(sdc, "sdc");
            Intrinsics.checkNotNullParameter(cache2, "cache");
            return new IContractClass(sdc){
                final /* synthetic */ ContractInstanceInSDC $sdc;
                {
                    this.$sdc = $sdc;
                }

                @Nullable
                public ITACMethod getConstructor() {
                    return null;
                }

                @Nullable
                public ITACMethod getMethodBySigHash(@NotNull BigInteger sig) {
                    Intrinsics.checkNotNullParameter(sig, "sig");
                    return null;
                }

                @Nullable
                public ITACMethod getMethodByUniqueAttribute(@NotNull MethodAttribute.Unique attr) {
                    Intrinsics.checkNotNullParameter(attr, "attr");
                    return null;
                }

                @NotNull
                public IStorageInfo getStorage() {
                    return DummyStorageInfo.INSTANCE;
                }

                @Nullable
                public TACStorageLayout getStorageLayout() {
                    StorageLayout storageLayout = this.$sdc.getStorageLayout();
                    return storageLayout != null ? storageLayout.toTACStorageLayout() : null;
                }

                @NotNull
                public IStorageInfo getTransientStorage() {
                    return DummyStorageInfo.INSTANCE;
                }

                @NotNull
                public Collection<ITACMethod> getDeclaredMethods() {
                    return ListsKt.listOf();
                }

                public void mapMethods(@NotNull IScene.MapSort sort, @NotNull IScene scene, @NotNull Function2<? super IScene, ? super ITACMethod, ? extends ICoreTACProgram> p3) {
                    Intrinsics.checkNotNullParameter((Object)((Object)sort), "sort");
                    Intrinsics.checkNotNullParameter(scene, "scene");
                    Intrinsics.checkNotNullParameter(p3, "p");
                }

                @NotNull
                public IContractClass fork() {
                    return this;
                }

                @NotNull
                public BigInteger getInstanceId() {
                    return this.$sdc.getAddress();
                }

                @NotNull
                public String getName() {
                    return this.$sdc.getName();
                }

                @NotNull
                public Map<BigInteger, ITACMethod> getMethods() {
                    return MapsKt.emptyMap();
                }

                @Nullable
                public ITACMethod getWholeContractMethod() {
                    return null;
                }

                @Nullable
                public ITACMethod getConstructorMethod() {
                    return null;
                }

                @Nullable
                public DisassembledEVMBytecode getBytecode() {
                    return null;
                }

                @Nullable
                public DisassembledEVMBytecode getConstructorBytecode() {
                    return null;
                }

                @NotNull
                public ContractInstanceInSDC getSrc() {
                    return this.$sdc;
                }

                @NotNull
                public ITACSymbol getAddressSym() {
                    throw new UnsupportedOperationException();
                }

                public void mapMethods(@NotNull IScene scene, @NotNull Function2<? super IScene, ? super ITACMethod, ? extends ICoreTACProgram> p3) {
                    IContractClass.DefaultImpls.mapMethods(this, scene, p3);
                }

                @NotNull
                public ContractClassIdentifiers toIdentifiers() {
                    return IContractClass.DefaultImpls.toIdentifiers(this);
                }

                @Nullable
                public ITACMethod getWholeContract() {
                    return IContractClass.DefaultImpls.getWholeContract(this);
                }

                @NotNull
                public List<ITACMethod> getMethods() {
                    return IContractClass.DefaultImpls.getMethods(this);
                }

                @NotNull
                public Collection<ITACMethod> getStandardMethods() {
                    return IContractClass.DefaultImpls.getStandardMethods(this);
                }

                public void mapMethodsInPlace(@NotNull IScene scene, @NotNull Function2<? super IScene, ? super ITACMethod, Unit> p3) {
                    IContractClass.DefaultImpls.mapMethodsInPlace(this, scene, p3);
                }

                public void mapMethodsInPlace(@NotNull IScene.MapSort sort, @NotNull IScene scene, @NotNull Function2<? super IScene, ? super ITACMethod, Unit> p3) {
                    IContractClass.DefaultImpls.mapMethodsInPlace(this, sort, scene, p3);
                }

                @NotNull
                public String getConstructorCodeName() {
                    return IContractClass.DefaultImpls.getConstructorCodeName(this);
                }

                @NotNull
                public IContractClass.ContractMemento saveState() {
                    return IContractClass.DefaultImpls.saveState(this);
                }

                public void restore(@NotNull IContractClass.ContractMemento m) {
                    IContractClass.DefaultImpls.restore(this, m);
                }

                @Nullable
                public ContractWithStateLinkInfo getContractStateLinks() {
                    return IContractClass.DefaultImpls.getContractStateLinks(this);
                }

                public boolean getInstanceIdIsStaticAddress() {
                    return IContractClass.DefaultImpls.getInstanceIdIsStaticAddress(this);
                }
            };
        }

        @Override
        @NotNull
        public List<ContractInstanceInSDC> instances() {
            return this.getInstances();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<Set<BigInteger>> aliases() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.getInstances();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                ContractInstanceInSDC contractInstanceInSDC = (ContractInstanceInSDC)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(SetsKt.setOf(it2.getAddress()));
            }
            return (List)destination$iv$iv;
        }

        @Override
        @NotNull
        public IContractClass load(@NotNull ContractInstanceInSDC sdc) {
            return IContractLoader.DefaultImpls.load(this, sdc);
        }

        @Override
        @NotNull
        public ContractUniverse contractUniverse() {
            return IContractSource.DefaultImpls.contractUniverse(this);
        }

        public static final /* synthetic */ Map access$getBuildResources(BasicContractSource $this) {
            return $this.getBuildResources();
        }
    }
}

