/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast.parser;

import com.certora.evmverifier.cvl.HookType;
import com.certora.evmverifier.cvl.NamedVMParam;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spec.TypeResolver;
import spec.cvlast.Address;
import spec.cvlast.All_sload;
import spec.cvlast.All_sstore;
import spec.cvlast.All_tload;
import spec.cvlast.All_tstore;
import spec.cvlast.Balance;
import spec.cvlast.Basefee;
import spec.cvlast.Blobbasefee;
import spec.cvlast.Blobhash;
import spec.cvlast.Blockhash;
import spec.cvlast.CVLHookPattern;
import spec.cvlast.CVLRange;
import spec.cvlast.CVLScope;
import spec.cvlast.Call;
import spec.cvlast.Callcode;
import spec.cvlast.Caller;
import spec.cvlast.Callvalue;
import spec.cvlast.Chainid;
import spec.cvlast.Codecopy;
import spec.cvlast.Codesize;
import spec.cvlast.Coinbase;
import spec.cvlast.Create1;
import spec.cvlast.Create2;
import spec.cvlast.Delegatecall;
import spec.cvlast.Difficulty;
import spec.cvlast.Extcodecopy;
import spec.cvlast.Extcodehash;
import spec.cvlast.Extcodesize;
import spec.cvlast.Gas;
import spec.cvlast.Gaslimit;
import spec.cvlast.Gasprice;
import spec.cvlast.Log0;
import spec.cvlast.Log1;
import spec.cvlast.Log2;
import spec.cvlast.Log3;
import spec.cvlast.Log4;
import spec.cvlast.Msize;
import spec.cvlast.Number;
import spec.cvlast.Origin;
import spec.cvlast.Revert;
import spec.cvlast.Selfbalance;
import spec.cvlast.Selfdestruct;
import spec.cvlast.Staticcall;
import spec.cvlast.Timestamp;
import spec.cvlast.VMParam;
import spec.cvlast.typechecker.CVLError;
import utils.CollectingResult;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JJ\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0015"}, d2={"Lspec/cvlast/parser/GeneratedOpcodeParsers;", "", "()V", "handleParse", "Lutils/CollectingResult;", "Lspec/cvlast/CVLHookPattern;", "Lspec/cvlast/typechecker/CVLError;", "resolver", "Lspec/TypeResolver;", "scope", "Lspec/cvlast/CVLScope;", "hookType", "Lcom/certora/evmverifier/cvl/HookType;", "valueParam", "Lcom/certora/evmverifier/cvl/NamedVMParam;", "params", "", "cvlRange", "Lspec/cvlast/CVLRange;", "supportsAutoParse", "", "Shared"})
public final class GeneratedOpcodeParsers {
    @NotNull
    public static final GeneratedOpcodeParsers INSTANCE = new GeneratedOpcodeParsers();

    private GeneratedOpcodeParsers() {
    }

    public final boolean supportsAutoParse(@NotNull HookType hookType) {
        Intrinsics.checkNotNullParameter((Object)hookType, "hookType");
        return hookType == HookType.ALL_SLOAD || hookType == HookType.ALL_SSTORE || hookType == HookType.ALL_TLOAD || hookType == HookType.ALL_TSTORE || hookType == HookType.ADDRESS || hookType == HookType.BALANCE || hookType == HookType.ORIGIN || hookType == HookType.CALLER || hookType == HookType.CALLVALUE || hookType == HookType.CODESIZE || hookType == HookType.CODECOPY || hookType == HookType.GASPRICE || hookType == HookType.EXTCODESIZE || hookType == HookType.EXTCODECOPY || hookType == HookType.EXTCODEHASH || hookType == HookType.BLOCKHASH || hookType == HookType.COINBASE || hookType == HookType.TIMESTAMP || hookType == HookType.NUMBER || hookType == HookType.DIFFICULTY || hookType == HookType.GASLIMIT || hookType == HookType.CHAINID || hookType == HookType.SELFBALANCE || hookType == HookType.BASEFEE || hookType == HookType.BLOBHASH || hookType == HookType.BLOBBASEFEE || hookType == HookType.MSIZE || hookType == HookType.GAS || hookType == HookType.LOG0 || hookType == HookType.LOG1 || hookType == HookType.LOG2 || hookType == HookType.LOG3 || hookType == HookType.LOG4 || hookType == HookType.CREATE1 || hookType == HookType.CREATE2 || hookType == HookType.CALL || hookType == HookType.CALLCODE || hookType == HookType.DELEGATECALL || hookType == HookType.STATICCALL || hookType == HookType.REVERT || hookType == HookType.SELFDESTRUCT;
    }

    @NotNull
    public final CollectingResult<CVLHookPattern, CVLError> handleParse(@NotNull TypeResolver resolver, @NotNull CVLScope scope, @NotNull HookType hookType, @Nullable NamedVMParam valueParam, @NotNull List<NamedVMParam> params, @NotNull CVLRange cvlRange) {
        CollectingResult<CVLHookPattern, CVLError> collectingResult;
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        Intrinsics.checkNotNullParameter(scope, "scope");
        Intrinsics.checkNotNullParameter((Object)hookType, "hookType");
        Intrinsics.checkNotNullParameter(params, "params");
        Intrinsics.checkNotNullParameter(cvlRange, "cvlRange");
        switch (WhenMappings.$EnumSwitchMapping$0[hookType.ordinal()]) {
            case 1: {
                if (valueParam == null) {
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, "Opcode ALL_SLOAD produces a value, but no output was declared"));
                }
                if (params.size() != 1) {
                    String string = "Opcode ALL_SLOAD expects 1 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, string));
                }
                CollectingResult<VMParam.Named, CVLError> value2 = valueParam.kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> loc = params.get(0).kotlinize(resolver, scope);
                CollectingResult[] collectingResultArray = new CollectingResult[]{value2, loc};
                collectingResult = CollectingResult.Companion.bindMany(collectingResultArray, (Function0)new Function0<CollectingResult<? extends All_sload, ? extends CVLError>>(value2, loc){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $value;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $loc;
                    {
                        this.$value = $value;
                        this.$loc = $loc;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<All_sload, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new All_sload(this.$value.force(), this.$loc.force()));
                    }
                });
                break;
            }
            case 2: {
                if (params.size() != 2) {
                    String value2 = "Opcode ALL_SSTORE expects 2 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, value2));
                }
                CollectingResult<VMParam.Named, CVLError> loc = params.get(0).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> v = params.get(1).kotlinize(resolver, scope);
                CollectingResult[] collectingResultArray = new CollectingResult[]{loc, v};
                collectingResult = CollectingResult.Companion.bindMany(collectingResultArray, (Function0)new Function0<CollectingResult<? extends All_sstore, ? extends CVLError>>(loc, v){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $loc;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $v;
                    {
                        this.$loc = $loc;
                        this.$v = $v;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<All_sstore, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new All_sstore(this.$loc.force(), this.$v.force()));
                    }
                });
                break;
            }
            case 3: {
                if (valueParam == null) {
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, "Opcode ALL_TLOAD produces a value, but no output was declared"));
                }
                if (params.size() != 1) {
                    String loc = "Opcode ALL_TLOAD expects 1 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, loc));
                }
                CollectingResult<VMParam.Named, CVLError> value3 = valueParam.kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> loc = params.get(0).kotlinize(resolver, scope);
                CollectingResult[] collectingResultArray = new CollectingResult[]{value3, loc};
                collectingResult = CollectingResult.Companion.bindMany(collectingResultArray, (Function0)new Function0<CollectingResult<? extends All_tload, ? extends CVLError>>(value3, loc){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $value;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $loc;
                    {
                        this.$value = $value;
                        this.$loc = $loc;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<All_tload, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new All_tload(this.$value.force(), this.$loc.force()));
                    }
                });
                break;
            }
            case 4: {
                if (params.size() != 2) {
                    String value3 = "Opcode ALL_TSTORE expects 2 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, value3));
                }
                CollectingResult<VMParam.Named, CVLError> loc = params.get(0).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> v = params.get(1).kotlinize(resolver, scope);
                CollectingResult[] collectingResultArray = new CollectingResult[]{loc, v};
                collectingResult = CollectingResult.Companion.bindMany(collectingResultArray, (Function0)new Function0<CollectingResult<? extends All_tstore, ? extends CVLError>>(loc, v){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $loc;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $v;
                    {
                        this.$loc = $loc;
                        this.$v = $v;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<All_tstore, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new All_tstore(this.$loc.force(), this.$v.force()));
                    }
                });
                break;
            }
            case 5: {
                if (valueParam == null) {
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, "Opcode ADDRESS produces a value, but no output was declared"));
                }
                if (params.size() != 0) {
                    String loc = "Opcode ADDRESS expects 0 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, loc));
                }
                CollectingResult<VMParam.Named, CVLError> value4 = valueParam.kotlinize(resolver, scope);
                CollectingResult[] v = new CollectingResult[]{value4};
                collectingResult = CollectingResult.Companion.bindMany(v, (Function0)new Function0<CollectingResult<? extends Address, ? extends CVLError>>(value4){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Address, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Address(this.$value.force()));
                    }
                });
                break;
            }
            case 6: {
                if (valueParam == null) {
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, "Opcode BALANCE produces a value, but no output was declared"));
                }
                if (params.size() != 1) {
                    String value4 = "Opcode BALANCE expects 1 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, value4));
                }
                CollectingResult<VMParam.Named, CVLError> value5 = valueParam.kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> addr = params.get(0).kotlinize(resolver, scope);
                CollectingResult[] collectingResultArray = new CollectingResult[]{value5, addr};
                collectingResult = CollectingResult.Companion.bindMany(collectingResultArray, (Function0)new Function0<CollectingResult<? extends Balance, ? extends CVLError>>(value5, addr){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $value;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $addr;
                    {
                        this.$value = $value;
                        this.$addr = $addr;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Balance, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Balance(this.$value.force(), this.$addr.force()));
                    }
                });
                break;
            }
            case 7: {
                if (valueParam == null) {
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, "Opcode ORIGIN produces a value, but no output was declared"));
                }
                if (params.size() != 0) {
                    String value5 = "Opcode ORIGIN expects 0 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, value5));
                }
                CollectingResult<VMParam.Named, CVLError> value6 = valueParam.kotlinize(resolver, scope);
                CollectingResult[] addr = new CollectingResult[]{value6};
                collectingResult = CollectingResult.Companion.bindMany(addr, (Function0)new Function0<CollectingResult<? extends Origin, ? extends CVLError>>(value6){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Origin, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Origin(this.$value.force()));
                    }
                });
                break;
            }
            case 8: {
                if (valueParam == null) {
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, "Opcode CALLER produces a value, but no output was declared"));
                }
                if (params.size() != 0) {
                    String value6 = "Opcode CALLER expects 0 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, value6));
                }
                CollectingResult<VMParam.Named, CVLError> value7 = valueParam.kotlinize(resolver, scope);
                CollectingResult[] addr = new CollectingResult[]{value7};
                collectingResult = CollectingResult.Companion.bindMany(addr, (Function0)new Function0<CollectingResult<? extends Caller, ? extends CVLError>>(value7){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Caller, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Caller(this.$value.force()));
                    }
                });
                break;
            }
            case 9: {
                if (valueParam == null) {
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, "Opcode CALLVALUE produces a value, but no output was declared"));
                }
                if (params.size() != 0) {
                    String value7 = "Opcode CALLVALUE expects 0 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, value7));
                }
                CollectingResult<VMParam.Named, CVLError> value8 = valueParam.kotlinize(resolver, scope);
                CollectingResult[] addr = new CollectingResult[]{value8};
                collectingResult = CollectingResult.Companion.bindMany(addr, (Function0)new Function0<CollectingResult<? extends Callvalue, ? extends CVLError>>(value8){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Callvalue, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Callvalue(this.$value.force()));
                    }
                });
                break;
            }
            case 10: {
                if (valueParam == null) {
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, "Opcode CODESIZE produces a value, but no output was declared"));
                }
                if (params.size() != 0) {
                    String value8 = "Opcode CODESIZE expects 0 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, value8));
                }
                CollectingResult<VMParam.Named, CVLError> value9 = valueParam.kotlinize(resolver, scope);
                CollectingResult[] addr = new CollectingResult[]{value9};
                collectingResult = CollectingResult.Companion.bindMany(addr, (Function0)new Function0<CollectingResult<? extends Codesize, ? extends CVLError>>(value9){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Codesize, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Codesize(this.$value.force()));
                    }
                });
                break;
            }
            case 11: {
                if (params.size() != 3) {
                    String value9 = "Opcode CODECOPY expects 3 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, value9));
                }
                CollectingResult<VMParam.Named, CVLError> destOffset = params.get(0).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> offset = params.get(1).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> length = params.get(2).kotlinize(resolver, scope);
                CollectingResult[] collectingResultArray = new CollectingResult[]{destOffset, offset, length};
                collectingResult = CollectingResult.Companion.bindMany(collectingResultArray, (Function0)new Function0<CollectingResult<? extends Codecopy, ? extends CVLError>>(destOffset, offset, length){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $destOffset;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $offset;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $length;
                    {
                        this.$destOffset = $destOffset;
                        this.$offset = $offset;
                        this.$length = $length;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Codecopy, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Codecopy(this.$destOffset.force(), this.$offset.force(), this.$length.force()));
                    }
                });
                break;
            }
            case 12: {
                if (valueParam == null) {
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, "Opcode GASPRICE produces a value, but no output was declared"));
                }
                if (params.size() != 0) {
                    String destOffset = "Opcode GASPRICE expects 0 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, destOffset));
                }
                CollectingResult<VMParam.Named, CVLError> value10 = valueParam.kotlinize(resolver, scope);
                CollectingResult[] offset = new CollectingResult[]{value10};
                collectingResult = CollectingResult.Companion.bindMany(offset, (Function0)new Function0<CollectingResult<? extends Gasprice, ? extends CVLError>>(value10){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Gasprice, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Gasprice(this.$value.force()));
                    }
                });
                break;
            }
            case 13: {
                if (valueParam == null) {
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, "Opcode EXTCODESIZE produces a value, but no output was declared"));
                }
                if (params.size() != 1) {
                    String value10 = "Opcode EXTCODESIZE expects 1 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, value10));
                }
                CollectingResult<VMParam.Named, CVLError> value11 = valueParam.kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> addr = params.get(0).kotlinize(resolver, scope);
                CollectingResult[] length = new CollectingResult[]{value11, addr};
                collectingResult = CollectingResult.Companion.bindMany(length, (Function0)new Function0<CollectingResult<? extends Extcodesize, ? extends CVLError>>(value11, addr){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $value;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $addr;
                    {
                        this.$value = $value;
                        this.$addr = $addr;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Extcodesize, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Extcodesize(this.$value.force(), this.$addr.force()));
                    }
                });
                break;
            }
            case 14: {
                if (params.size() != 4) {
                    String value11 = "Opcode EXTCODECOPY expects 4 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, value11));
                }
                CollectingResult<VMParam.Named, CVLError> addr = params.get(0).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> destOffset = params.get(1).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> offset2 = params.get(2).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> length = params.get(3).kotlinize(resolver, scope);
                CollectingResult[] collectingResultArray = new CollectingResult[]{addr, destOffset, offset2, length};
                collectingResult = CollectingResult.Companion.bindMany(collectingResultArray, (Function0)new Function0<CollectingResult<? extends Extcodecopy, ? extends CVLError>>(addr, destOffset, offset2, length){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $addr;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $destOffset;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $offset;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $length;
                    {
                        this.$addr = $addr;
                        this.$destOffset = $destOffset;
                        this.$offset = $offset;
                        this.$length = $length;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Extcodecopy, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Extcodecopy(this.$addr.force(), this.$destOffset.force(), this.$offset.force(), this.$length.force()));
                    }
                });
                break;
            }
            case 15: {
                if (valueParam == null) {
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, "Opcode EXTCODEHASH produces a value, but no output was declared"));
                }
                if (params.size() != 1) {
                    String addr = "Opcode EXTCODEHASH expects 1 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, addr));
                }
                CollectingResult<VMParam.Named, CVLError> value12 = valueParam.kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> addr = params.get(0).kotlinize(resolver, scope);
                CollectingResult[] offset2 = new CollectingResult[]{value12, addr};
                collectingResult = CollectingResult.Companion.bindMany(offset2, (Function0)new Function0<CollectingResult<? extends Extcodehash, ? extends CVLError>>(value12, addr){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $value;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $addr;
                    {
                        this.$value = $value;
                        this.$addr = $addr;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Extcodehash, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Extcodehash(this.$value.force(), this.$addr.force()));
                    }
                });
                break;
            }
            case 16: {
                if (valueParam == null) {
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, "Opcode BLOCKHASH produces a value, but no output was declared"));
                }
                if (params.size() != 1) {
                    String value12 = "Opcode BLOCKHASH expects 1 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, value12));
                }
                CollectingResult<VMParam.Named, CVLError> value13 = valueParam.kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> blockNum = params.get(0).kotlinize(resolver, scope);
                CollectingResult[] offset2 = new CollectingResult[]{value13, blockNum};
                collectingResult = CollectingResult.Companion.bindMany(offset2, (Function0)new Function0<CollectingResult<? extends Blockhash, ? extends CVLError>>(value13, blockNum){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $value;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $blockNum;
                    {
                        this.$value = $value;
                        this.$blockNum = $blockNum;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Blockhash, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Blockhash(this.$value.force(), this.$blockNum.force()));
                    }
                });
                break;
            }
            case 17: {
                if (valueParam == null) {
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, "Opcode COINBASE produces a value, but no output was declared"));
                }
                if (params.size() != 0) {
                    String value13 = "Opcode COINBASE expects 0 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, value13));
                }
                CollectingResult<VMParam.Named, CVLError> value14 = valueParam.kotlinize(resolver, scope);
                CollectingResult[] blockNum = new CollectingResult[]{value14};
                collectingResult = CollectingResult.Companion.bindMany(blockNum, (Function0)new Function0<CollectingResult<? extends Coinbase, ? extends CVLError>>(value14){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Coinbase, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Coinbase(this.$value.force()));
                    }
                });
                break;
            }
            case 18: {
                if (valueParam == null) {
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, "Opcode TIMESTAMP produces a value, but no output was declared"));
                }
                if (params.size() != 0) {
                    String value14 = "Opcode TIMESTAMP expects 0 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, value14));
                }
                CollectingResult<VMParam.Named, CVLError> value15 = valueParam.kotlinize(resolver, scope);
                CollectingResult[] blockNum = new CollectingResult[]{value15};
                collectingResult = CollectingResult.Companion.bindMany(blockNum, (Function0)new Function0<CollectingResult<? extends Timestamp, ? extends CVLError>>(value15){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Timestamp, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Timestamp(this.$value.force()));
                    }
                });
                break;
            }
            case 19: {
                if (valueParam == null) {
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, "Opcode NUMBER produces a value, but no output was declared"));
                }
                if (params.size() != 0) {
                    String value15 = "Opcode NUMBER expects 0 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, value15));
                }
                CollectingResult<VMParam.Named, CVLError> value16 = valueParam.kotlinize(resolver, scope);
                CollectingResult[] blockNum = new CollectingResult[]{value16};
                collectingResult = CollectingResult.Companion.bindMany(blockNum, (Function0)new Function0<CollectingResult<? extends Number, ? extends CVLError>>(value16){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Number, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Number(this.$value.force()));
                    }
                });
                break;
            }
            case 20: {
                if (valueParam == null) {
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, "Opcode DIFFICULTY produces a value, but no output was declared"));
                }
                if (params.size() != 0) {
                    String value16 = "Opcode DIFFICULTY expects 0 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, value16));
                }
                CollectingResult<VMParam.Named, CVLError> value17 = valueParam.kotlinize(resolver, scope);
                CollectingResult[] blockNum = new CollectingResult[]{value17};
                collectingResult = CollectingResult.Companion.bindMany(blockNum, (Function0)new Function0<CollectingResult<? extends Difficulty, ? extends CVLError>>(value17){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Difficulty, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Difficulty(this.$value.force()));
                    }
                });
                break;
            }
            case 21: {
                if (valueParam == null) {
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, "Opcode GASLIMIT produces a value, but no output was declared"));
                }
                if (params.size() != 0) {
                    String value17 = "Opcode GASLIMIT expects 0 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, value17));
                }
                CollectingResult<VMParam.Named, CVLError> value18 = valueParam.kotlinize(resolver, scope);
                CollectingResult[] blockNum = new CollectingResult[]{value18};
                collectingResult = CollectingResult.Companion.bindMany(blockNum, (Function0)new Function0<CollectingResult<? extends Gaslimit, ? extends CVLError>>(value18){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Gaslimit, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Gaslimit(this.$value.force()));
                    }
                });
                break;
            }
            case 22: {
                if (valueParam == null) {
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, "Opcode CHAINID produces a value, but no output was declared"));
                }
                if (params.size() != 0) {
                    String value18 = "Opcode CHAINID expects 0 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, value18));
                }
                CollectingResult<VMParam.Named, CVLError> value19 = valueParam.kotlinize(resolver, scope);
                CollectingResult[] blockNum = new CollectingResult[]{value19};
                collectingResult = CollectingResult.Companion.bindMany(blockNum, (Function0)new Function0<CollectingResult<? extends Chainid, ? extends CVLError>>(value19){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Chainid, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Chainid(this.$value.force()));
                    }
                });
                break;
            }
            case 23: {
                if (valueParam == null) {
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, "Opcode SELFBALANCE produces a value, but no output was declared"));
                }
                if (params.size() != 0) {
                    String value19 = "Opcode SELFBALANCE expects 0 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, value19));
                }
                CollectingResult<VMParam.Named, CVLError> value20 = valueParam.kotlinize(resolver, scope);
                CollectingResult[] blockNum = new CollectingResult[]{value20};
                collectingResult = CollectingResult.Companion.bindMany(blockNum, (Function0)new Function0<CollectingResult<? extends Selfbalance, ? extends CVLError>>(value20){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Selfbalance, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Selfbalance(this.$value.force()));
                    }
                });
                break;
            }
            case 24: {
                if (valueParam == null) {
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, "Opcode BASEFEE produces a value, but no output was declared"));
                }
                if (params.size() != 0) {
                    String value20 = "Opcode BASEFEE expects 0 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, value20));
                }
                CollectingResult<VMParam.Named, CVLError> value21 = valueParam.kotlinize(resolver, scope);
                CollectingResult[] blockNum = new CollectingResult[]{value21};
                collectingResult = CollectingResult.Companion.bindMany(blockNum, (Function0)new Function0<CollectingResult<? extends Basefee, ? extends CVLError>>(value21){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Basefee, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Basefee(this.$value.force()));
                    }
                });
                break;
            }
            case 25: {
                if (valueParam == null) {
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, "Opcode BLOBHASH produces a value, but no output was declared"));
                }
                if (params.size() != 1) {
                    String value21 = "Opcode BLOBHASH expects 1 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, value21));
                }
                CollectingResult<VMParam.Named, CVLError> value22 = valueParam.kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> index = params.get(0).kotlinize(resolver, scope);
                CollectingResult[] offset2 = new CollectingResult[]{value22, index};
                collectingResult = CollectingResult.Companion.bindMany(offset2, (Function0)new Function0<CollectingResult<? extends Blobhash, ? extends CVLError>>(value22, index){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $value;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $index;
                    {
                        this.$value = $value;
                        this.$index = $index;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Blobhash, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Blobhash(this.$value.force(), this.$index.force()));
                    }
                });
                break;
            }
            case 26: {
                if (valueParam == null) {
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, "Opcode BLOBBASEFEE produces a value, but no output was declared"));
                }
                if (params.size() != 0) {
                    String value22 = "Opcode BLOBBASEFEE expects 0 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, value22));
                }
                CollectingResult<VMParam.Named, CVLError> value23 = valueParam.kotlinize(resolver, scope);
                CollectingResult[] index = new CollectingResult[]{value23};
                collectingResult = CollectingResult.Companion.bindMany(index, (Function0)new Function0<CollectingResult<? extends Blobbasefee, ? extends CVLError>>(value23){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Blobbasefee, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Blobbasefee(this.$value.force()));
                    }
                });
                break;
            }
            case 27: {
                if (valueParam == null) {
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, "Opcode MSIZE produces a value, but no output was declared"));
                }
                if (params.size() != 0) {
                    String value23 = "Opcode MSIZE expects 0 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, value23));
                }
                CollectingResult<VMParam.Named, CVLError> value24 = valueParam.kotlinize(resolver, scope);
                CollectingResult[] index = new CollectingResult[]{value24};
                collectingResult = CollectingResult.Companion.bindMany(index, (Function0)new Function0<CollectingResult<? extends Msize, ? extends CVLError>>(value24){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Msize, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Msize(this.$value.force()));
                    }
                });
                break;
            }
            case 28: {
                if (valueParam == null) {
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, "Opcode GAS produces a value, but no output was declared"));
                }
                if (params.size() != 0) {
                    String value24 = "Opcode GAS expects 0 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, value24));
                }
                CollectingResult<VMParam.Named, CVLError> value25 = valueParam.kotlinize(resolver, scope);
                CollectingResult[] index = new CollectingResult[]{value25};
                collectingResult = CollectingResult.Companion.bindMany(index, (Function0)new Function0<CollectingResult<? extends Gas, ? extends CVLError>>(value25){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Gas, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Gas(this.$value.force()));
                    }
                });
                break;
            }
            case 29: {
                if (params.size() != 2) {
                    String value25 = "Opcode LOG0 expects 2 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, value25));
                }
                CollectingResult<VMParam.Named, CVLError> offset = params.get(0).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> size = params.get(1).kotlinize(resolver, scope);
                CollectingResult[] offset2 = new CollectingResult[]{offset, size};
                collectingResult = CollectingResult.Companion.bindMany(offset2, (Function0)new Function0<CollectingResult<? extends Log0, ? extends CVLError>>(offset, size){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $offset;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $size;
                    {
                        this.$offset = $offset;
                        this.$size = $size;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Log0, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Log0(this.$offset.force(), this.$size.force()));
                    }
                });
                break;
            }
            case 30: {
                if (params.size() != 3) {
                    String offset = "Opcode LOG1 expects 3 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, offset));
                }
                CollectingResult<VMParam.Named, CVLError> offset = params.get(0).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> size = params.get(1).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> topic1 = params.get(2).kotlinize(resolver, scope);
                CollectingResult[] length = new CollectingResult[]{offset, size, topic1};
                collectingResult = CollectingResult.Companion.bindMany(length, (Function0)new Function0<CollectingResult<? extends Log1, ? extends CVLError>>(offset, size, topic1){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $offset;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $size;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $topic1;
                    {
                        this.$offset = $offset;
                        this.$size = $size;
                        this.$topic1 = $topic1;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Log1, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Log1(this.$offset.force(), this.$size.force(), this.$topic1.force()));
                    }
                });
                break;
            }
            case 31: {
                if (params.size() != 4) {
                    String offset = "Opcode LOG2 expects 4 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, offset));
                }
                CollectingResult<VMParam.Named, CVLError> offset = params.get(0).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> size = params.get(1).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> topic1 = params.get(2).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> topic2 = params.get(3).kotlinize(resolver, scope);
                CollectingResult[] collectingResultArray = new CollectingResult[]{offset, size, topic1, topic2};
                collectingResult = CollectingResult.Companion.bindMany(collectingResultArray, (Function0)new Function0<CollectingResult<? extends Log2, ? extends CVLError>>(offset, size, topic1, topic2){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $offset;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $size;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $topic1;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $topic2;
                    {
                        this.$offset = $offset;
                        this.$size = $size;
                        this.$topic1 = $topic1;
                        this.$topic2 = $topic2;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Log2, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Log2(this.$offset.force(), this.$size.force(), this.$topic1.force(), this.$topic2.force()));
                    }
                });
                break;
            }
            case 32: {
                if (params.size() != 5) {
                    String offset = "Opcode LOG3 expects 5 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, offset));
                }
                CollectingResult<VMParam.Named, CVLError> offset = params.get(0).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> size = params.get(1).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> topic1 = params.get(2).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> topic2 = params.get(3).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> topic3 = params.get(4).kotlinize(resolver, scope);
                CollectingResult[] collectingResultArray = new CollectingResult[]{offset, size, topic1, topic2, topic3};
                collectingResult = CollectingResult.Companion.bindMany(collectingResultArray, (Function0)new Function0<CollectingResult<? extends Log3, ? extends CVLError>>(offset, size, topic1, topic2, topic3){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $offset;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $size;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $topic1;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $topic2;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $topic3;
                    {
                        this.$offset = $offset;
                        this.$size = $size;
                        this.$topic1 = $topic1;
                        this.$topic2 = $topic2;
                        this.$topic3 = $topic3;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Log3, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Log3(this.$offset.force(), this.$size.force(), this.$topic1.force(), this.$topic2.force(), this.$topic3.force()));
                    }
                });
                break;
            }
            case 33: {
                if (params.size() != 6) {
                    String offset = "Opcode LOG4 expects 6 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, offset));
                }
                CollectingResult<VMParam.Named, CVLError> offset = params.get(0).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> size = params.get(1).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> topic1 = params.get(2).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> topic2 = params.get(3).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> topic3 = params.get(4).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> topic4 = params.get(5).kotlinize(resolver, scope);
                CollectingResult[] collectingResultArray = new CollectingResult[]{offset, size, topic1, topic2, topic3, topic4};
                collectingResult = CollectingResult.Companion.bindMany(collectingResultArray, (Function0)new Function0<CollectingResult<? extends Log4, ? extends CVLError>>(offset, size, topic1, topic2, topic3, topic4){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $offset;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $size;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $topic1;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $topic2;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $topic3;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $topic4;
                    {
                        this.$offset = $offset;
                        this.$size = $size;
                        this.$topic1 = $topic1;
                        this.$topic2 = $topic2;
                        this.$topic3 = $topic3;
                        this.$topic4 = $topic4;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Log4, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Log4(this.$offset.force(), this.$size.force(), this.$topic1.force(), this.$topic2.force(), this.$topic3.force(), this.$topic4.force()));
                    }
                });
                break;
            }
            case 34: {
                if (valueParam == null) {
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, "Opcode CREATE1 produces a value, but no output was declared"));
                }
                if (params.size() != 3) {
                    String offset = "Opcode CREATE1 expects 3 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, offset));
                }
                CollectingResult<VMParam.Named, CVLError> value26 = valueParam.kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> callValue = params.get(0).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> offset = params.get(1).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> len = params.get(2).kotlinize(resolver, scope);
                CollectingResult[] topic3 = new CollectingResult[]{value26, callValue, offset, len};
                collectingResult = CollectingResult.Companion.bindMany(topic3, (Function0)new Function0<CollectingResult<? extends Create1, ? extends CVLError>>(value26, callValue, offset, len){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $value;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $callValue;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $offset;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $len;
                    {
                        this.$value = $value;
                        this.$callValue = $callValue;
                        this.$offset = $offset;
                        this.$len = $len;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Create1, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Create1(this.$value.force(), this.$callValue.force(), this.$offset.force(), this.$len.force()));
                    }
                });
                break;
            }
            case 35: {
                if (valueParam == null) {
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, "Opcode CREATE2 produces a value, but no output was declared"));
                }
                if (params.size() != 4) {
                    String value26 = "Opcode CREATE2 expects 4 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, value26));
                }
                CollectingResult<VMParam.Named, CVLError> value27 = valueParam.kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> callValue = params.get(0).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> offset = params.get(1).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> len = params.get(2).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> salt = params.get(3).kotlinize(resolver, scope);
                CollectingResult[] topic4 = new CollectingResult[]{value27, callValue, offset, len, salt};
                collectingResult = CollectingResult.Companion.bindMany(topic4, (Function0)new Function0<CollectingResult<? extends Create2, ? extends CVLError>>(value27, callValue, offset, len, salt){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $value;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $callValue;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $offset;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $len;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $salt;
                    {
                        this.$value = $value;
                        this.$callValue = $callValue;
                        this.$offset = $offset;
                        this.$len = $len;
                        this.$salt = $salt;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Create2, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Create2(this.$value.force(), this.$callValue.force(), this.$offset.force(), this.$len.force(), this.$salt.force()));
                    }
                });
                break;
            }
            case 36: {
                if (valueParam == null) {
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, "Opcode CALL produces a value, but no output was declared"));
                }
                if (params.size() != 7) {
                    String value27 = "Opcode CALL expects 7 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, value27));
                }
                CollectingResult<VMParam.Named, CVLError> value28 = valueParam.kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> gas = params.get(0).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> addr = params.get(1).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> callValue = params.get(2).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> argsOffset = params.get(3).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> argsLength = params.get(4).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> retOffset = params.get(5).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> retLength = params.get(6).kotlinize(resolver, scope);
                CollectingResult[] collectingResultArray = new CollectingResult[]{value28, gas, addr, callValue, argsOffset, argsLength, retOffset, retLength};
                collectingResult = CollectingResult.Companion.bindMany(collectingResultArray, (Function0)new Function0<CollectingResult<? extends Call, ? extends CVLError>>(value28, gas, addr, callValue, argsOffset, argsLength, retOffset, retLength){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $value;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $gas;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $addr;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $callValue;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $argsOffset;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $argsLength;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $retOffset;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $retLength;
                    {
                        this.$value = $value;
                        this.$gas = $gas;
                        this.$addr = $addr;
                        this.$callValue = $callValue;
                        this.$argsOffset = $argsOffset;
                        this.$argsLength = $argsLength;
                        this.$retOffset = $retOffset;
                        this.$retLength = $retLength;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Call, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Call(this.$value.force(), this.$gas.force(), this.$addr.force(), this.$callValue.force(), this.$argsOffset.force(), this.$argsLength.force(), this.$retOffset.force(), this.$retLength.force()));
                    }
                });
                break;
            }
            case 37: {
                if (valueParam == null) {
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, "Opcode CALLCODE produces a value, but no output was declared"));
                }
                if (params.size() != 7) {
                    String value28 = "Opcode CALLCODE expects 7 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, value28));
                }
                CollectingResult<VMParam.Named, CVLError> value29 = valueParam.kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> gas = params.get(0).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> addr = params.get(1).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> callValue = params.get(2).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> argsOffset = params.get(3).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> argsLength = params.get(4).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> retOffset = params.get(5).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> retLength = params.get(6).kotlinize(resolver, scope);
                CollectingResult[] collectingResultArray = new CollectingResult[]{value29, gas, addr, callValue, argsOffset, argsLength, retOffset, retLength};
                collectingResult = CollectingResult.Companion.bindMany(collectingResultArray, (Function0)new Function0<CollectingResult<? extends Callcode, ? extends CVLError>>(value29, gas, addr, callValue, argsOffset, argsLength, retOffset, retLength){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $value;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $gas;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $addr;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $callValue;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $argsOffset;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $argsLength;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $retOffset;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $retLength;
                    {
                        this.$value = $value;
                        this.$gas = $gas;
                        this.$addr = $addr;
                        this.$callValue = $callValue;
                        this.$argsOffset = $argsOffset;
                        this.$argsLength = $argsLength;
                        this.$retOffset = $retOffset;
                        this.$retLength = $retLength;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Callcode, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Callcode(this.$value.force(), this.$gas.force(), this.$addr.force(), this.$callValue.force(), this.$argsOffset.force(), this.$argsLength.force(), this.$retOffset.force(), this.$retLength.force()));
                    }
                });
                break;
            }
            case 38: {
                if (valueParam == null) {
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, "Opcode DELEGATECALL produces a value, but no output was declared"));
                }
                if (params.size() != 6) {
                    String value29 = "Opcode DELEGATECALL expects 6 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, value29));
                }
                CollectingResult<VMParam.Named, CVLError> value30 = valueParam.kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> gas = params.get(0).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> addr = params.get(1).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> argsOffset = params.get(2).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> argsLength = params.get(3).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> retOffset = params.get(4).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> retLength = params.get(5).kotlinize(resolver, scope);
                CollectingResult[] collectingResultArray = new CollectingResult[]{value30, gas, addr, argsOffset, argsLength, retOffset, retLength};
                collectingResult = CollectingResult.Companion.bindMany(collectingResultArray, (Function0)new Function0<CollectingResult<? extends Delegatecall, ? extends CVLError>>(value30, gas, addr, argsOffset, argsLength, retOffset, retLength){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $value;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $gas;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $addr;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $argsOffset;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $argsLength;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $retOffset;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $retLength;
                    {
                        this.$value = $value;
                        this.$gas = $gas;
                        this.$addr = $addr;
                        this.$argsOffset = $argsOffset;
                        this.$argsLength = $argsLength;
                        this.$retOffset = $retOffset;
                        this.$retLength = $retLength;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Delegatecall, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Delegatecall(this.$value.force(), this.$gas.force(), this.$addr.force(), this.$argsOffset.force(), this.$argsLength.force(), this.$retOffset.force(), this.$retLength.force()));
                    }
                });
                break;
            }
            case 39: {
                if (valueParam == null) {
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, "Opcode STATICCALL produces a value, but no output was declared"));
                }
                if (params.size() != 6) {
                    String value30 = "Opcode STATICCALL expects 6 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, value30));
                }
                CollectingResult<VMParam.Named, CVLError> value31 = valueParam.kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> gas = params.get(0).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> addr = params.get(1).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> argsOffset = params.get(2).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> argsLength = params.get(3).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> retOffset = params.get(4).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> retLength = params.get(5).kotlinize(resolver, scope);
                CollectingResult[] collectingResultArray = new CollectingResult[]{value31, gas, addr, argsOffset, argsLength, retOffset, retLength};
                collectingResult = CollectingResult.Companion.bindMany(collectingResultArray, (Function0)new Function0<CollectingResult<? extends Staticcall, ? extends CVLError>>(value31, gas, addr, argsOffset, argsLength, retOffset, retLength){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $value;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $gas;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $addr;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $argsOffset;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $argsLength;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $retOffset;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $retLength;
                    {
                        this.$value = $value;
                        this.$gas = $gas;
                        this.$addr = $addr;
                        this.$argsOffset = $argsOffset;
                        this.$argsLength = $argsLength;
                        this.$retOffset = $retOffset;
                        this.$retLength = $retLength;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Staticcall, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Staticcall(this.$value.force(), this.$gas.force(), this.$addr.force(), this.$argsOffset.force(), this.$argsLength.force(), this.$retOffset.force(), this.$retLength.force()));
                    }
                });
                break;
            }
            case 40: {
                if (params.size() != 2) {
                    String value31 = "Opcode REVERT expects 2 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, value31));
                }
                CollectingResult<VMParam.Named, CVLError> offset = params.get(0).kotlinize(resolver, scope);
                CollectingResult<VMParam.Named, CVLError> size = params.get(1).kotlinize(resolver, scope);
                CollectingResult[] collectingResultArray = new CollectingResult[]{offset, size};
                collectingResult = CollectingResult.Companion.bindMany(collectingResultArray, (Function0)new Function0<CollectingResult<? extends Revert, ? extends CVLError>>(offset, size){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $offset;
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $size;
                    {
                        this.$offset = $offset;
                        this.$size = $size;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Revert, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Revert(this.$offset.force(), this.$size.force()));
                    }
                });
                break;
            }
            case 41: {
                if (params.size() != 1) {
                    String offset = "Opcode SELFDESTRUCT expects 1 parameters, got " + params.size();
                    return CollectingResult.Companion.asError(new CVLError.General(cvlRange, offset));
                }
                CollectingResult<VMParam.Named, CVLError> addr = params.get(0).kotlinize(resolver, scope);
                CollectingResult[] collectingResultArray = new CollectingResult[]{addr};
                collectingResult = CollectingResult.Companion.bindMany(collectingResultArray, (Function0)new Function0<CollectingResult<? extends Selfdestruct, ? extends CVLError>>(addr){
                    final /* synthetic */ CollectingResult<VMParam.Named, CVLError> $addr;
                    {
                        this.$addr = $addr;
                        super(0);
                    }

                    @NotNull
                    public final CollectingResult<Selfdestruct, CVLError> invoke() {
                        return CollectingResult.Companion.lift(new Selfdestruct(this.$addr.force()));
                    }
                });
                break;
            }
            default: {
                throw new UnsupportedOperationException("cannot auto parse " + hookType);
            }
        }
        return collectingResult;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HookType.values().length];
            try {
                nArray[HookType.ALL_SLOAD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.ALL_SSTORE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.ALL_TLOAD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.ALL_TSTORE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.ADDRESS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.BALANCE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.ORIGIN.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.CALLER.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.CALLVALUE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.CODESIZE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.CODECOPY.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.GASPRICE.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.EXTCODESIZE.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.EXTCODECOPY.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.EXTCODEHASH.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.BLOCKHASH.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.COINBASE.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.TIMESTAMP.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.NUMBER.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.DIFFICULTY.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.GASLIMIT.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.CHAINID.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.SELFBALANCE.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.BASEFEE.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.BLOBHASH.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.BLOBBASEFEE.ordinal()] = 26;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.MSIZE.ordinal()] = 27;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.GAS.ordinal()] = 28;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.LOG0.ordinal()] = 29;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.LOG1.ordinal()] = 30;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.LOG2.ordinal()] = 31;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.LOG3.ordinal()] = 32;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.LOG4.ordinal()] = 33;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.CREATE1.ordinal()] = 34;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.CREATE2.ordinal()] = 35;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.CALL.ordinal()] = 36;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.CALLCODE.ordinal()] = 37;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.DELEGATECALL.ordinal()] = 38;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.STATICCALL.ordinal()] = 39;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.REVERT.ordinal()] = 40;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HookType.SELFDESTRUCT.ordinal()] = 41;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

