# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceSwitchportFeatureArgs', 'ServiceSwitchportFeature']

@pulumi.input_type
class ServiceSwitchportFeatureArgs:
    def __init__(__self__, *,
                 feature_profile_id: pulumi.Input[str],
                 age_out_time: Optional[pulumi.Input[int]] = None,
                 age_out_time_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceSwitchportFeatureInterfaceArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 static_mac_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceSwitchportFeatureStaticMacAddressArgs']]]] = None):
        """
        The set of arguments for constructing a ServiceSwitchportFeature resource.
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[int] age_out_time: Set when a MAC table entry ages out (0 to disable, 10-1000000 otherwise) - Range: `0`-`1000000` - Default value: `300`
        :param pulumi.Input[str] age_out_time_variable: Variable name
        :param pulumi.Input[str] description: The description of the Feature
        :param pulumi.Input[Sequence[pulumi.Input['ServiceSwitchportFeatureInterfaceArgs']]] interfaces: Interface name: GigabitEthernet0/<>/<> when present
        :param pulumi.Input[str] name: The name of the Feature
        :param pulumi.Input[Sequence[pulumi.Input['ServiceSwitchportFeatureStaticMacAddressArgs']]] static_mac_addresses: Add static MAC address entries for interface
        """
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if age_out_time is not None:
            pulumi.set(__self__, "age_out_time", age_out_time)
        if age_out_time_variable is not None:
            pulumi.set(__self__, "age_out_time_variable", age_out_time_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if interfaces is not None:
            pulumi.set(__self__, "interfaces", interfaces)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if static_mac_addresses is not None:
            pulumi.set(__self__, "static_mac_addresses", static_mac_addresses)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Input[str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter(name="ageOutTime")
    def age_out_time(self) -> Optional[pulumi.Input[int]]:
        """
        Set when a MAC table entry ages out (0 to disable, 10-1000000 otherwise) - Range: `0`-`1000000` - Default value: `300`
        """
        return pulumi.get(self, "age_out_time")

    @age_out_time.setter
    def age_out_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "age_out_time", value)

    @property
    @pulumi.getter(name="ageOutTimeVariable")
    def age_out_time_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "age_out_time_variable")

    @age_out_time_variable.setter
    def age_out_time_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "age_out_time_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceSwitchportFeatureInterfaceArgs']]]]:
        """
        Interface name: GigabitEthernet0/<>/<> when present
        """
        return pulumi.get(self, "interfaces")

    @interfaces.setter
    def interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceSwitchportFeatureInterfaceArgs']]]]):
        pulumi.set(self, "interfaces", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="staticMacAddresses")
    def static_mac_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceSwitchportFeatureStaticMacAddressArgs']]]]:
        """
        Add static MAC address entries for interface
        """
        return pulumi.get(self, "static_mac_addresses")

    @static_mac_addresses.setter
    def static_mac_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceSwitchportFeatureStaticMacAddressArgs']]]]):
        pulumi.set(self, "static_mac_addresses", value)


@pulumi.input_type
class _ServiceSwitchportFeatureState:
    def __init__(__self__, *,
                 age_out_time: Optional[pulumi.Input[int]] = None,
                 age_out_time_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 feature_profile_id: Optional[pulumi.Input[str]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceSwitchportFeatureInterfaceArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 static_mac_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceSwitchportFeatureStaticMacAddressArgs']]]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering ServiceSwitchportFeature resources.
        :param pulumi.Input[int] age_out_time: Set when a MAC table entry ages out (0 to disable, 10-1000000 otherwise) - Range: `0`-`1000000` - Default value: `300`
        :param pulumi.Input[str] age_out_time_variable: Variable name
        :param pulumi.Input[str] description: The description of the Feature
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[Sequence[pulumi.Input['ServiceSwitchportFeatureInterfaceArgs']]] interfaces: Interface name: GigabitEthernet0/<>/<> when present
        :param pulumi.Input[str] name: The name of the Feature
        :param pulumi.Input[Sequence[pulumi.Input['ServiceSwitchportFeatureStaticMacAddressArgs']]] static_mac_addresses: Add static MAC address entries for interface
        :param pulumi.Input[int] version: The version of the Feature
        """
        if age_out_time is not None:
            pulumi.set(__self__, "age_out_time", age_out_time)
        if age_out_time_variable is not None:
            pulumi.set(__self__, "age_out_time_variable", age_out_time_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if interfaces is not None:
            pulumi.set(__self__, "interfaces", interfaces)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if static_mac_addresses is not None:
            pulumi.set(__self__, "static_mac_addresses", static_mac_addresses)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="ageOutTime")
    def age_out_time(self) -> Optional[pulumi.Input[int]]:
        """
        Set when a MAC table entry ages out (0 to disable, 10-1000000 otherwise) - Range: `0`-`1000000` - Default value: `300`
        """
        return pulumi.get(self, "age_out_time")

    @age_out_time.setter
    def age_out_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "age_out_time", value)

    @property
    @pulumi.getter(name="ageOutTimeVariable")
    def age_out_time_variable(self) -> Optional[pulumi.Input[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "age_out_time_variable")

    @age_out_time_variable.setter
    def age_out_time_variable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "age_out_time_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter
    def interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceSwitchportFeatureInterfaceArgs']]]]:
        """
        Interface name: GigabitEthernet0/<>/<> when present
        """
        return pulumi.get(self, "interfaces")

    @interfaces.setter
    def interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceSwitchportFeatureInterfaceArgs']]]]):
        pulumi.set(self, "interfaces", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="staticMacAddresses")
    def static_mac_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceSwitchportFeatureStaticMacAddressArgs']]]]:
        """
        Add static MAC address entries for interface
        """
        return pulumi.get(self, "static_mac_addresses")

    @static_mac_addresses.setter
    def static_mac_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceSwitchportFeatureStaticMacAddressArgs']]]]):
        pulumi.set(self, "static_mac_addresses", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class ServiceSwitchportFeature(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 age_out_time: Optional[pulumi.Input[int]] = None,
                 age_out_time_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 feature_profile_id: Optional[pulumi.Input[str]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceSwitchportFeatureInterfaceArgs', 'ServiceSwitchportFeatureInterfaceArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 static_mac_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceSwitchportFeatureStaticMacAddressArgs', 'ServiceSwitchportFeatureStaticMacAddressArgsDict']]]]] = None,
                 __props__=None):
        """
        This resource can manage a Service Switchport Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        Expected import identifier with the format: "service_switchport_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/serviceSwitchportFeature:ServiceSwitchportFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] age_out_time: Set when a MAC table entry ages out (0 to disable, 10-1000000 otherwise) - Range: `0`-`1000000` - Default value: `300`
        :param pulumi.Input[str] age_out_time_variable: Variable name
        :param pulumi.Input[str] description: The description of the Feature
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceSwitchportFeatureInterfaceArgs', 'ServiceSwitchportFeatureInterfaceArgsDict']]]] interfaces: Interface name: GigabitEthernet0/<>/<> when present
        :param pulumi.Input[str] name: The name of the Feature
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceSwitchportFeatureStaticMacAddressArgs', 'ServiceSwitchportFeatureStaticMacAddressArgsDict']]]] static_mac_addresses: Add static MAC address entries for interface
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceSwitchportFeatureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Service Switchport Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        Expected import identifier with the format: "service_switchport_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/serviceSwitchportFeature:ServiceSwitchportFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param ServiceSwitchportFeatureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceSwitchportFeatureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 age_out_time: Optional[pulumi.Input[int]] = None,
                 age_out_time_variable: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 feature_profile_id: Optional[pulumi.Input[str]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceSwitchportFeatureInterfaceArgs', 'ServiceSwitchportFeatureInterfaceArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 static_mac_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceSwitchportFeatureStaticMacAddressArgs', 'ServiceSwitchportFeatureStaticMacAddressArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceSwitchportFeatureArgs.__new__(ServiceSwitchportFeatureArgs)

            __props__.__dict__["age_out_time"] = age_out_time
            __props__.__dict__["age_out_time_variable"] = age_out_time_variable
            __props__.__dict__["description"] = description
            if feature_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'feature_profile_id'")
            __props__.__dict__["feature_profile_id"] = feature_profile_id
            __props__.__dict__["interfaces"] = interfaces
            __props__.__dict__["name"] = name
            __props__.__dict__["static_mac_addresses"] = static_mac_addresses
            __props__.__dict__["version"] = None
        super(ServiceSwitchportFeature, __self__).__init__(
            'sdwan:index/serviceSwitchportFeature:ServiceSwitchportFeature',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            age_out_time: Optional[pulumi.Input[int]] = None,
            age_out_time_variable: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            feature_profile_id: Optional[pulumi.Input[str]] = None,
            interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceSwitchportFeatureInterfaceArgs', 'ServiceSwitchportFeatureInterfaceArgsDict']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            static_mac_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceSwitchportFeatureStaticMacAddressArgs', 'ServiceSwitchportFeatureStaticMacAddressArgsDict']]]]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'ServiceSwitchportFeature':
        """
        Get an existing ServiceSwitchportFeature resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] age_out_time: Set when a MAC table entry ages out (0 to disable, 10-1000000 otherwise) - Range: `0`-`1000000` - Default value: `300`
        :param pulumi.Input[str] age_out_time_variable: Variable name
        :param pulumi.Input[str] description: The description of the Feature
        :param pulumi.Input[str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceSwitchportFeatureInterfaceArgs', 'ServiceSwitchportFeatureInterfaceArgsDict']]]] interfaces: Interface name: GigabitEthernet0/<>/<> when present
        :param pulumi.Input[str] name: The name of the Feature
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceSwitchportFeatureStaticMacAddressArgs', 'ServiceSwitchportFeatureStaticMacAddressArgsDict']]]] static_mac_addresses: Add static MAC address entries for interface
        :param pulumi.Input[int] version: The version of the Feature
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceSwitchportFeatureState.__new__(_ServiceSwitchportFeatureState)

        __props__.__dict__["age_out_time"] = age_out_time
        __props__.__dict__["age_out_time_variable"] = age_out_time_variable
        __props__.__dict__["description"] = description
        __props__.__dict__["feature_profile_id"] = feature_profile_id
        __props__.__dict__["interfaces"] = interfaces
        __props__.__dict__["name"] = name
        __props__.__dict__["static_mac_addresses"] = static_mac_addresses
        __props__.__dict__["version"] = version
        return ServiceSwitchportFeature(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="ageOutTime")
    def age_out_time(self) -> pulumi.Output[Optional[int]]:
        """
        Set when a MAC table entry ages out (0 to disable, 10-1000000 otherwise) - Range: `0`-`1000000` - Default value: `300`
        """
        return pulumi.get(self, "age_out_time")

    @property
    @pulumi.getter(name="ageOutTimeVariable")
    def age_out_time_variable(self) -> pulumi.Output[Optional[str]]:
        """
        Variable name
        """
        return pulumi.get(self, "age_out_time_variable")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Output[str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @property
    @pulumi.getter
    def interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceSwitchportFeatureInterface']]]:
        """
        Interface name: GigabitEthernet0/<>/<> when present
        """
        return pulumi.get(self, "interfaces")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="staticMacAddresses")
    def static_mac_addresses(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceSwitchportFeatureStaticMacAddress']]]:
        """
        Add static MAC address entries for interface
        """
        return pulumi.get(self, "static_mac_addresses")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

