/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.metric;

import io.ray.runtime.metric.Metric;
import io.ray.runtime.metric.NativeMetric;
import io.ray.runtime.metric.TagKey;
import io.ray.shaded.com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.stream.Collectors;

public class Count
extends Metric {
    private DoubleAdder count = new DoubleAdder();

    @Deprecated
    public Count(String name, String description, String unit, Map<TagKey, String> tags) {
        super(name, tags);
        this.metricNativePointer = NativeMetric.registerCountNative(name, description, unit, tags.keySet().stream().map(TagKey::getTagKey).collect(Collectors.toList()));
        Preconditions.checkState(this.metricNativePointer != 0L, "Count native pointer must not be 0.");
    }

    public Count(String name, String description, Map<String, String> tags) {
        this(name, description, "", TagKey.tagsFromMap(tags));
    }

    @Override
    public void update(double value) {
        this.count.add(value);
        this.value.addAndGet(value);
    }

    @Override
    protected double getAndReset() {
        return this.count.sumThenReset();
    }

    public double getCount() {
        return this.value.get();
    }

    public void inc(double delta) {
        this.update(delta);
    }
}

