/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.placementgroup;

import io.ray.api.id.PlacementGroupId;
import io.ray.api.placementgroup.PlacementGroupState;
import io.ray.api.placementgroup.PlacementStrategy;
import io.ray.runtime.generated.Common;
import io.ray.runtime.generated.Gcs;
import io.ray.runtime.placementgroup.PlacementGroupImpl;
import io.ray.shaded.com.google.common.base.Preconditions;
import io.ray.shaded.com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PlacementGroupUtils {
    private static List<Map<String, Double>> covertToUserSpecifiedBundles(List<Common.Bundle> bundles) {
        ArrayList<Map<String, Double>> result = new ArrayList<Map<String, Double>>();
        for (int i = 0; i < bundles.size(); ++i) {
            Common.Bundle bundle = bundles.get(i);
            result.add(bundle.getUnitResourcesMap());
        }
        return result;
    }

    private static PlacementStrategy covertToUserSpecifiedStrategy(Common.PlacementStrategy strategy) {
        switch (strategy) {
            case PACK: {
                return PlacementStrategy.PACK;
            }
            case STRICT_PACK: {
                return PlacementStrategy.STRICT_PACK;
            }
            case SPREAD: {
                return PlacementStrategy.SPREAD;
            }
            case STRICT_SPREAD: {
                return PlacementStrategy.STRICT_SPREAD;
            }
        }
        return PlacementStrategy.UNRECOGNIZED;
    }

    private static PlacementGroupState covertToUserSpecifiedState(Gcs.PlacementGroupTableData.PlacementGroupState state) {
        switch (state) {
            case PENDING: {
                return PlacementGroupState.PENDING;
            }
            case CREATED: {
                return PlacementGroupState.CREATED;
            }
            case REMOVED: {
                return PlacementGroupState.REMOVED;
            }
            case RESCHEDULING: {
                return PlacementGroupState.RESCHEDULING;
            }
        }
        return PlacementGroupState.UNRECOGNIZED;
    }

    private static PlacementGroupImpl generatePlacementGroupFromPbData(Gcs.PlacementGroupTableData placementGroupTableData) {
        PlacementGroupState state = PlacementGroupUtils.covertToUserSpecifiedState(placementGroupTableData.getState());
        PlacementStrategy strategy = PlacementGroupUtils.covertToUserSpecifiedStrategy(placementGroupTableData.getStrategy());
        List<Map<String, Double>> bundles = PlacementGroupUtils.covertToUserSpecifiedBundles(placementGroupTableData.getBundlesList());
        PlacementGroupId placementGroupId = PlacementGroupId.fromByteBuffer(placementGroupTableData.getPlacementGroupId().asReadOnlyByteBuffer());
        return new PlacementGroupImpl.Builder().setId(placementGroupId).setName(placementGroupTableData.getName()).setState(state).setStrategy(strategy).setBundles(bundles).build();
    }

    public static PlacementGroupImpl generatePlacementGroupFromByteArray(byte[] placementGroupByteArray) {
        Gcs.PlacementGroupTableData placementGroupTableData;
        Preconditions.checkNotNull(placementGroupByteArray, "Can't generate a placement group from empty byte array.");
        try {
            placementGroupTableData = Gcs.PlacementGroupTableData.parseFrom(placementGroupByteArray);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Received invalid placement group table protobuf data from GCS.", e);
        }
        return PlacementGroupUtils.generatePlacementGroupFromPbData(placementGroupTableData);
    }
}

