/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.util;

import io.ray.api.Ray;
import io.ray.runtime.AbstractRayRuntime;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public final class MethodUtils {
    public static String getSignature(Method m4) {
        String string;
        String sig;
        try {
            Field signatureField = Method.class.getDeclaredField("signature");
            signatureField.setAccessible(true);
            sig = (String)signatureField.get(m4);
            if (sig != null) {
                return sig;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        StringBuilder sb = new StringBuilder("(");
        for (Class<?> c : m4.getParameterTypes()) {
            sig = Array.newInstance(c, 0).toString();
            sb.append(sig.substring(1, sig.indexOf(64)));
        }
        StringBuilder stringBuilder = sb.append(')');
        if (m4.getReturnType() == Void.TYPE) {
            string = "V";
        } else {
            sig = Array.newInstance(m4.getReturnType(), 0).toString();
            string = sig.substring(1, sig.indexOf(64));
        }
        return stringBuilder.append(string).toString();
    }

    public static Class<?> getReturnTypeFromSignature(String signature) {
        Class<?> actorClz;
        int startIndex = signature.indexOf(41);
        int endIndex = signature.lastIndexOf(59);
        String className = signature.substring(startIndex + 2, endIndex).replace('/', '.');
        try {
            try {
                actorClz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                ClassLoader cl = ((AbstractRayRuntime)Ray.internal()).getFunctionManager().getClassLoader();
                actorClz = Class.forName(className, true, cl);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return actorClz;
    }
}

